/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.hypersphere;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;

public class HyperSphereCursor<T>
implements Cursor<T> {
    final RandomAccessible<T> source;
    protected final long[] center;
    protected final RandomAccess<T> randomAccess;
    protected final long radius;
    final int numDimensions;
    final int maxDim;
    final long[] r;
    final long[] s;

    public HyperSphereCursor(RandomAccessible<T> source, long[] center, long radius) {
        this.source = source;
        this.center = (long[])center.clone();
        this.radius = radius;
        this.numDimensions = source.numDimensions();
        this.maxDim = this.numDimensions - 1;
        this.r = new long[this.numDimensions];
        this.s = new long[this.numDimensions];
        this.randomAccess = source.randomAccess();
        this.reset();
    }

    public HyperSphereCursor(HyperSphereCursor<T> cursor) {
        this.source = cursor.source;
        this.center = (long[])cursor.center.clone();
        this.radius = cursor.radius;
        this.numDimensions = cursor.numDimensions();
        this.maxDim = cursor.maxDim;
        this.r = (long[])cursor.r.clone();
        this.s = (long[])cursor.s.clone();
        this.randomAccess = this.source.randomAccess();
        this.randomAccess.setPosition(cursor.randomAccess);
    }

    public void updateCenter(long[] center) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.center[d] = center[d];
        }
        this.reset();
    }

    public void updateCenter(Localizable center) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.center[d] = center.getLongPosition(d);
        }
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.s[this.maxDim] > 0L;
    }

    @Override
    public void fwd() {
        int d;
        for (d = 0; d < this.numDimensions; ++d) {
            int n = d;
            this.s[n] = this.s[n] - 1L;
            if (this.s[n] >= 0L) {
                this.randomAccess.fwd(d);
                break;
            }
            this.r[d] = 0L;
            this.s[d] = 0L;
            this.randomAccess.setPosition(this.center[d], d);
        }
        if (d > 0) {
            int e = d - 1;
            long rd = this.r[d];
            long pd = rd - this.s[d];
            long rad = (long)Math.sqrt(rd * rd - pd * pd);
            this.s[e] = 2L * rad;
            this.r[e] = rad;
            this.randomAccess.setPosition(this.center[e] - rad, e);
        }
    }

    @Override
    public void reset() {
        int maxDim = this.numDimensions - 1;
        for (int d = 0; d < maxDim; ++d) {
            this.s[d] = 0L;
            this.r[d] = 0L;
            this.randomAccess.setPosition(this.center[d], d);
        }
        this.randomAccess.setPosition(this.center[maxDim] - this.radius - 1L, maxDim);
        this.r[maxDim] = this.radius;
        this.s[maxDim] = 1L + 2L * this.radius;
    }

    @Override
    public void jumpFwd(long steps) {
        for (long j = 0L; j < steps; ++j) {
            this.fwd();
        }
    }

    @Override
    public void localize(float[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.randomAccess.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.randomAccess.getDoublePosition(d);
    }

    @Override
    public int numDimensions() {
        return this.numDimensions;
    }

    @Override
    public T get() {
        return this.randomAccess.get();
    }

    @Override
    public T next() {
        this.fwd();
        return this.get();
    }

    @Override
    public void remove() {
    }

    @Override
    public void localize(int[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public void localize(long[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public int getIntPosition(int d) {
        return this.randomAccess.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.randomAccess.getLongPosition(d);
    }

    @Override
    public HyperSphereCursor<T> copyCursor() {
        return new HyperSphereCursor<T>(this);
    }

    @Override
    public HyperSphereCursor<T> copy() {
        return this.copyCursor();
    }
}

