/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.hypersphere;

import java.util.Iterator;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RandomAccessible;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.region.hypersphere.HyperSphereCursor;

public class HyperSphere<T>
implements IterableInterval<T> {
    final int numDimensions;
    long radius;
    final RandomAccessible<T> source;
    final long[] center;

    public HyperSphere(RandomAccessible<T> source, Localizable center, long radius) {
        this.numDimensions = source.numDimensions();
        this.source = source;
        this.center = new long[this.numDimensions];
        center.localize(this.center);
        this.updateRadius(radius);
    }

    public void updateCenter(long[] center) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.center[d] = center[d];
        }
    }

    public void updateCenter(Localizable center) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.center[d] = center.getLongPosition(d);
        }
    }

    public void updateRadius(long radius) {
        this.radius = radius;
    }

    protected long computeSize() {
        HyperSphereCursor<T> cursor = new HyperSphereCursor<T>(this.source, this.center, this.radius);
        long size = 0L;
        while (cursor.hasNext()) {
            cursor.fwd();
            ++size;
        }
        return size;
    }

    public void update(Localizable center, long radius) {
        this.updateCenter(center);
        this.updateRadius(radius);
    }

    public void update(long[] center, long radius) {
        this.updateCenter(center);
        this.updateRadius(radius);
    }

    @Override
    public long size() {
        return this.computeSize();
    }

    @Override
    public T firstElement() {
        HyperSphereCursor<T> cursor = new HyperSphereCursor<T>(this.source, this.center, this.radius);
        cursor.fwd();
        return cursor.get();
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public double realMin(int d) {
        return this.min(d);
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min[d] = this.center[d] - this.radius;
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min.setPosition(this.center[d] - this.radius, d);
        }
    }

    @Override
    public double realMax(int d) {
        return this.max(d);
    }

    @Override
    public void realMax(double[] max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max[d] = this.center[d] + this.radius;
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max.setPosition(this.center[d] - this.radius, d);
        }
    }

    @Override
    public int numDimensions() {
        return this.numDimensions;
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    @Override
    public long min(int d) {
        return this.center[d] - this.radius;
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min[d] = this.center[d] - this.radius;
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min.setPosition(this.center[d] - this.radius, d);
        }
    }

    @Override
    public long max(int d) {
        return this.center[d] + this.radius;
    }

    @Override
    public void max(long[] max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max[d] = this.center[d] + this.radius;
        }
    }

    @Override
    public void max(Positionable max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max.setPosition(this.center[d] + this.radius, d);
        }
    }

    @Override
    public void dimensions(long[] dimensions) {
        long size = this.radius * 2L + 1L;
        for (int d = 0; d < this.numDimensions; ++d) {
            dimensions[d] = size;
        }
    }

    @Override
    public long dimension(int d) {
        return this.radius * 2L + 1L;
    }

    @Override
    public HyperSphereCursor<T> cursor() {
        return this.localizingCursor();
    }

    @Override
    public HyperSphereCursor<T> localizingCursor() {
        return new HyperSphereCursor<T>(this.source, this.center, this.radius);
    }
}

