/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.integral;

import net.imglib2.RandomAccess;
import net.imglib2.algorithm.integral.IntegralImg;
import net.imglib2.converter.Converter;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.real.DoubleType;

public class IntegralImgDouble<R extends NumericType<R>>
extends IntegralImg<R, DoubleType> {
    public IntegralImgDouble(Img<R> img, DoubleType type, Converter<R, DoubleType> converter) {
        super(img, type, converter);
    }

    @Override
    protected void integrateLineDim0(Converter<R, DoubleType> converter, RandomAccess<R> cursorIn, RandomAccess<DoubleType> cursorOut, DoubleType sum, DoubleType tmpVar, long size) {
        converter.convert(cursorIn.get(), sum);
        ((DoubleType)cursorOut.get()).set(sum);
        double sum2 = sum.get();
        int i = 2;
        while ((long)i < size) {
            cursorIn.fwd(0);
            cursorOut.fwd(0);
            converter.convert(cursorIn.get(), tmpVar);
            ((DoubleType)cursorOut.get()).set(sum2 += tmpVar.get());
            ++i;
        }
    }

    @Override
    protected void integrateLine(int d, RandomAccess<DoubleType> cursor, DoubleType sum, long size) {
        double sum2 = ((DoubleType)cursor.get()).get();
        int i = 2;
        while ((long)i < size) {
            cursor.fwd(d);
            ((DoubleType)cursor.get()).set(sum2 += ((DoubleType)cursor.get()).get());
            ++i;
        }
    }
}

