/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gradient;

import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class PartialDerivative {
    public static <T extends NumericType<T>> void gradientCentralDifference2(RandomAccessible<T> source, RandomAccessibleInterval<T> gradient, int dimension) {
        Cursor<T> front = Views.flatIterable(Views.interval(source, Intervals.translate(gradient, 1L, dimension))).cursor();
        Cursor<T> back = Views.flatIterable(Views.interval(source, Intervals.translate(gradient, -1L, dimension))).cursor();
        for (NumericType t : Views.flatIterable(gradient)) {
            t.set((Type)front.next());
            t.sub((NumericType)back.next());
            t.mul(0.5);
        }
    }

    public static <T extends NumericType<T>> void gradientCentralDifference(RandomAccessible<T> source, RandomAccessibleInterval<T> gradient, int dimension) {
        int n = gradient.numDimensions();
        long[] min = new long[n];
        gradient.min(min);
        long[] max = new long[n];
        gradient.max(max);
        long[] shiftback = new long[n];
        for (int d = 0; d < n; ++d) {
            shiftback[d] = min[d] - max[d];
        }
        RandomAccess result = gradient.randomAccess();
        RandomAccess<T> back = source.randomAccess(Intervals.translate(gradient, 1L, dimension));
        RandomAccess<T> front = source.randomAccess(Intervals.translate(gradient, -1L, dimension));
        result.setPosition(min);
        back.setPosition(min);
        back.bck(dimension);
        front.setPosition(min);
        front.fwd(dimension);
        long max0 = max[0];
        block1: while (true) {
            NumericType t = (NumericType)result.get();
            t.set((Type)front.get());
            t.sub((NumericType)back.get());
            t.mul(0.5);
            if (result.getLongPosition(0) == max0) {
                if (n == 1) {
                    return;
                }
                result.move(shiftback[0], 0);
                back.move(shiftback[0], 0);
                front.move(shiftback[0], 0);
                int d = 1;
                while (true) {
                    if (d >= n) continue block1;
                    if (result.getLongPosition(d) == max[d]) {
                        result.move(shiftback[d], d);
                        back.move(shiftback[d], d);
                        front.move(shiftback[d], d);
                        if (d == n - 1) {
                            return;
                        }
                    } else {
                        result.fwd(d);
                        back.fwd(d);
                        front.fwd(d);
                        continue block1;
                    }
                    ++d;
                }
            }
            result.fwd(0);
            back.fwd(0);
            front.fwd(0);
        }
    }
}

