/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss3;

import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.SeparableSymmetricConvolution;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.type.numeric.NumericType;

public final class Gauss3 {
    public static <S extends NumericType<S>, T extends NumericType<T>> void gauss(double sigma, RandomAccessible<S> source, RandomAccessibleInterval<T> target) throws IncompatibleTypeException {
        int n = source.numDimensions();
        double[] s = new double[n];
        for (int d = 0; d < n; ++d) {
            s[d] = sigma;
        }
        Gauss3.gauss(s, source, target);
    }

    public static <S extends NumericType<S>, T extends NumericType<T>> void gauss(double[] sigma, RandomAccessible<S> source, RandomAccessibleInterval<T> target) throws IncompatibleTypeException {
        double[][] halfkernels = Gauss3.halfkernels(sigma);
        int numthreads = Runtime.getRuntime().availableProcessors();
        SeparableSymmetricConvolution.convolve(halfkernels, source, target, numthreads);
    }

    public static double[][] halfkernels(double[] sigma) {
        int n = sigma.length;
        double[][] halfkernels = new double[n][];
        for (int i = 0; i < n; ++i) {
            int size = Math.max(2, (int)(3.0 * sigma[i] + 0.5) + 1);
            halfkernels[i] = Gauss3.halfkernel(sigma[i], size, true);
        }
        return halfkernels;
    }

    public static double[] halfkernel(double sigma, int size, boolean normalize) {
        double two_sq_sigma = 2.0 * sigma * sigma;
        double[] kernel = new double[size];
        kernel[0] = 1.0;
        for (int x = 1; x < size; ++x) {
            kernel[x] = Math.exp((double)(-(x * x)) / two_sq_sigma);
        }
        if (normalize) {
            int x;
            double sum = 0.5;
            for (x = 1; x < size; ++x) {
                sum += kernel[x];
            }
            sum *= 2.0;
            x = 0;
            while (x < size) {
                int n = x++;
                kernel[n] = kernel[n] / sum;
            }
        }
        return kernel;
    }
}

