/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss3;

import java.lang.reflect.Array;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.gauss3.ConvolverFactory;
import net.imglib2.type.numeric.NumericType;

public class ConvolverNumericType<T extends NumericType<T>>
implements Runnable {
    private final double[] kernel;
    private final RandomAccess<T> in;
    private final RandomAccess<T> out;
    private final int d;
    private final int k;
    private final int k1;
    private final int k1k1;
    private final long linelen;
    final T[] buf;
    final T tmp;

    public static <T extends NumericType<T>> ConvolverNumericTypeFactory<T> factory(T type) {
        return new ConvolverNumericTypeFactory<T>(type);
    }

    private ConvolverNumericType(double[] kernel, RandomAccess<T> in, RandomAccess<T> out, int d, long lineLength, T type) {
        this.kernel = kernel;
        this.in = in;
        this.out = out;
        this.d = d;
        this.k = kernel.length;
        this.k1 = this.k - 1;
        this.k1k1 = this.k1 + this.k1;
        this.linelen = lineLength;
        int buflen = 2 * this.k - 1;
        this.buf = (NumericType[])Array.newInstance(type.getClass(), buflen);
        for (int i = 0; i < buflen; ++i) {
            this.buf[i] = (NumericType)type.createVariable();
        }
        this.tmp = (NumericType)type.createVariable();
    }

    private void next() {
        T first = this.buf[0];
        for (int i = 0; i < this.k1k1; ++i) {
            this.buf[i] = this.buf[i + 1];
        }
        this.buf[this.k1k1] = first;
        NumericType w = (NumericType)this.in.get();
        this.tmp.set((NumericType)w);
        this.tmp.mul(this.kernel[0]);
        this.buf[this.k1].add(this.tmp);
        for (int j = 1; j < this.k1; ++j) {
            this.tmp.set((NumericType)w);
            this.tmp.mul(this.kernel[j]);
            this.buf[this.k1 + j].add(this.tmp);
            this.buf[this.k1 - j].add(this.tmp);
        }
        this.tmp.set((NumericType)w);
        this.tmp.mul(this.kernel[this.k1]);
        this.buf[this.k1k1].set(this.tmp);
        this.in.fwd(this.d);
    }

    @Override
    public void run() {
        for (int i = 0; i < this.k1k1; ++i) {
            this.next();
        }
        for (long i = 0L; i < this.linelen; ++i) {
            this.next();
            this.tmp.add(this.buf[0]);
            ((NumericType)this.out.get()).set(this.tmp);
            this.out.fwd(this.d);
        }
    }

    /* synthetic */ ConvolverNumericType(double[] x0, RandomAccess x1, RandomAccess x2, int x3, long x4, NumericType x5, 1 x6) {
        this(x0, x1, x2, x3, x4, x5);
    }

    static class 1 {
    }

    public static final class ConvolverNumericTypeFactory<T extends NumericType<T>>
    implements ConvolverFactory<T, T> {
        private final T type;

        public ConvolverNumericTypeFactory(T type) {
            this.type = type;
        }

        @Override
        public Runnable create(double[] halfkernel, RandomAccess<T> in, RandomAccess<T> out, int d, long lineLength) {
            return new ConvolverNumericType(halfkernel, in, out, d, lineLength, (NumericType)this.type, null);
        }
    }
}

