/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.gauss.AbstractGauss;
import net.imglib2.algorithm.gauss.SamplingLineIterator;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayRandomAccess;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;

public class GaussNativeType<T extends NumericType<T> & NativeType<T>>
extends AbstractGauss<T> {
    protected boolean isArray;

    public GaussNativeType(double[] sigma, RandomAccessible<T> input, Interval interval, ImgFactory<T> factory, T type) {
        super(sigma, input, interval, factory.create(interval, type), new Point(sigma.length), factory, type);
    }

    public GaussNativeType(double[] sigma, RandomAccessible<T> input, Interval interval, RandomAccessible<T> output, Localizable outputOffset, ImgFactory<T> factory, T type) {
        super(sigma, input, interval, output, outputOffset, factory, type);
    }

    public GaussNativeType(double[] sigma, Img<T> input) {
        this(sigma, Views.extend(input, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE)), input, input.factory(), (NumericType)((NumericType)input.firstElement()).createVariable());
    }

    public GaussNativeType(double[] sigma, Img<T> input, OutOfBoundsFactory<T, Img<T>> outOfBounds) {
        this(sigma, Views.extend(input, outOfBounds), input, input.factory(), (NumericType)((NumericType)input.firstElement()).createVariable());
    }

    protected boolean isArray() {
        return this.isArray;
    }

    @Override
    protected Img<T> getProcessingLine(long sizeProcessLine) {
        NativeImg processLine;
        if (sizeProcessLine <= Integer.MAX_VALUE) {
            this.isArray = true;
            processLine = new ArrayImgFactory().create(new long[]{sizeProcessLine}, (NativeType)this.getProcessingType());
        } else {
            this.isArray = false;
            processLine = new CellImgFactory(0x7FFFFFF).create(new long[]{sizeProcessLine}, (NativeType)this.getProcessingType());
        }
        return processLine;
    }

    @Override
    protected void processLine(SamplingLineIterator<T> input, double[] kernel) {
        if (!this.isArray()) {
            super.processLine(input, kernel);
            return;
        }
        int kernelSize = kernel.length;
        int kernelSizeMinus1 = kernelSize - 1;
        int kernelSizeHalf = kernelSize / 2;
        int kernelSizeHalfMinus1 = kernelSizeHalf - 1;
        ArrayRandomAccess randomAccessLeft = (ArrayRandomAccess)input.randomAccessLeft;
        ArrayRandomAccess randomAccessRight = (ArrayRandomAccess)input.randomAccessRight;
        NumericType copy = (NumericType)input.copy;
        NumericType tmp = (NumericType)input.tmp;
        long imgSize = input.getProcessLine().size();
        if (imgSize >= (long)kernelSize) {
            copy.set((Type)input.get());
            randomAccessLeft.setPositionDim0(0);
            copy.mul(kernel[0]);
            ((NumericType)randomAccessLeft.get()).add(copy);
            for (int i = 1; i < kernelSizeMinus1; ++i) {
                input.fwd();
                copy.set((Type)input.get());
                randomAccessLeft.setPositionDim0(-1);
                for (int o = 0; o <= i; ++o) {
                    randomAccessLeft.fwdDim0();
                    tmp.set(copy);
                    tmp.mul(kernel[i - o]);
                    ((NumericType)randomAccessLeft.get()).add(tmp);
                }
            }
            long length = imgSize - (long)kernelSizeMinus1;
            for (long n = 0L; n < length; ++n) {
                input.fwd();
                copy.set((Type)input.get());
                randomAccessLeft.setPositionDim0(n);
                randomAccessRight.setPositionDim0(n + (long)kernelSizeMinus1);
                for (int k = 0; k < kernelSizeHalfMinus1; ++k) {
                    tmp.set(copy);
                    tmp.mul(kernel[k]);
                    ((NumericType)randomAccessLeft.get()).add(tmp);
                    ((NumericType)randomAccessRight.get()).add(tmp);
                    randomAccessLeft.fwdDim0();
                    randomAccessRight.bckDim0();
                }
                tmp.set(copy);
                tmp.mul(kernel[kernelSizeHalfMinus1]);
                ((NumericType)randomAccessLeft.get()).add(tmp);
                ((NumericType)randomAccessRight.get()).add(tmp);
                randomAccessLeft.fwdDim0();
                tmp.set(copy);
                tmp.mul(kernel[kernelSizeHalf]);
                ((NumericType)randomAccessLeft.get()).add(tmp);
            }
            long endLength = imgSize + (long)kernelSizeMinus1;
            for (long i = imgSize; i < endLength; ++i) {
                input.fwd();
                copy.set((Type)input.get());
                randomAccessLeft.setPositionDim0(i - (long)kernelSize);
                int k = 0;
                for (long o = i - (long)kernelSize + 1L; o < imgSize; ++o) {
                    randomAccessLeft.fwdDim0();
                    tmp.set(copy);
                    tmp.mul(kernel[k++]);
                    ((NumericType)randomAccessLeft.get()).add(tmp);
                }
            }
        } else {
            copy.set((Type)input.get());
            randomAccessLeft.setPositionDim0(0);
            copy.mul(kernel[0]);
            ((NumericType)randomAccessLeft.get()).add(copy);
            int i = 1;
            while ((long)i < imgSize) {
                input.fwd();
                copy.set((Type)input.get());
                randomAccessLeft.setPositionDim0(-1);
                for (int o = 0; o <= i; ++o) {
                    randomAccessLeft.fwdDim0();
                    tmp.set(copy);
                    tmp.mul(kernel[i - o]);
                    ((NumericType)randomAccessLeft.get()).add(tmp);
                }
                ++i;
            }
            for (long i2 = imgSize; i2 < imgSize + (long)kernelSizeMinus1; ++i2) {
                input.fwd();
                copy.set((Type)input.get());
                long o = i2 - (long)kernelSize + 1L;
                int k = 0;
                if (o < 0L) {
                    k = -((int)o);
                    o = 0L;
                }
                randomAccessLeft.setPositionDim0(o - 1L);
                while (o < imgSize) {
                    randomAccessLeft.fwdDim0();
                    tmp.set(copy);
                    tmp.mul(kernel[k++]);
                    ((NumericType)randomAccessLeft.get()).add(tmp);
                    ++o;
                }
            }
        }
    }
}

