/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.floydsteinberg;

import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.algorithm.stats.ComputeMinMax;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.iterator.ZeroMinIntervalIterator;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public class FloydSteinbergDithering<T extends RealType<T>>
implements OutputAlgorithm<Img<BitType>>,
Benchmark {
    Img<BitType> result;
    final Img<T> img;
    final Img<FloatType> errorDiffusionKernel;
    final long[] dim;
    final long[] tmp1;
    final long[] tmp2;
    final float ditheringThreshold;
    long processingTime;
    String errorMessage = "";

    public FloydSteinbergDithering(Img<T> img, float ditheringThreshold) {
        this.img = img;
        this.dim = Util.intervalDimensions(img);
        this.tmp1 = new long[img.numDimensions()];
        this.tmp2 = new long[img.numDimensions()];
        this.errorDiffusionKernel = this.createErrorDiffusionKernel(img.numDimensions());
        this.ditheringThreshold = ditheringThreshold;
    }

    public FloydSteinbergDithering(Img<T> img) {
        this(img, Float.NEGATIVE_INFINITY);
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        ComputeMinMax<T> cmm = new ComputeMinMax<T>(this.img);
        cmm.process();
        float minValue = ((RealType)cmm.getMin()).getRealFloat();
        float maxValue = ((RealType)cmm.getMax()).getRealFloat();
        long numDimensions = this.img.numDimensions();
        float ditheringThreshold = Float.NEGATIVE_INFINITY == this.ditheringThreshold ? (maxValue - minValue) / 2.0f : this.ditheringThreshold;
        try {
            this.result = this.img.factory().imgFactory(new BitType()).create(this.dim, new BitType());
        }
        catch (IncompatibleTypeException e) {
            throw new RuntimeException(e);
        }
        ZeroMinIntervalIterator cursor = new ZeroMinIntervalIterator(this.dim);
        RandomAccess cursorInput = new ExtendedRandomAccessibleInterval(this.img, new OutOfBoundsConstantValueFactory(((RealType)this.img.firstElement()).createVariable())).randomAccess(this.img);
        RandomAccess cursorOutput = this.result.randomAccess();
        Cursor cursorKernel = this.errorDiffusionKernel.cursor();
        while (cursor.hasNext()) {
            float error;
            cursor.fwd();
            cursorInput.setPosition(cursor);
            cursorOutput.setPosition(cursor);
            float in = ((RealType)cursorInput.get()).getRealFloat();
            if (in < ditheringThreshold) {
                ((BitType)cursorOutput.get()).setZero();
                error = in - minValue;
            } else {
                ((BitType)cursorOutput.get()).setOne();
                error = in - maxValue;
            }
            if (error == 0.0f) continue;
            cursorKernel.reset();
            cursorKernel.jumpFwd(this.errorDiffusionKernel.size() / 2L);
            cursor.localize(this.tmp1);
            while (cursorKernel.hasNext()) {
                cursorKernel.fwd();
                float value = error * ((FloatType)cursorKernel.get()).get();
                cursorKernel.localize(this.tmp2);
                int d = 0;
                while ((long)d < numDimensions) {
                    int n = d;
                    this.tmp2[n] = this.tmp2[n] + (this.tmp1[d] - 1L);
                    ++d;
                }
                cursorInput.move(this.tmp2);
                ((RealType)cursorInput.get()).setReal(((RealType)cursorInput.get()).getRealFloat() + value);
            }
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public Img<BitType> getResult() {
        return this.result;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Img<FloatType> createErrorDiffusionKernel(int numDimensions) {
        int i;
        ArrayImgFactory factory = new ArrayImgFactory();
        if (numDimensions == 2) {
            NativeImg kernel = factory.create(new long[]{3L, 3L}, new FloatType());
            RandomAccess cursor = kernel.randomAccess();
            cursor.setPosition(2, 0);
            cursor.setPosition(1, 1);
            ((FloatType)cursor.get()).setReal(0.4375f);
            cursor.move(1, 1);
            ((FloatType)cursor.get()).setReal(0.0625f);
            cursor.move(-1, 0);
            ((FloatType)cursor.get()).setReal(0.3125f);
            cursor.move(-1, 0);
            ((FloatType)cursor.get()).setReal(0.1875f);
            return kernel;
        }
        NativeImg kernel = factory.create(Util.getArrayFromValue(3L, numDimensions), new FloatType());
        Cursor cursor = kernel.cursor();
        int numValues = (int)(kernel.size() / 2L);
        float[] rndValues = new float[numValues];
        float sum = 0.0f;
        Random rnd = new Random(435345L);
        for (i = 0; i < numValues; ++i) {
            rndValues[i] = rnd.nextFloat();
            sum += rndValues[i];
        }
        i = 0;
        while (i < numValues) {
            int n = i++;
            rndValues[n] = rndValues[n] / sum;
        }
        int count = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            if (count > numValues) {
                ((FloatType)cursor.get()).setReal(rndValues[count - numValues - 1]);
            }
            ++count;
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            for (int d = 0; d < numDimensions; ++d) {
                cursor.reset();
                float sumD = 0.0f;
                while (cursor.hasNext()) {
                    cursor.fwd();
                    if (cursor.getIntPosition(d) == 1) continue;
                    sumD += ((FloatType)cursor.get()).get();
                }
                cursor.reset();
                while (cursor.hasNext()) {
                    cursor.fwd();
                    if (cursor.getIntPosition(d) == 1) continue;
                    ((FloatType)cursor.get()).set(((FloatType)cursor.get()).get() / sumD);
                }
            }
        }
        sum = 0.0f;
        cursor.reset();
        while (cursor.hasNext()) {
            cursor.fwd();
            sum += ((FloatType)cursor.get()).get();
        }
        cursor.reset();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((FloatType)cursor.get()).set(((FloatType)cursor.get()).get() / sum);
        }
        return kernel;
    }
}

