/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.pixellist;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.componenttree.Component;
import net.imglib2.algorithm.componenttree.ComponentTree;
import net.imglib2.algorithm.componenttree.pixellist.PixelListComponent;
import net.imglib2.algorithm.componenttree.pixellist.PixelListComponentGenerator;
import net.imglib2.algorithm.componenttree.pixellist.PixelListComponentIntermediate;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;

public final class PixelListComponentTree<T extends Type<T>>
implements Component.Handler<PixelListComponentIntermediate<T>>,
Iterable<PixelListComponent<T>> {
    private PixelListComponent<T> root = null;
    private final ArrayList<PixelListComponent<T>> nodes = new ArrayList();

    public static <T extends RealType<T>> PixelListComponentTree<T> buildComponentTree(RandomAccessibleInterval<T> input, T type, boolean darkToBright) {
        int numDimensions = input.numDimensions();
        long size = 1L;
        for (int d = 0; d < numDimensions; ++d) {
            size *= input.dimension(d);
        }
        if (size > Integer.MAX_VALUE) {
            int cellSize = (int)Math.pow(Integer.MAX_VALUE / new LongType().getEntitiesPerPixel(), 1.0 / (double)numDimensions);
            return PixelListComponentTree.buildComponentTree(input, type, new CellImgFactory<LongType>(cellSize), darkToBright);
        }
        return PixelListComponentTree.buildComponentTree(input, type, new ArrayImgFactory<LongType>(), darkToBright);
    }

    public static <T extends RealType<T>> PixelListComponentTree<T> buildComponentTree(RandomAccessibleInterval<T> input, T type, ImgFactory<LongType> imgFactory, boolean darkToBright) {
        RealType max = (RealType)type.createVariable();
        max.setReal(darkToBright ? type.getMaxValue() : type.getMinValue());
        PixelListComponentGenerator<RealType> generator = new PixelListComponentGenerator<RealType>(max, input, imgFactory);
        PixelListComponentTree<T> tree = new PixelListComponentTree<T>();
        ComponentTree.buildComponentTree(input, generator, tree, darkToBright);
        return tree;
    }

    public static <T extends Type<T>> PixelListComponentTree<T> buildComponentTree(RandomAccessibleInterval<T> input, T maxValue, Comparator<T> comparator) {
        int numDimensions = input.numDimensions();
        long size = 1L;
        for (int d = 0; d < numDimensions; ++d) {
            size *= input.dimension(d);
        }
        if (size > Integer.MAX_VALUE) {
            int cellSize = (int)Math.pow(Integer.MAX_VALUE / new LongType().getEntitiesPerPixel(), 1.0 / (double)numDimensions);
            return PixelListComponentTree.buildComponentTree(input, maxValue, comparator, new CellImgFactory<LongType>(cellSize));
        }
        return PixelListComponentTree.buildComponentTree(input, maxValue, comparator, new ArrayImgFactory<LongType>());
    }

    public static <T extends Type<T>> PixelListComponentTree<T> buildComponentTree(RandomAccessibleInterval<T> input, T maxValue, Comparator<T> comparator, ImgFactory<LongType> imgFactory) {
        PixelListComponentGenerator<T> generator = new PixelListComponentGenerator<T>(maxValue, input, imgFactory);
        PixelListComponentTree<T> tree = new PixelListComponentTree<T>();
        ComponentTree.buildComponentTree(input, generator, tree, comparator);
        return tree;
    }

    private PixelListComponentTree() {
    }

    @Override
    public void emit(PixelListComponentIntermediate<T> intermediate) {
        PixelListComponent<T> component = new PixelListComponent<T>(intermediate);
        this.root = component;
        this.nodes.add(component);
    }

    @Override
    public Iterator<PixelListComponent<T>> iterator() {
        return this.nodes.iterator();
    }

    public PixelListComponent<T> root() {
        return this.root;
    }
}

