/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.pixellist;

import java.util.ArrayList;
import net.imglib2.Localizable;
import net.imglib2.algorithm.componenttree.Component;
import net.imglib2.algorithm.componenttree.pixellist.PixelList;
import net.imglib2.algorithm.componenttree.pixellist.PixelListComponent;
import net.imglib2.algorithm.componenttree.pixellist.PixelListComponentGenerator;
import net.imglib2.type.Type;

final class PixelListComponentIntermediate<T extends Type<T>>
implements Component<T> {
    private final T value;
    final PixelList pixelList;
    final ArrayList<PixelListComponentIntermediate<T>> children;
    PixelListComponent<T> emittedComponent;

    PixelListComponentIntermediate(T value, PixelListComponentGenerator<T> generator) {
        this.pixelList = new PixelList(generator.linkedList.randomAccess(), generator.dimensions);
        this.value = value.copy();
        this.children = new ArrayList();
        this.emittedComponent = null;
    }

    @Override
    public void addPosition(Localizable position) {
        this.pixelList.addPosition(position);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value.set(value);
    }

    @Override
    public void merge(Component<T> component) {
        PixelListComponentIntermediate c = (PixelListComponentIntermediate)component;
        this.pixelList.merge(c.pixelList);
        this.children.add(c);
    }

    public String toString() {
        String s = "{" + this.value.toString() + " : ";
        boolean first = true;
        for (Localizable l : this.pixelList) {
            if (first) {
                first = false;
            } else {
                s = s + ", ";
            }
            s = s + l.toString();
        }
        return s + "}";
    }
}

