/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.pixellist;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.componenttree.Component;
import net.imglib2.algorithm.componenttree.pixellist.PixelListComponentIntermediate;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.LongType;

final class PixelListComponentGenerator<T extends Type<T>>
implements Component.Generator<T, PixelListComponentIntermediate<T>> {
    private final T maxValue;
    final long[] dimensions;
    final Img<LongType> linkedList;

    PixelListComponentGenerator(T maxValue, RandomAccessibleInterval<T> input, ImgFactory<LongType> imgFactory) {
        this.maxValue = maxValue;
        this.dimensions = new long[input.numDimensions()];
        input.dimensions(this.dimensions);
        this.linkedList = imgFactory.create(this.dimensions, new LongType());
    }

    @Override
    public PixelListComponentIntermediate<T> createComponent(T value) {
        return new PixelListComponentIntermediate<T>(value, this);
    }

    @Override
    public PixelListComponentIntermediate<T> createMaxComponent() {
        return new PixelListComponentIntermediate<T>(this.maxValue, this);
    }
}

