/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.pixellist;

import java.util.ArrayList;
import java.util.Iterator;
import net.imglib2.Localizable;
import net.imglib2.algorithm.componenttree.pixellist.PixelList;
import net.imglib2.algorithm.componenttree.pixellist.PixelListComponentIntermediate;
import net.imglib2.type.Type;

public final class PixelListComponent<T extends Type<T>>
implements Iterable<Localizable> {
    private final ArrayList<PixelListComponent<T>> children = new ArrayList();
    private PixelListComponent<T> parent = null;
    private final T value;
    private final PixelList pixelList;

    PixelListComponent(PixelListComponentIntermediate<T> intermediate) {
        this.value = intermediate.getValue().copy();
        this.pixelList = new PixelList(intermediate.pixelList);
        if (intermediate.emittedComponent != null) {
            this.children.add(intermediate.emittedComponent);
        }
        for (PixelListComponentIntermediate c : intermediate.children) {
            this.children.add(c.emittedComponent);
            c.emittedComponent.parent = this;
        }
        intermediate.emittedComponent = this;
        intermediate.children.clear();
    }

    public T value() {
        return this.value;
    }

    public long size() {
        return this.pixelList.size();
    }

    @Override
    public Iterator<Localizable> iterator() {
        return this.pixelList.iterator();
    }

    public ArrayList<PixelListComponent<T>> getChildren() {
        return this.children;
    }

    public PixelListComponent<T> getParent() {
        return this.parent;
    }
}

