/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.mser;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.componenttree.Component;
import net.imglib2.algorithm.componenttree.ComponentTree;
import net.imglib2.algorithm.componenttree.mser.ComputeDelta;
import net.imglib2.algorithm.componenttree.mser.ComputeDeltaBrightToDark;
import net.imglib2.algorithm.componenttree.mser.ComputeDeltaDarkToBright;
import net.imglib2.algorithm.componenttree.mser.Mser;
import net.imglib2.algorithm.componenttree.mser.MserComponentGenerator;
import net.imglib2.algorithm.componenttree.mser.MserComponentIntermediate;
import net.imglib2.algorithm.componenttree.mser.MserEvaluationNode;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;

public final class MserTree<T extends Type<T>>
implements Component.Handler<MserComponentIntermediate<T>>,
Iterable<Mser<T>> {
    private final HashSet<Mser<T>> roots = new HashSet();
    private final ArrayList<Mser<T>> nodes = new ArrayList();
    private final Comparator<T> comparator;
    private final ComputeDelta<T> delta;
    private final long minSize;
    private final long maxSize;
    private final double maxVar;
    private final double minDiversity;
    private int minimaFoundSinceLastPrune;
    private static final int pruneAfterNMinima = 1000;

    public static <T extends RealType<T>> MserTree<T> buildMserTree(RandomAccessibleInterval<T> input, double delta, long minSize, long maxSize, double maxVar, double minDiversity, boolean darkToBright) {
        return MserTree.buildMserTree(input, MserTree.getDeltaVariable(input, delta), minSize, maxSize, maxVar, minDiversity, darkToBright);
    }

    public static <T extends RealType<T>> MserTree<T> buildMserTree(RandomAccessibleInterval<T> input, T delta, long minSize, long maxSize, double maxVar, double minDiversity, boolean darkToBright) {
        int numDimensions = input.numDimensions();
        long size = 1L;
        for (int d = 0; d < numDimensions; ++d) {
            size *= input.dimension(d);
        }
        if (size > Integer.MAX_VALUE) {
            int cellSize = (int)Math.pow(Integer.MAX_VALUE / new LongType().getEntitiesPerPixel(), 1.0 / (double)numDimensions);
            return MserTree.buildMserTree(input, delta, minSize, maxSize, maxVar, minDiversity, new CellImgFactory<LongType>(cellSize), darkToBright);
        }
        return MserTree.buildMserTree(input, delta, minSize, maxSize, maxVar, minDiversity, new ArrayImgFactory<LongType>(), darkToBright);
    }

    public static <T extends RealType<T>> MserTree<T> buildMserTree(RandomAccessibleInterval<T> input, T delta, long minSize, long maxSize, double maxVar, double minDiversity, ImgFactory<LongType> imgFactory, boolean darkToBright) {
        RealType max = (RealType)delta.createVariable();
        max.setReal(darkToBright ? delta.getMaxValue() : delta.getMinValue());
        MserComponentGenerator<RealType> generator = new MserComponentGenerator<RealType>(max, input, imgFactory);
        Comparator comparator = darkToBright ? new ComponentTree.DarkToBright() : new ComponentTree.BrightToDark();
        ComputeDelta<T> computeDelta = darkToBright ? new ComputeDeltaDarkToBright<T>(delta) : new ComputeDeltaBrightToDark<T>(delta);
        MserTree tree = new MserTree(comparator, computeDelta, minSize, maxSize, maxVar, minDiversity);
        ComponentTree.buildComponentTree(input, generator, tree, comparator);
        super.pruneDuplicates();
        return tree;
    }

    public static <T extends Type<T>> MserTree<T> buildMserTree(RandomAccessibleInterval<T> input, ComputeDelta<T> computeDelta, long minSize, long maxSize, double maxVar, double minDiversity, T maxValue, Comparator<T> comparator) {
        int numDimensions = input.numDimensions();
        long size = 1L;
        for (int d = 0; d < numDimensions; ++d) {
            size *= input.dimension(d);
        }
        if (size > Integer.MAX_VALUE) {
            int cellSize = (int)Math.pow(Integer.MAX_VALUE / new LongType().getEntitiesPerPixel(), 1.0 / (double)numDimensions);
            return MserTree.buildMserTree(input, computeDelta, minSize, maxSize, maxVar, minDiversity, new CellImgFactory<LongType>(cellSize), maxValue, comparator);
        }
        return MserTree.buildMserTree(input, computeDelta, minSize, maxSize, maxVar, minDiversity, new ArrayImgFactory<LongType>(), maxValue, comparator);
    }

    public static <T extends Type<T>> MserTree<T> buildMserTree(RandomAccessibleInterval<T> input, ComputeDelta<T> computeDelta, long minSize, long maxSize, double maxVar, double minDiversity, ImgFactory<LongType> imgFactory, T maxValue, Comparator<T> comparator) {
        MserComponentGenerator<T> generator = new MserComponentGenerator<T>(maxValue, input, imgFactory);
        MserTree<T> tree = new MserTree<T>(comparator, computeDelta, minSize, maxSize, maxVar, minDiversity);
        ComponentTree.buildComponentTree(input, generator, tree, comparator);
        super.pruneDuplicates();
        return tree;
    }

    private static <T extends RealType<T>> T getDeltaVariable(RandomAccessibleInterval<T> input, double delta) {
        RandomAccess a = input.randomAccess();
        input.min(a);
        RealType deltaT = (RealType)((RealType)a.get()).createVariable();
        deltaT.setReal(delta);
        return (T)deltaT;
    }

    private MserTree(Comparator<T> comparator, ComputeDelta<T> delta, long minSize, long maxSize, double maxVar, double minDiversity) {
        this.comparator = comparator;
        this.delta = delta;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.maxVar = maxVar;
        this.minDiversity = minDiversity;
        this.minimaFoundSinceLastPrune = 0;
    }

    private void pruneDuplicates() {
        this.nodes.clear();
        for (Mser<T> mser : this.roots) {
            this.pruneChildren(mser);
        }
        this.nodes.addAll(this.roots);
    }

    private void pruneChildren(Mser<T> mser) {
        ArrayList validChildren = new ArrayList();
        for (int i = 0; i < mser.children.size(); ++i) {
            Mser m = mser.children.get(i);
            double div = (double)(mser.size() - m.size()) / (double)mser.size();
            if (div > this.minDiversity) {
                validChildren.add(m);
                this.pruneChildren(m);
                continue;
            }
            mser.children.addAll(m.children);
            for (Mser m2 : m.children) {
                m2.parent = mser;
            }
        }
        mser.children.clear();
        mser.children.addAll(validChildren);
        this.nodes.addAll(validChildren);
    }

    @Override
    public void emit(MserComponentIntermediate<T> component) {
        new MserEvaluationNode<T>(component, this.comparator, this.delta, this);
        component.children.clear();
    }

    void foundNewMinimum(MserEvaluationNode<T> node) {
        if (node.size >= this.minSize && node.size <= this.maxSize && node.score <= this.maxVar) {
            Mser<T> mser = new Mser<T>(node);
            for (Mser m : node.mserThisOrChildren) {
                mser.children.add(m);
            }
            node.mserThisOrChildren.clear();
            node.mserThisOrChildren.add(mser);
            for (Mser m : mser.children) {
                this.roots.remove(m);
            }
            this.roots.add(mser);
            this.nodes.add(mser);
            if (++this.minimaFoundSinceLastPrune == 1000) {
                this.minimaFoundSinceLastPrune = 0;
                this.pruneDuplicates();
            }
        }
    }

    public int size() {
        return this.nodes.size();
    }

    @Override
    public Iterator<Mser<T>> iterator() {
        return this.nodes.iterator();
    }

    public HashSet<Mser<T>> roots() {
        return this.roots;
    }
}

