/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.mser;

import java.util.ArrayList;
import java.util.Comparator;
import net.imglib2.algorithm.componenttree.mser.ComputeDelta;
import net.imglib2.algorithm.componenttree.mser.Mser;
import net.imglib2.algorithm.componenttree.mser.MserComponentIntermediate;
import net.imglib2.algorithm.componenttree.mser.MserTree;
import net.imglib2.algorithm.componenttree.pixellist.PixelList;
import net.imglib2.type.Type;

final class MserEvaluationNode<T extends Type<T>> {
    final T value;
    final long size;
    final PixelList pixelList;
    private final MserEvaluationNode<T> historyChild;
    private MserEvaluationNode<T> parent;
    double score;
    private boolean isScoreValid;
    final int n;
    final double[] mean;
    final double[] cov;
    final ArrayList<Mser<T>> mserThisOrChildren;

    MserEvaluationNode(MserComponentIntermediate<T> component, Comparator<T> comparator, ComputeDelta<T> delta, MserTree<T> tree) {
        this.value = component.getValue().copy();
        this.pixelList = new PixelList(component.pixelList);
        this.size = this.pixelList.size();
        ArrayList<MserEvaluationNode<T>> children = new ArrayList<MserEvaluationNode<T>>();
        MserEvaluationNode<T> node = component.getEvaluationNode();
        long historySize = 0L;
        if (node != null) {
            historySize = node.size;
            node = new MserEvaluationNode<T>(node, this.value, comparator, delta);
            children.add(node);
            super.setParent(this);
        }
        MserEvaluationNode<T> historyWinner = node;
        for (MserComponentIntermediate c : component.children) {
            node = new MserEvaluationNode(c.getEvaluationNode(), this.value, comparator, delta);
            children.add(node);
            super.setParent(this);
            if (c.size() <= historySize) continue;
            historyWinner = node;
            historySize = c.size();
        }
        this.historyChild = historyWinner;
        this.n = component.n;
        this.mean = new double[this.n];
        this.cov = new double[this.n * (this.n + 1) / 2];
        for (int i = 0; i < this.n; ++i) {
            this.mean[i] = component.sumPos[i] / (double)this.size;
        }
        int k = 0;
        for (int i = 0; i < this.n; ++i) {
            for (int j = i; j < this.n; ++j) {
                this.cov[k] = component.sumSquPos[k] / (double)this.size - this.mean[i] * this.mean[j];
                ++k;
            }
        }
        component.setEvaluationNode(this);
        this.isScoreValid = this.computeMserScore(delta, comparator, false);
        if (this.isScoreValid) {
            for (MserEvaluationNode mserEvaluationNode : children) {
                mserEvaluationNode.evaluateLocalMinimum(tree, delta, comparator);
            }
        }
        if (children.size() == 1) {
            this.mserThisOrChildren = ((MserEvaluationNode)children.get((int)0)).mserThisOrChildren;
        } else {
            this.mserThisOrChildren = new ArrayList();
            for (MserEvaluationNode mserEvaluationNode : children) {
                this.mserThisOrChildren.addAll(mserEvaluationNode.mserThisOrChildren);
            }
        }
    }

    private MserEvaluationNode(MserEvaluationNode<T> child, T value, Comparator<T> comparator, ComputeDelta<T> delta) {
        super.setParent(this);
        this.historyChild = child;
        this.size = child.size;
        this.pixelList = child.pixelList;
        this.value = value;
        this.n = child.n;
        this.mean = child.mean;
        this.cov = child.cov;
        this.isScoreValid = this.computeMserScore(delta, comparator, true);
        this.mserThisOrChildren = child.mserThisOrChildren;
    }

    private void setParent(MserEvaluationNode<T> node) {
        this.parent = node;
    }

    private boolean computeMserScore(ComputeDelta<T> delta, Comparator<T> comparator, boolean isIntermediate) {
        Type valueMinus = (Type)delta.valueMinusDelta(this.value);
        MserEvaluationNode<T> node = this.historyChild;
        while (node != null && comparator.compare((Type)node.value, valueMinus) > 0) {
            node = node.historyChild;
        }
        if (node == null) {
            return false;
        }
        if (isIntermediate && comparator.compare((Type)node.value, valueMinus) == 0 && node.historyChild != null) {
            node = node.historyChild;
        }
        this.score = (double)(this.size - node.size) / (double)this.size;
        return true;
    }

    private void evaluateLocalMinimum(MserTree<T> tree, ComputeDelta<T> delta, Comparator<T> comparator) {
        if (this.isScoreValid) {
            MserEvaluationNode<T> below = this.historyChild;
            while (below.isScoreValid && below.size == this.size) {
                below = below.historyChild;
            }
            if (below.isScoreValid) {
                below = below.historyChild;
                if (this.score <= below.score && this.score < this.parent.score) {
                    tree.foundNewMinimum(this);
                }
            } else {
                Type valueMinus = (Type)delta.valueMinusDelta(this.value);
                if (comparator.compare(valueMinus, (Type)below.value) > 0) {
                    tree.foundNewMinimum(this);
                }
            }
        }
    }

    public String toString() {
        String s = "SimpleMserEvaluationNode";
        s = s + ", size = " + this.size;
        s = s + ", history = [";
        MserEvaluationNode<T> node = this.historyChild;
        boolean first = true;
        while (node != null) {
            if (first) {
                first = false;
            } else {
                s = s + ", ";
            }
            s = s + "(" + node.value + "; " + node.size;
            s = node.isScoreValid ? s + " s " + node.score + ")" : s + " s --)";
            node = node.historyChild;
        }
        s = s + "]";
        return s;
    }
}

