/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.mser;

import java.util.ArrayList;
import net.imglib2.Localizable;
import net.imglib2.algorithm.componenttree.Component;
import net.imglib2.algorithm.componenttree.mser.MserComponentGenerator;
import net.imglib2.algorithm.componenttree.mser.MserEvaluationNode;
import net.imglib2.algorithm.componenttree.pixellist.PixelList;
import net.imglib2.type.Type;

final class MserComponentIntermediate<T extends Type<T>>
implements Component<T> {
    private final T value;
    final PixelList pixelList;
    final int n;
    final double[] sumPos;
    final double[] sumSquPos;
    private final long[] tmp;
    ArrayList<MserComponentIntermediate<T>> children;
    MserEvaluationNode<T> evaluationNode;

    MserComponentIntermediate(T value, MserComponentGenerator<T> generator) {
        this.pixelList = new PixelList(generator.linkedList.randomAccess(), generator.dimensions);
        this.n = generator.dimensions.length;
        this.sumPos = new double[this.n];
        this.sumSquPos = new double[this.n * (this.n + 1) / 2];
        this.value = value.copy();
        this.children = new ArrayList();
        this.evaluationNode = null;
        this.tmp = new long[this.n];
    }

    @Override
    public void addPosition(Localizable position) {
        this.pixelList.addPosition(position);
        position.localize(this.tmp);
        int k = 0;
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.sumPos[n] = this.sumPos[n] + (double)this.tmp[i];
            for (int j = i; j < this.n; ++j) {
                int n2 = k++;
                this.sumSquPos[n2] = this.sumSquPos[n2] + (double)(this.tmp[i] * this.tmp[j]);
            }
        }
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value.set(value);
    }

    @Override
    public void merge(Component<T> component) {
        int i;
        MserComponentIntermediate c = (MserComponentIntermediate)component;
        this.pixelList.merge(c.pixelList);
        for (i = 0; i < this.sumPos.length; ++i) {
            int n = i;
            this.sumPos[n] = this.sumPos[n] + c.sumPos[i];
        }
        for (i = 0; i < this.sumSquPos.length; ++i) {
            int n = i;
            this.sumSquPos[n] = this.sumSquPos[n] + c.sumSquPos[i];
        }
        this.children.add(c);
    }

    public String toString() {
        String s = "{" + this.value.toString() + " : ";
        boolean first = true;
        for (Localizable l : this.pixelList) {
            if (first) {
                first = false;
            } else {
                s = s + ", ";
            }
            s = s + l.toString();
        }
        return s + "}";
    }

    long size() {
        return this.pixelList.size();
    }

    MserEvaluationNode<T> getEvaluationNode() {
        return this.evaluationNode;
    }

    void setEvaluationNode(MserEvaluationNode<T> node) {
        this.evaluationNode = node;
    }
}

