/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.awt.image.IndexColorModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import loci.common.DataTools;
import loci.common.DebugTools;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.MinMaxCalculator;
import loci.formats.MissingLibraryException;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.TiffWriter;
import loci.formats.services.OMEXMLService;
import ome.xml.model.Image;
import ome.xml.model.OME;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageConverter.class);

    private ImageConverter() {
    }

    public static boolean testConvert(IFormatWriter writer, String[] args) throws FormatException, IOException {
        IFormatWriter w;
        DebugTools.enableLogging("INFO");
        String in = null;
        String out = null;
        String map = null;
        String compression = null;
        boolean stitch = false;
        boolean separate = false;
        boolean merge = false;
        boolean fill = false;
        boolean bigtiff = false;
        boolean group = true;
        boolean printVersion = false;
        boolean autoscale = false;
        int series = -1;
        int firstPlane = 0;
        int lastPlane = Integer.MAX_VALUE;
        int channel = -1;
        int zSection = -1;
        int timepoint = -1;
        int xCoordinate = 0;
        int yCoordinate = 0;
        int width = 0;
        int height = 0;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-") && args.length > 1) {
                    if (args[i].equals("-debug")) {
                        DebugTools.enableLogging("DEBUG");
                        continue;
                    }
                    if (args[i].equals("-stitch")) {
                        stitch = true;
                        continue;
                    }
                    if (args[i].equals("-separate")) {
                        separate = true;
                        continue;
                    }
                    if (args[i].equals("-merge")) {
                        merge = true;
                        continue;
                    }
                    if (args[i].equals("-expand")) {
                        fill = true;
                        continue;
                    }
                    if (args[i].equals("-bigtiff")) {
                        bigtiff = true;
                        continue;
                    }
                    if (args[i].equals("-map")) {
                        map = args[++i];
                        continue;
                    }
                    if (args[i].equals("-compression")) {
                        compression = args[++i];
                        continue;
                    }
                    if (args[i].equals("-nogroup")) {
                        group = false;
                        continue;
                    }
                    if (args[i].equals("-autoscale")) {
                        autoscale = true;
                        continue;
                    }
                    if (args[i].equals("-channel")) {
                        channel = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-z")) {
                        zSection = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-timepoint")) {
                        timepoint = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-series")) {
                        try {
                            series = Integer.parseInt(args[++i]);
                        }
                        catch (NumberFormatException exc) {}
                        continue;
                    }
                    if (args[i].equals("-range")) {
                        try {
                            firstPlane = Integer.parseInt(args[++i]);
                            lastPlane = Integer.parseInt(args[++i]) + 1;
                        }
                        catch (NumberFormatException exc) {}
                        continue;
                    }
                    if (args[i].equals("-crop")) {
                        String[] tokens = args[++i].split(",");
                        xCoordinate = Integer.parseInt(tokens[0]);
                        yCoordinate = Integer.parseInt(tokens[1]);
                        width = Integer.parseInt(tokens[2]);
                        height = Integer.parseInt(tokens[3]);
                        continue;
                    }
                    LOGGER.error("Found unknown command flag: {}; exiting.", (Object)args[i]);
                    return false;
                }
                if (args[i].equals("-version")) {
                    printVersion = true;
                    continue;
                }
                if (in == null) {
                    in = args[i];
                    continue;
                }
                if (out == null) {
                    out = args[i];
                    continue;
                }
                LOGGER.error("Found unknown argument: {}; exiting.", (Object)args[i]);
                LOGGER.error("You should specify exactly one input file and exactly one output file.");
                return false;
            }
        }
        if (printVersion) {
            LOGGER.info("Version: {}", (Object)"4.3.3-DEV");
            LOGGER.info("VCS revision: {}", (Object)"64520a9");
            LOGGER.info("Build date: {}", (Object)"16 May 2012");
            return true;
        }
        if (in == null || out == null) {
            String[] s = new String[]{"To convert a file between formats, run:", "  bfconvert [-debug] [-stitch] [-separate] [-merge] [-expand]", "    [-bigtiff] [-compression codec] [-series series] [-map id]", "    [-range start end] [-crop x,y,w,h] [-channel channel] [-z Z]", "    [-timepoint timepoint] [-nogroup] [-autoscale] [-version]", "    in_file out_file", "", "    -version: print the library version and exit", "      -debug: turn on debugging output", "     -stitch: stitch input files with similar names", "   -separate: split RGB images into separate channels", "      -merge: combine separate channels into RGB image", "     -expand: expand indexed color to RGB", "    -bigtiff: force BigTIFF files to be written", "-compression: specify the codec to use when saving images", "     -series: specify which image series to convert", "        -map: specify file on disk to which name should be mapped", "      -range: specify range of planes to convert (inclusive)", "    -nogroup: force multi-file datasets to be read as individual              files", "  -autoscale: automatically adjust brightness and contrast before", "              converting; this may mean that the original pixel", "              values are not preserved", "       -crop: crop images before converting; argument is 'x,y,w,h'", "    -channel: only convert the specified channel (indexed from 0)", "          -z: only convert the specified Z section (indexed from 0)", "  -timepoint: only convert the specified timepoint (indexed from 0)", "", "If any of the following patterns are present in out_file, they will", "be replaced with the indicated metadata value from the input file.", "", "   Pattern:\tMetadata value:", "   ---------------------------", "   %s\t\tseries index", "   %n\t\tseries name", "   %c\t\tchannel index", "   %w\t\tchannel name", "   %z\t\tZ index", "   %t\t\tT index", "   %A\t\tacquisition timestamp", "", "If any of these patterns are present, then the images to be saved", "will be split into multiple files.  For example, if the input file", "contains 5 Z sections and 3 timepoints, and out_file is", "", "  converted_Z%z_T%t.tiff", "", "then 15 files will be created, with the names", "", "  converted_Z0_T0.tiff", "  converted_Z0_T1.tiff", "  converted_Z0_T2.tiff", "  converted_Z1_T0.tiff", "  ...", "  converted_Z4_T2.tiff", "", "Each file would have a single image plane."};
            for (int i = 0; i < s.length; ++i) {
                LOGGER.info(s[i]);
            }
            return false;
        }
        if (new Location(out).exists()) {
            boolean overwrite;
            LOGGER.warn("Output file {} exists.", out);
            LOGGER.warn("Do you want to overwrite it? ([y]/n)");
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
            String choice = r.readLine().trim().toLowerCase();
            boolean bl = overwrite = !choice.startsWith("n");
            if (!overwrite) {
                LOGGER.warn("Exiting; next time, please specify an output file that does not exist.");
                return false;
            }
            new Location(out).delete();
        }
        if (map != null) {
            Location.mapId(in, map);
        }
        long start = System.currentTimeMillis();
        LOGGER.info(in);
        IFormatReader reader = new ImageReader();
        if (stitch) {
            reader = new FileStitcher(reader);
            Location f = new Location(in);
            String pat = null;
            pat = !f.exists() ? in : FilePattern.findPattern(f);
            if (pat != null) {
                in = pat;
            }
        }
        if (separate) {
            reader = new ChannelSeparator(reader);
        }
        if (merge) {
            reader = new ChannelMerger(reader);
        }
        if (fill) {
            reader = new ChannelFiller(reader);
        }
        MinMaxCalculator minMax = null;
        if (autoscale) {
            reader = new MinMaxCalculator(reader);
            minMax = (MinMaxCalculator)reader;
        }
        reader.setGroupFiles(group);
        reader.setMetadataFiltered(true);
        reader.setOriginalMetadataPopulated(true);
        OMEXMLService service = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            service = factory.getInstance(OMEXMLService.class);
            reader.setMetadataStore(service.createOMEXMLMetadata());
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.loci.wisc.edu/bio-formats/bio-formats-java-library", de);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        reader.setId(in);
        MetadataStore store = reader.getMetadataStore();
        MetadataTools.populatePixels(store, reader, false, false);
        boolean dimensionsSet = true;
        if (width == 0 || height == 0) {
            width = reader.getSizeX();
            height = reader.getSizeY();
            dimensionsSet = false;
        }
        if (store instanceof MetadataRetrieve) {
            if (series >= 0) {
                try {
                    String xml = service.getOMEXML(service.asRetrieve(store));
                    OME root = (OME)store.getRoot();
                    Image exportImage = root.getImage(series);
                    OMEXMLMetadata meta = service.createOMEXMLMetadata(xml);
                    OME newRoot = (OME)meta.getRoot();
                    while (newRoot.sizeOfImageList() > 0) {
                        newRoot.removeImage(newRoot.getImage(0));
                    }
                    newRoot.addImage(exportImage);
                    meta.setRoot(newRoot);
                    meta.setPixelsSizeX(new PositiveInteger(Integer.valueOf(width)), 0);
                    meta.setPixelsSizeY(new PositiveInteger(Integer.valueOf(height)), 0);
                    if (autoscale) {
                        store.setPixelsType(PixelType.UINT8, 0);
                    }
                    writer.setMetadataRetrieve(meta);
                }
                catch (ServiceException e) {
                    throw new FormatException(e);
                }
            } else {
                for (int i = 0; i < reader.getSeriesCount(); ++i) {
                    if (width != reader.getSizeX() || height != reader.getSizeY()) {
                        store.setPixelsSizeX(new PositiveInteger(Integer.valueOf(width)), 0);
                        store.setPixelsSizeY(new PositiveInteger(Integer.valueOf(height)), 0);
                    }
                    if (!autoscale) continue;
                    store.setPixelsType(PixelType.UINT8, i);
                }
                writer.setMetadataRetrieve((MetadataRetrieve)((Object)store));
            }
        }
        writer.setWriteSequentially(true);
        if (writer instanceof TiffWriter) {
            ((TiffWriter)writer).setBigTiff(bigtiff);
        } else if (writer instanceof ImageWriter && (w = ((ImageWriter)writer).getWriter(out)) instanceof TiffWriter) {
            ((TiffWriter)w).setBigTiff(bigtiff);
        }
        String format = writer.getFormat();
        LOGGER.info("[{}] -> {} [{}]", new Object[]{reader.getFormat(), out, format});
        long mid = System.currentTimeMillis();
        int total = 0;
        int num = writer.canDoStacks() ? reader.getSeriesCount() : 1;
        long read = 0L;
        long write = 0L;
        int first = series == -1 ? 0 : series;
        int last = series == -1 ? num : series + 1;
        long timeLastLogged = System.currentTimeMillis();
        for (int q = first; q < last; ++q) {
            reader.setSeries(q);
            if (!dimensionsSet) {
                width = reader.getSizeX();
                height = reader.getSizeY();
            }
            int writerSeries = series == -1 ? q : 0;
            writer.setSeries(writerSeries);
            writer.setInterleaved(reader.isInterleaved() && !autoscale);
            writer.setValidBitsPerPixel(reader.getBitsPerPixel());
            int numImages = writer.canDoStacks() ? reader.getImageCount() : 1;
            int startPlane = Math.max(0, firstPlane);
            int endPlane = Math.min(numImages, lastPlane);
            numImages = endPlane - startPlane;
            if (channel >= 0) {
                numImages /= reader.getEffectiveSizeC();
            }
            if (zSection >= 0) {
                numImages /= reader.getSizeZ();
            }
            if (timepoint >= 0) {
                numImages /= reader.getSizeT();
            }
            total += numImages;
            int count = 0;
            for (int i = startPlane; i < endPlane; ++i) {
                byte[][] lut;
                int[] coords = reader.getZCTCoords(i);
                if (zSection >= 0 && coords[0] != zSection || channel >= 0 && coords[1] != channel || timepoint >= 0 && coords[2] != timepoint) continue;
                writer.setId(FormatTools.getFilename(q, i, reader, out));
                if (compression != null) {
                    writer.setCompression(compression);
                }
                long s = System.currentTimeMillis();
                byte[] buf = reader.openBytes(i, xCoordinate, yCoordinate, width, height);
                if (autoscale) {
                    Double min = null;
                    Double max = null;
                    Double[] planeMin = minMax.getPlaneMinimum(i);
                    Double[] planeMax = minMax.getPlaneMaximum(i);
                    if (planeMin != null && planeMax != null) {
                        min = planeMin[0];
                        max = planeMax[0];
                        for (int j = 1; j < planeMin.length; ++j) {
                            if (planeMin[j] < min) {
                                min = planeMin[j];
                            }
                            if (!(planeMax[j] < max)) continue;
                            max = planeMax[j];
                        }
                    }
                    int pixelType = reader.getPixelType();
                    int bpp = FormatTools.getBytesPerPixel(pixelType);
                    boolean floatingPoint = FormatTools.isFloatingPoint(pixelType);
                    Object pix = DataTools.makeDataArray(buf, bpp, floatingPoint, reader.isLittleEndian());
                    byte[][] b = ImageTools.make24Bits(pix, width, height, reader.isInterleaved(), false, min, max);
                    int channelCount = reader.getRGBChannelCount();
                    int copyComponents = Math.min(channelCount, b.length);
                    buf = new byte[channelCount * b[0].length];
                    for (int j = 0; j < copyComponents; ++j) {
                        System.arraycopy(b[j], 0, buf, b[0].length * j, b[0].length);
                    }
                }
                if ((lut = reader.get8BitLookupTable()) != null) {
                    IndexColorModel model = new IndexColorModel(8, lut[0].length, lut[0], lut[1], lut[2]);
                    writer.setColorModel(model);
                }
                long m = System.currentTimeMillis();
                writer.saveBytes(i - startPlane, buf);
                long e = System.currentTimeMillis();
                read += m - s;
                write += e - m;
                if (count == numImages - 1 || (e - timeLastLogged) / 1000L > 0L) {
                    int current = count - startPlane + 1;
                    int percent = 100 * current / numImages;
                    StringBuilder sb = new StringBuilder();
                    sb.append("\t");
                    int numSeries = last - first;
                    if (numSeries > 1) {
                        sb.append("Series ");
                        sb.append(q);
                        sb.append(": converted ");
                    } else {
                        sb.append("Converted ");
                    }
                    LOGGER.info(sb.toString() + "{}/{} planes ({}%)", new Object[]{current, numImages, percent});
                    timeLastLogged = e;
                }
                ++count;
            }
        }
        writer.close();
        long end = System.currentTimeMillis();
        LOGGER.info("[done]");
        float sec = (float)(end - start) / 1000.0f;
        long initial = mid - start;
        float readAvg = (float)read / (float)total;
        float writeAvg = (float)write / (float)total;
        LOGGER.info("{}s elapsed ({}+{}ms per plane, {}ms overhead)", new Object[]{Float.valueOf(sec), Float.valueOf(readAvg), Float.valueOf(writeAvg), initial});
        return true;
    }

    public static void main(String[] args) throws FormatException, IOException {
        if (!ImageConverter.testConvert(new ImageWriter(), args)) {
            System.exit(1);
        }
        System.exit(0);
    }
}

