/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import loci.formats.FormatException;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffRational;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFD
extends HashMap<Integer, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IFD.class);
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_TIFF = 1;
    public static final int REUSE = 3;
    public static final int WRITERAW = 4;
    public static Set<Integer> nonIFDtags = new HashSet<Integer>(Arrays.asList(0, 1, 3, 4));
    public static final int NEW_SUBFILE_TYPE = 254;
    public static final int SUBFILE_TYPE = 255;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRIC_INTERPRETATION = 262;
    public static final int THRESHHOLDING = 263;
    public static final int CELL_WIDTH = 264;
    public static final int CELL_LENGTH = 265;
    public static final int FILL_ORDER = 266;
    public static final int DOCUMENT_NAME = 269;
    public static final int IMAGE_DESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIP_OFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLES_PER_PIXEL = 277;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNTS = 279;
    public static final int MIN_SAMPLE_VALUE = 280;
    public static final int MAX_SAMPLE_VALUE = 281;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int PLANAR_CONFIGURATION = 284;
    public static final int PAGE_NAME = 285;
    public static final int X_POSITION = 286;
    public static final int Y_POSITION = 287;
    public static final int FREE_OFFSETS = 288;
    public static final int FREE_BYTE_COUNTS = 289;
    public static final int GRAY_RESPONSE_UNIT = 290;
    public static final int GRAY_RESPONSE_CURVE = 291;
    public static final int T4_OPTIONS = 292;
    public static final int T6_OPTIONS = 293;
    public static final int RESOLUTION_UNIT = 296;
    public static final int PAGE_NUMBER = 297;
    public static final int TRANSFER_FUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATE_TIME = 306;
    public static final int ARTIST = 315;
    public static final int HOST_COMPUTER = 316;
    public static final int PREDICTOR = 317;
    public static final int WHITE_POINT = 318;
    public static final int PRIMARY_CHROMATICITIES = 319;
    public static final int COLOR_MAP = 320;
    public static final int HALFTONE_HINTS = 321;
    public static final int TILE_WIDTH = 322;
    public static final int TILE_LENGTH = 323;
    public static final int TILE_OFFSETS = 324;
    public static final int TILE_BYTE_COUNTS = 325;
    public static final int SUB_IFD = 330;
    public static final int INK_SET = 332;
    public static final int INK_NAMES = 333;
    public static final int NUMBER_OF_INKS = 334;
    public static final int DOT_RANGE = 336;
    public static final int TARGET_PRINTER = 337;
    public static final int EXTRA_SAMPLES = 338;
    public static final int SAMPLE_FORMAT = 339;
    public static final int S_MIN_SAMPLE_VALUE = 340;
    public static final int S_MAX_SAMPLE_VALUE = 341;
    public static final int TRANSFER_RANGE = 342;
    public static final int JPEG_TABLES = 347;
    public static final int JPEG_PROC = 512;
    public static final int JPEG_INTERCHANGE_FORMAT = 513;
    public static final int JPEG_INTERCHANGE_FORMAT_LENGTH = 514;
    public static final int JPEG_RESTART_INTERVAL = 515;
    public static final int JPEG_LOSSLESS_PREDICTORS = 517;
    public static final int JPEG_POINT_TRANSFORMS = 518;
    public static final int JPEG_Q_TABLES = 519;
    public static final int JPEG_DC_TABLES = 520;
    public static final int JPEG_AC_TABLES = 521;
    public static final int Y_CB_CR_COEFFICIENTS = 529;
    public static final int Y_CB_CR_SUB_SAMPLING = 530;
    public static final int Y_CB_CR_POSITIONING = 531;
    public static final int REFERENCE_BLACK_WHITE = 532;
    public static final int COPYRIGHT = 33432;
    public static final int EXIF = 34665;
    public static final int EXPOSURE_TIME = 33434;
    public static final int F_NUMBER = 33437;
    public static final int EXPOSURE_PROGRAM = 34850;
    public static final int SPECTRAL_SENSITIVITY = 34852;
    public static final int ISO_SPEED_RATINGS = 34855;
    public static final int OECF = 34856;
    public static final int EXIF_VERSION = 36864;
    public static final int DATE_TIME_ORIGINAL = 36867;
    public static final int DATE_TIME_DIGITIZED = 36868;
    public static final int COMPONENTS_CONFIGURATION = 37121;
    public static final int COMPRESSED_BITS_PER_PIXEL = 37122;
    public static final int SHUTTER_SPEED_VALUE = 37377;
    public static final int APERTURE_VALUE = 37378;
    public static final int BRIGHTNESS_VALUE = 37379;
    public static final int EXPOSURE_BIAS_VALUE = 37380;
    public static final int MAX_APERTURE_VALUE = 37381;
    public static final int SUBJECT_DISTANCE = 37382;
    public static final int METERING_MODE = 37383;
    public static final int LIGHT_SOURCE = 37384;
    public static final int FLASH = 37385;
    public static final int FOCAL_LENGTH = 37386;
    public static final int MAKER_NOTE = 37500;
    public static final int USER_COMMENT = 37510;
    public static final int SUB_SEC_TIME = 37520;
    public static final int SUB_SEC_TIME_ORIGINAL = 37521;
    public static final int SUB_SEC_TIME_DIGITIZED = 37522;
    public static final int FLASH_PIX_VERSION = 40960;
    public static final int COLOR_SPACE = 40961;
    public static final int PIXEL_X_DIMENSION = 40962;
    public static final int PIXEL_Y_DIMENSION = 40963;
    public static final int RELATED_SOUND_FILE = 40964;
    public static final int FLASH_ENERGY = 41483;
    public static final int SPATIAL_FREQUENCY_RESPONSE = 41484;
    public static final int FOCAL_PLANE_X_RESOLUTION = 41486;
    public static final int FOCAL_PLANE_Y_RESOLUTION = 41487;
    public static final int FOCAL_PLANE_RESOLUTION_UNIT = 41488;
    public static final int SUBJECT_LOCATION = 41492;
    public static final int EXPOSURE_INDEX = 41493;
    public static final int SENSING_METHOD = 41495;
    public static final int FILE_SOURCE = 41728;
    public static final int SCENE_TYPE = 41729;
    public static final int CFA_PATTERN = 41730;
    public static final int CUSTOM_RENDERED = 41985;
    public static final int EXPOSURE_MODE = 41986;
    public static final int WHITE_BALANCE = 41987;
    public static final int DIGITAL_ZOOM_RATIO = 41988;
    public static final int FOCAL_LENGTH_35MM_FILM = 41989;
    public static final int SCENE_CAPTURE_TYPE = 41990;
    public static final int GAIN_CONTROL = 41991;
    public static final int CONTRAST = 41992;
    public static final int SATURATION = 41993;
    public static final int SHARPNESS = 41994;
    public static final int SUBJECT_DISTANCE_RANGE = 41996;

    public IFD() {
    }

    public IFD(IFD ifd) {
        super(ifd);
    }

    public boolean isBigTiff() throws FormatException {
        return (Boolean)this.getIFDValue(1, Boolean.class);
    }

    public boolean isLittleEndian() throws FormatException {
        return (Boolean)this.getIFDValue(0, Boolean.class);
    }

    public boolean isWriteRaw() throws FormatException {
        Boolean b = (Boolean)this.getIFDValue(4, Boolean.class);
        if (b == null) {
            return false;
        }
        return b;
    }

    public Object getIFDValue(int tag) {
        return this.get(new Integer(tag));
    }

    public Object getIFDValue(int tag, Class checkClass) throws FormatException {
        Object value = this.get(new Integer(tag));
        if (checkClass != null && value != null && !checkClass.isInstance(value)) {
            Class<?> cType = checkClass.getComponentType();
            Object array = Array.newInstance(cType == null ? value.getClass() : cType, 1);
            if (cType == value.getClass()) {
                Array.set(array, 0, value);
            } else if (cType == Boolean.TYPE && value instanceof Boolean) {
                Array.setBoolean(array, 0, (Boolean)value);
            } else if (cType == Byte.TYPE && value instanceof Byte) {
                Array.setByte(array, 0, (Byte)value);
            } else if (cType == Character.TYPE && value instanceof Character) {
                Array.setChar(array, 0, ((Character)value).charValue());
            } else if (cType == Double.TYPE && value instanceof Double) {
                Array.setDouble(array, 0, (Double)value);
            } else if (cType == Float.TYPE && value instanceof Float) {
                Array.setFloat(array, 0, ((Float)value).floatValue());
            } else if (cType == Integer.TYPE && value instanceof Integer) {
                Array.setInt(array, 0, (Integer)value);
            } else if (cType == Long.TYPE && value instanceof Long) {
                Array.setLong(array, 0, (Long)value);
            } else if (cType == Short.TYPE && value instanceof Short) {
                Array.setShort(array, 0, (Short)value);
            } else {
                try {
                    value = Array.get(value, 0);
                    if (checkClass.isInstance(value)) {
                        return value;
                    }
                }
                catch (IllegalArgumentException exc) {
                    // empty catch block
                }
                throw new FormatException(IFD.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected " + checkClass.getName());
            }
            return array;
        }
        return value;
    }

    public long getIFDLongValue(int tag, long defaultValue) throws FormatException {
        long value = defaultValue;
        Number number = (Number)this.getIFDValue(tag, Number.class);
        if (number != null) {
            value = number.longValue();
        }
        return value;
    }

    public int getIFDIntValue(int tag) {
        int value = -1;
        try {
            value = this.getIFDIntValue(tag, -1);
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return value;
    }

    public int getIFDIntValue(int tag, int defaultValue) throws FormatException {
        int value = defaultValue;
        Number number = (Number)this.getIFDValue(tag, Number.class);
        if (number != null) {
            value = number.intValue();
        }
        return value;
    }

    public TiffRational getIFDRationalValue(int tag) throws FormatException {
        return (TiffRational)this.getIFDValue(tag, TiffRational.class);
    }

    public String getIFDStringValue(int tag) throws FormatException {
        return (String)this.getIFDValue(tag, String.class);
    }

    public String getIFDTextValue(int tag) {
        String value = null;
        Object o = this.getIFDValue(tag);
        if (o instanceof String[]) {
            StringBuilder sb = new StringBuilder();
            String[] s = (String[])o;
            for (int i = 0; i < s.length; ++i) {
                sb.append(s[i]);
                if (i >= s.length - 1) continue;
                sb.append("\n");
            }
            value = sb.toString();
        } else if (o instanceof short[]) {
            StringBuffer sb = new StringBuffer();
            for (short s : (short[])o) {
                if (!Character.isISOControl((char)s)) {
                    sb.append((char)s);
                    continue;
                }
                if (s == 0) continue;
                sb.append("\n");
            }
            value = sb.toString();
        } else if (o != null) {
            value = o.toString();
        }
        if (value != null) {
            value = value.replaceAll("\r\n", "\n");
            value = value.replaceAll("\r", "\n");
        }
        return value;
    }

    public long[] getIFDLongArray(int tag) throws FormatException {
        Object value = this.getIFDValue(tag);
        long[] results = null;
        if (value instanceof long[]) {
            results = (long[])value;
        } else if (value instanceof Number) {
            results = new long[]{((Number)value).longValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new long[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].longValue();
            }
        } else if (value instanceof int[]) {
            int[] integers = (int[])value;
            results = new long[integers.length];
            for (int i = 0; i < integers.length; ++i) {
                results[i] = integers[i];
            }
        } else if (value != null) {
            throw new FormatException(IFD.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, long[], Number[] or int[])");
        }
        return results;
    }

    public int[] getIFDIntArray(int tag) throws FormatException {
        Object value = this.getIFDValue(tag);
        int[] results = null;
        if (value instanceof int[]) {
            results = (int[])value;
        } else if (value instanceof long[]) {
            long[] v = (long[])value;
            results = new int[v.length];
            for (int i = 0; i < v.length; ++i) {
                results[i] = (int)v[i];
            }
        } else if (value instanceof Number) {
            results = new int[]{((Number)value).intValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new int[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].intValue();
            }
        } else if (value != null) {
            throw new FormatException(IFD.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, int[] or Number[])");
        }
        return results;
    }

    public short[] getIFDShortArray(int tag) throws FormatException {
        Object value = this.getIFDValue(tag);
        short[] results = null;
        if (value instanceof short[]) {
            results = (short[])value;
        } else if (value instanceof int[]) {
            int[] v = (int[])value;
            results = new short[v.length];
            for (int i = 0; i < v.length; ++i) {
                results[i] = (short)v[i];
            }
        } else if (value instanceof Number) {
            results = new short[]{((Number)value).shortValue()};
        } else if (value instanceof Number[]) {
            Number[] numbers = (Number[])value;
            results = new short[numbers.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = numbers[i].shortValue();
            }
        } else if (value != null) {
            throw new FormatException(IFD.getIFDTagName(tag) + " directory entry is the wrong type (got " + value.getClass().getName() + ", expected Number, short[] or Number[])");
        }
        return results;
    }

    public String getComment() {
        return this.getIFDTextValue(270);
    }

    public long getTileWidth() throws FormatException {
        long tileWidth = this.getIFDLongValue(322, 0L);
        return tileWidth == 0L ? this.getImageWidth() : tileWidth;
    }

    public long getTileLength() throws FormatException {
        long tileLength = this.getIFDLongValue(323, 0L);
        return tileLength == 0L ? this.getRowsPerStrip()[0] : tileLength;
    }

    public long getTilesPerRow() throws FormatException {
        long tileWidth = this.getTileWidth();
        long imageWidth = this.getImageWidth();
        long nTiles = imageWidth / tileWidth;
        if (nTiles * tileWidth < imageWidth) {
            ++nTiles;
        }
        return nTiles;
    }

    public long getTilesPerColumn() throws FormatException {
        long tileLength = this.getTileLength();
        long imageLength = this.getImageLength();
        long nTiles = imageLength / tileLength;
        if (nTiles * tileLength < imageLength) {
            ++nTiles;
        }
        return nTiles;
    }

    public boolean isTiled() throws FormatException {
        Object offsets = this.get(new Integer(273));
        Object tileWidth = this.get(new Integer(322));
        return offsets == null && tileWidth != null;
    }

    public long getImageWidth() throws FormatException {
        long width = this.getIFDLongValue(256, 0L);
        if (width > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageWidth > 2147483647 is not supported.");
        }
        return width;
    }

    public long getImageLength() throws FormatException {
        long length = this.getIFDLongValue(257, 0L);
        if (length > Integer.MAX_VALUE) {
            throw new FormatException("Sorry, ImageLength > 2147483647 is not supported.");
        }
        return length;
    }

    public int[] getBitsPerSample() throws FormatException {
        int samplesPerPixel;
        int[] bitsPerSample = this.getIFDIntArray(258);
        if (bitsPerSample == null) {
            bitsPerSample = new int[]{1};
        }
        if (bitsPerSample.length < (samplesPerPixel = this.getSamplesPerPixel())) {
            LOGGER.debug("BitsPerSample length ({}) does not match SamplesPerPixel ({})", (Object)bitsPerSample.length, (Object)samplesPerPixel);
            int bits = bitsPerSample[0];
            bitsPerSample = new int[samplesPerPixel];
            Arrays.fill(bitsPerSample, bits);
        }
        int nSamples = Math.min(bitsPerSample.length, samplesPerPixel);
        for (int i = 0; i < nSamples; ++i) {
            if (bitsPerSample[i] >= 1) continue;
            throw new FormatException("Illegal BitsPerSample (" + bitsPerSample[i] + ")");
        }
        return bitsPerSample;
    }

    public int getPixelType() throws FormatException {
        int bps = this.getBitsPerSample()[0];
        int bitFormat = this.getIFDIntValue(339);
        while (bps % 8 != 0) {
            ++bps;
        }
        if (bps == 24 && bitFormat != 3) {
            bps = 32;
        }
        switch (bps) {
            case 16: {
                if (bitFormat == 3) {
                    return 6;
                }
                return bitFormat == 2 ? 2 : 3;
            }
            case 24: {
                return 6;
            }
            case 64: {
                return 7;
            }
            case 32: {
                if (bitFormat == 3) {
                    return 6;
                }
                return bitFormat == 2 ? 4 : 5;
            }
        }
        return bitFormat == 2 ? 0 : 1;
    }

    public int[] getBytesPerSample() throws FormatException {
        int[] bitsPerSample = this.getBitsPerSample();
        int[] bps = new int[bitsPerSample.length];
        for (int i = 0; i < bitsPerSample.length; ++i) {
            bps[i] = bitsPerSample[i];
            while (bps[i] % 8 != 0) {
                int n = i;
                bps[n] = bps[n] + 1;
            }
            int n = i;
            bps[n] = bps[n] / 8;
            if (bps[i] != 0) continue;
            bps[i] = 1;
        }
        return bps;
    }

    public int getSamplesPerPixel() throws FormatException {
        return this.getIFDIntValue(277, 1);
    }

    public TiffCompression getCompression() throws FormatException {
        if (this.isWriteRaw()) {
            return TiffCompression.get(TiffCompression.UNCOMPRESSED.getCode());
        }
        return TiffCompression.get(this.getIFDIntValue(259, TiffCompression.UNCOMPRESSED.getCode()));
    }

    public PhotoInterp getPhotometricInterpretation() throws FormatException {
        Object photo = this.getIFDValue(262);
        if (photo instanceof PhotoInterp) {
            return (PhotoInterp)photo;
        }
        int pi = photo instanceof Number ? ((Number)photo).intValue() : ((int[])photo)[0];
        return PhotoInterp.get(pi);
    }

    public int getPlanarConfiguration() throws FormatException {
        int planarConfig = this.getIFDIntValue(284, 1);
        if (planarConfig != 1 && planarConfig != 2) {
            throw new FormatException("Sorry, PlanarConfiguration (" + planarConfig + ") not supported.");
        }
        return planarConfig;
    }

    public long[] getStripOffsets() throws FormatException {
        int tag = this.isTiled() ? 324 : 273;
        long[] offsets = this.getIFDLongArray(tag);
        if (this.isTiled() && offsets == null) {
            offsets = this.getIFDLongArray(273);
        }
        if (offsets == null) {
            return null;
        }
        for (int i = 0; i < offsets.length; ++i) {
            if (offsets[i] >= 0L) continue;
            int n = i;
            offsets[n] = offsets[n] + 0x100000000L;
        }
        if (this.isTiled()) {
            return offsets;
        }
        long rowsPerStrip = this.getRowsPerStrip()[0];
        long numStrips = (this.getImageLength() + rowsPerStrip - 1L) / rowsPerStrip;
        if (this.getPlanarConfiguration() == 2) {
            numStrips *= (long)this.getSamplesPerPixel();
        }
        if ((long)offsets.length < numStrips) {
            throw new FormatException("StripOffsets length (" + offsets.length + ") does not match expected " + "number of strips (" + numStrips + ")");
        }
        return offsets;
    }

    public long[] getStripByteCounts() throws FormatException {
        int tag = this.isTiled() ? 325 : 279;
        long[] byteCounts = this.getIFDLongArray(tag);
        if (this.isTiled() && byteCounts == null) {
            byteCounts = this.getIFDLongArray(279);
        }
        if (byteCounts == null) {
            long[] offsets = this.getStripOffsets();
            if (offsets == null) {
                return null;
            }
            int bytesPerSample = this.getBytesPerSample()[0];
            long imageWidth = this.getImageWidth();
            long imageLength = this.getImageLength();
            byteCounts = new long[offsets.length];
            int samples = this.getSamplesPerPixel();
            long imageSize = imageWidth * imageLength * (long)bytesPerSample * (long)(this.getPlanarConfiguration() == 2 ? 1 : samples);
            long count = imageSize / (long)byteCounts.length;
            Arrays.fill(byteCounts, count);
        }
        long[] counts = new long[byteCounts.length];
        if (this.getCompression() == TiffCompression.LZW) {
            for (int i = 0; i < byteCounts.length; ++i) {
                counts[i] = byteCounts[i] * 2L;
            }
        } else {
            System.arraycopy(byteCounts, 0, counts, 0, counts.length);
        }
        if (this.isTiled()) {
            return counts;
        }
        long rowsPerStrip = this.getRowsPerStrip()[0];
        long numStrips = (this.getImageLength() + rowsPerStrip - 1L) / rowsPerStrip;
        if (this.getPlanarConfiguration() == 2) {
            numStrips *= (long)this.getSamplesPerPixel();
        }
        if ((long)counts.length < numStrips) {
            throw new FormatException("StripByteCounts length (" + counts.length + ") does not match expected " + "number of strips (" + numStrips + ")");
        }
        return counts;
    }

    public long[] getRowsPerStrip() throws FormatException {
        long[] rowsPerStrip = this.getIFDLongArray(278);
        if (rowsPerStrip == null) {
            return new long[]{this.getImageLength()};
        }
        long imageLength = this.getImageLength();
        for (int i = 0; i < rowsPerStrip.length; ++i) {
            rowsPerStrip[i] = Math.min(rowsPerStrip[i], imageLength);
        }
        long rows = rowsPerStrip[0];
        for (int i = 1; i < rowsPerStrip.length; ++i) {
            if (rows == rowsPerStrip[i]) continue;
            throw new FormatException("Sorry, non-uniform RowsPerStrip is not supported");
        }
        return rowsPerStrip;
    }

    public int getResolutionMultiplier() {
        int resolutionUnit = this.getIFDIntValue(296);
        int multiplier = 1;
        if (resolutionUnit == 2) {
            multiplier = 25400;
        } else if (resolutionUnit == 3) {
            multiplier = 10000;
        }
        return multiplier;
    }

    public double getXResolution() throws FormatException {
        TiffRational xResolution = this.getIFDRationalValue(282);
        double x = xResolution == null ? 0.0 : 1.0 / xResolution.doubleValue();
        int multiplier = this.getResolutionMultiplier();
        return x * (double)multiplier;
    }

    public double getYResolution() throws FormatException {
        TiffRational yResolution = this.getIFDRationalValue(283);
        double y = yResolution == null ? 0.0 : 1.0 / yResolution.doubleValue();
        int resolutionUnit = this.getIFDIntValue(296);
        int multiplier = this.getResolutionMultiplier();
        return y * (double)multiplier;
    }

    public void putIFDValue(int tag, Object value) {
        this.put(new Integer(tag), value);
    }

    public void putIFDValue(int tag, short value) {
        this.putIFDValue(tag, new Short(value));
    }

    public void putIFDValue(int tag, int value) {
        this.putIFDValue(tag, new Integer(value));
    }

    public void putIFDValue(int tag, long value) {
        this.putIFDValue(tag, new Long(value));
    }

    public void printIFD() {
        LOGGER.trace("IFD directory entry values:");
        for (Integer tag : this.keySet()) {
            Object value = this.get(tag);
            String v = null;
            if (value == null) {
                LOGGER.trace("\t{}=null", (Object)IFD.getIFDTagName(tag));
                continue;
            }
            if (value instanceof Boolean || value instanceof Number || value instanceof String || value instanceof PhotoInterp || value instanceof TiffCompression || value instanceof TiffIFDEntry) {
                v = value.toString();
                LOGGER.trace("\t{}={}", (Object)IFD.getIFDTagName(tag), (Object)v);
                continue;
            }
            LOGGER.trace("\t{}=", (Object)IFD.getIFDTagName(tag));
            int nElements = Array.getLength(value);
            for (int i = 0; i < nElements; ++i) {
                LOGGER.trace("\t\t{}", Array.get(value, i));
            }
        }
    }

    public static String getIFDTagName(int tag) {
        return IFD.getFieldName(tag);
    }

    public static String getFieldName(int value) {
        Field[] fields = IFD.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (fields[i].getInt(null) != value) continue;
                return fields[i].getName();
            }
            catch (IllegalAccessException exc) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return "" + value;
    }
}

