/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriter;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriterSpi;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import loci.common.services.AbstractService;
import loci.common.services.ServiceException;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.services.JAIIIOService;

public class JAIIIOServiceImpl
extends AbstractService
implements JAIIIOService {
    public static final String NO_J2K_MSG = "The JAI Image I/O Tools are required to read JPEG-2000 files. Please obtain jai_imageio.jar from http://loci.wisc.edu/bio-formats/bio-formats-java-library";

    public JAIIIOServiceImpl() {
        this.checkClassDependency(J2KImageWriteParam.class);
        this.checkClassDependency(J2KImageWriter.class);
        this.checkClassDependency(J2KImageWriterSpi.class);
        this.checkClassDependency(J2KImageReadParam.class);
        this.checkClassDependency(J2KImageReader.class);
        this.checkClassDependency(J2KImageReaderSpi.class);
    }

    public void writeImage(OutputStream out, BufferedImage img, JPEG2000CodecOptions options) throws IOException, ServiceException {
        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<J2KImageWriterSpi> iter = ServiceRegistry.lookupProviders(J2KImageWriterSpi.class);
        registry.registerServiceProviders(iter);
        J2KImageWriterSpi spi = registry.getServiceProviderByClass(J2KImageWriterSpi.class);
        J2KImageWriter writer = new J2KImageWriter(spi);
        writer.setOutput(ios);
        String filter = options.lossless ? "w5x3" : "w9x7";
        IIOImage iioImage = new IIOImage(img, null, null);
        J2KImageWriteParam param = (J2KImageWriteParam)writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType("JPEG2000");
        param.setLossless(options.lossless);
        param.setFilter(filter);
        param.setCodeBlockSize(options.codeBlockSize);
        param.setEncodingRate(options.quality);
        if (options.tileWidth > 0 && options.tileHeight > 0) {
            param.setTiling(options.tileWidth, options.tileHeight, options.tileGridXOffset, options.tileGridYOffset);
        }
        if (options.numDecompositionLevels != null) {
            param.setNumDecompositionLevels(options.numDecompositionLevels);
        }
        writer.write(null, iioImage, param);
        ios.close();
    }

    public void writeImage(OutputStream out, BufferedImage img, boolean lossless, int[] codeBlockSize, double quality) throws IOException, ServiceException {
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.lossless = lossless;
        options.codeBlockSize = codeBlockSize;
        options.quality = quality;
        this.writeImage(out, img, options);
    }

    public BufferedImage readImage(InputStream in, JPEG2000CodecOptions options) throws IOException, ServiceException {
        J2KImageReader reader = this.getReader();
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(in);
        reader.setInput(mciis, false, true);
        J2KImageReadParam param = (J2KImageReadParam)reader.getDefaultReadParam();
        if (options.resolution != null) {
            param.setResolution(options.resolution);
        }
        return reader.read(0, param);
    }

    public BufferedImage readImage(InputStream in) throws IOException, ServiceException {
        return this.readImage(in, JPEG2000CodecOptions.getDefaultOptions());
    }

    public Raster readRaster(InputStream in, JPEG2000CodecOptions options) throws IOException, ServiceException {
        J2KImageReader reader = this.getReader();
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(in);
        reader.setInput(mciis, false, true);
        J2KImageReadParam param = (J2KImageReadParam)reader.getDefaultReadParam();
        if (options.resolution != null) {
            param.setResolution(options.resolution);
        }
        return reader.readRaster(0, param);
    }

    public Raster readRaster(InputStream in) throws IOException, ServiceException {
        return this.readRaster(in, JPEG2000CodecOptions.getDefaultOptions());
    }

    private J2KImageReader getReader() {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<J2KImageReaderSpi> iter = ServiceRegistry.lookupProviders(J2KImageReaderSpi.class);
        registry.registerServiceProviders(iter);
        J2KImageReaderSpi spi = registry.getServiceProviderByClass(J2KImageReaderSpi.class);
        return new J2KImageReader(spi);
    }
}

