/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.ome;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import loci.formats.ome.OMEXMLMetadata;
import ome.xml.DOMUtil;
import ome.xml.model.OMEModelObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractOMEXMLMetadata
implements OMEXMLMetadata {
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String SCHEMA = "http://www.openmicroscopy.org/Schemas/OME/2011-06/ome.xsd";
    protected OMEModelObject root;
    private Element imageCA;
    private DocumentBuilder builder;

    public AbstractOMEXMLMetadata() {
        try {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public String dumpXML() {
        if (this.root == null) {
            this.root = (OMEModelObject)this.getRoot();
            if (this.root == null) {
                return null;
            }
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Document doc = this.builder.newDocument();
            Element r = this.root.asXMLElement(doc);
            r.setAttribute("xmlns:xsi", XSI_NS);
            r.setAttribute("xsi:schemaLocation", "http://www.openmicroscopy.org/Schemas/OME/2011-06 http://www.openmicroscopy.org/Schemas/OME/2011-06/ome.xsd");
            doc.appendChild(r);
            DOMUtil.writeXML((OutputStream)os, (Document)doc);
            return os.toString();
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public String getUUID() {
        Element ome = this.root.asXMLElement(this.builder.newDocument());
        return DOMUtil.getAttribute((String)"UUID", (Element)ome);
    }

    public void setRoot(Object root) {
    }

    public Object getRoot() {
        return this.root;
    }

    public void setUUID(String uuid) {
        Element ome = this.root.asXMLElement(this.builder.newDocument());
        DOMUtil.setAttribute((String)"UUID", (String)uuid, (Element)ome);
    }

    protected Integer booleanToInteger(Boolean value) {
        return value == null ? null : new Integer(value != false ? 2 : 1);
    }

    protected Boolean integerToBoolean(Integer value) {
        return value == null ? null : new Boolean(value == 2);
    }

    protected Integer doubleToInteger(Double value) {
        return value == null ? null : new Integer(value.intValue());
    }

    protected Double integerToDouble(Integer value) {
        return value == null ? null : new Double(value.doubleValue());
    }
}

