/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.itk;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;

public class ITKBridgeJNI {
    private static ImageReader reader;

    public ITKBridgeJNI() {
        reader = new ImageReader();
    }

    public static boolean canReadFile(String id) {
        boolean h = false;
        try {
            h = reader.isThisType(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return h;
    }

    public static double[] readImageInfo(String id) {
        double d2;
        try {
            reader.setId(id);
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double[] returnValues = new double[17];
        boolean little = reader.isLittleEndian();
        returnValues[0] = little ? 1.0 : 0.0;
        returnValues[1] = reader.getSeriesCount();
        int pixelType = reader.getPixelType();
        returnValues[2] = pixelType;
        returnValues[3] = FormatTools.getBytesPerPixel((int)returnValues[2]);
        returnValues[4] = pixelType == 1 ? 0.0 : (pixelType == 0 ? 1.0 : (pixelType == 3 ? 2.0 : (pixelType == 2 ? 3.0 : (pixelType == 5 ? 4.0 : (pixelType == 4 ? 5.0 : (pixelType == 6 ? 6.0 : (pixelType == 7 ? 7.0 : 8.0)))))));
        returnValues[5] = reader.getSizeX();
        returnValues[6] = reader.getSizeY();
        returnValues[7] = reader.getSizeZ();
        returnValues[8] = reader.getSizeT();
        returnValues[9] = reader.getSizeC();
        returnValues[10] = reader.getEffectiveSizeC();
        returnValues[11] = reader.getRGBChannelCount();
        returnValues[12] = reader.getImageCount();
        MetadataRetrieve retrieve = MetadataTools.asRetrieve(reader.getMetadataStore());
        Double d = (Double)retrieve.getPixelsPhysicalSizeX(0).getValue();
        returnValues[13] = d2 = d == null ? 1.0 : d;
        d = (Double)retrieve.getPixelsPhysicalSizeY(0).getValue();
        returnValues[14] = d2 = d == null ? 1.0 : d;
        d = (Double)retrieve.getPixelsPhysicalSizeZ(0).getValue();
        returnValues[15] = d2 = d == null ? 1.0 : d;
        d = retrieve.getPixelsTimeIncrement(0);
        returnValues[16] = d2 = d == null ? 1.0 : d;
        return returnValues;
    }

    public static void readPlane(int z, int c, int t, byte[] buf, int xStart, int yStart, int xCount, int yCount) {
        int no = reader.getIndex(z, c, t);
        try {
            reader.openBytes(no, buf, xStart, yStart, xCount, yCount);
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close() {
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean getIsInterleaved() {
        return reader.isInterleaved();
    }

    public static int getImageCount() {
        return reader.getImageCount();
    }

    public static int getBytesPerPixel() {
        return FormatTools.getBytesPerPixel(reader.getPixelType());
    }

    public void quit() {
        System.exit(0);
    }
}

