/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.EOFException;
import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.LZOCodec;
import loci.formats.meta.MetadataStore;

public class VolocityClippingReader
extends FormatReader {
    private static final String CLIPPING_MAGIC_STRING = "FFCA";
    private static final int AISF = 1179863361;
    private long pixelOffset;

    public VolocityClippingReader() {
        super("Volocity Library Clipping", "acff");
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset);
        if ((long)(FormatTools.getPlaneSize(this) * 2) + this.in.getFilePointer() < this.in.length()) {
            this.readPlane(this.in, x, y, w, h, buf);
            return buf;
        }
        byte[] b = new LZOCodec().decompress(this.in, null);
        RandomAccessInputStream s = new RandomAccessInputStream(b);
        s.seek(0L);
        this.readPlane(s, x, y, w, h, buf);
        s.close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = this.in.read() == 73;
        this.in.order(this.isLittleEndian());
        this.in.skipBytes(4);
        String magicString = this.in.readString(4);
        if (!magicString.equals(CLIPPING_MAGIC_STRING)) {
            throw new FormatException("Found invalid magic string: " + magicString);
        }
        int check = this.in.readInt();
        while (check != 520 && check != 1179863361) {
            this.in.seek(this.in.getFilePointer() - 3L);
            check = this.in.readInt();
        }
        if (check == 1179863361) {
            this.core[0].littleEndian = false;
            this.in.order(this.isLittleEndian());
            this.in.skipBytes(28);
        }
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.core[0].sizeZ = this.in.readInt();
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = 1;
        this.pixelOffset = this.in.getFilePointer() + 65L;
        if ((long)(this.getSizeX() * this.getSizeY() * 100) >= this.in.length()) {
            while (this.in.getFilePointer() < this.in.length()) {
                try {
                    byte[] b = new LZOCodec().decompress(this.in, null);
                    if (b.length > 0 && b.length % (this.getSizeX() * this.getSizeY()) == 0) {
                        int bytes = b.length / (this.getSizeX() * this.getSizeY());
                        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bytes, false, false);
                        break;
                    }
                }
                catch (EOFException e) {
                    // empty catch block
                }
                ++this.pixelOffset;
                this.in.seek(this.pixelOffset);
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

