/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class SlidebookReader
extends FormatReader {
    public static final int SLD_MAGIC_BYTES_1_0 = 108;
    public static final int SLD_MAGIC_BYTES_1_1 = 256;
    public static final int SLD_MAGIC_BYTES_2_0 = 501;
    public static final int SLD_MAGIC_BYTES_2_1 = 258;
    public static final long SLD_MAGIC_BYTES_3 = 4127260929L;
    private Vector<Long> metadataOffsets;
    private Vector<Long> pixelOffsets;
    private Vector<Long> pixelLengths;
    private Vector<Double> ndFilters;
    private long[][] planeOffset;
    private boolean adjust = true;
    private boolean isSpool;
    private Hashtable<Integer, Integer> metadataInPlanes;

    public SlidebookReader() {
        super("Olympus Slidebook", new String[]{"sld", "spl"});
        this.domains = new String[]{"Light Microscopy"};
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        stream.seek(4L);
        boolean littleEndian = stream.readString(2).equals("II");
        if (!FormatTools.validStream(stream, 8, littleEndian)) {
            return false;
        }
        short magicBytes1 = stream.readShort();
        short magicBytes2 = stream.readShort();
        return (magicBytes2 & 0xFF00) == 256 && (magicBytes1 == 108 || magicBytes1 == 501);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        long offset = this.planeOffset[this.getSeries()][no];
        this.in.seek(offset);
        if (this.isSpool) {
            Object[] keys = this.metadataInPlanes.keySet().toArray(new Integer[0]);
            Arrays.sort(keys);
            Object[] arr$ = keys;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int key = (Integer)arr$[i$];
                if (key >= no) continue;
                this.in.skipBytes(256);
            }
            this.in.order(false);
            long magicBytes = (long)this.in.readInt() & 0xFFFFFFFFL;
            this.in.order(this.isLittleEndian());
            if (magicBytes == 4127260929L && !this.metadataInPlanes.contains(no)) {
                this.metadataInPlanes.put(no, 0);
                this.in.skipBytes(252);
            } else {
                this.in.seek(this.in.getFilePointer() - 4L);
            }
        }
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelLengths = null;
            this.pixelOffsets = null;
            this.metadataOffsets = null;
            this.ndFilters = null;
            this.isSpool = false;
            this.metadataInPlanes = null;
            this.adjust = true;
            this.planeOffset = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.isSpool = SlidebookReader.checkSuffix(id, "spl");
        if (this.isSpool) {
            this.metadataInPlanes = new Hashtable();
        }
        LOGGER.info("Finding offsets to pixel data");
        this.in.skipBytes(4);
        this.core[0].littleEndian = this.in.read() == 73;
        this.in.order(this.isLittleEndian());
        this.metadataOffsets = new Vector();
        this.pixelOffsets = new Vector();
        this.pixelLengths = new Vector();
        this.ndFilters = new Vector();
        this.in.seek(0L);
        while (this.in.getFilePointer() < this.in.length() - 8L) {
            LOGGER.debug("Looking for block at {}", (Object)this.in.getFilePointer());
            this.in.skipBytes(4);
            int checkOne = this.in.read();
            int checkTwo = this.in.read();
            if (checkOne == 73 && checkTwo == 73 || checkOne == 77 && checkTwo == 77) {
                LOGGER.debug("Found metadata offset: {}", (Object)(this.in.getFilePointer() - 6L));
                this.metadataOffsets.add(new Long(this.in.getFilePointer() - 6L));
                this.in.skipBytes(this.in.readShort() - 8);
                continue;
            }
            if (checkOne == -1 && checkTwo == -1) {
                boolean foundBlock = false;
                byte[] block = new byte[8192];
                this.in.read(block);
                while (!foundBlock) {
                    for (int i = 0; i < block.length - 2; ++i) {
                        if ((block[i] != 77 || block[i + 1] != 77) && (block[i] != 73 || block[i + 1] != 73)) continue;
                        foundBlock = true;
                        this.in.seek(this.in.getFilePointer() - (long)block.length + (long)i - 2L);
                        LOGGER.debug("Found metadata offset: {}", (Object)(this.in.getFilePointer() - 2L));
                        this.metadataOffsets.add(new Long(this.in.getFilePointer() - 2L));
                        this.in.skipBytes(this.in.readShort() - 5);
                        break;
                    }
                    if (foundBlock) continue;
                    block[0] = block[block.length - 2];
                    block[1] = block[block.length - 1];
                    this.in.read(block, 2, block.length - 2);
                }
                continue;
            }
            String s = null;
            long fp = this.in.getFilePointer() - 6L;
            this.in.seek(fp);
            int len = this.in.read();
            if (len > 0 && len <= 32) {
                s = this.in.readString(len);
            }
            if (s != null && s.indexOf("Annotation") != -1) {
                if (s.equals("CTimelapseAnnotation")) {
                    this.in.skipBytes(41);
                    if (this.in.read() == 0) {
                        this.in.skipBytes(10);
                        continue;
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (s.equals("CIntensityBarAnnotation")) {
                    this.in.skipBytes(56);
                    int n = this.in.read();
                    while (n == 0 || n < 6 || n > 128) {
                        n = this.in.read();
                    }
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (s.equals("CCubeAnnotation")) {
                    this.in.skipBytes(66);
                    int n = this.in.read();
                    if (n == 0) continue;
                    this.in.seek(this.in.getFilePointer() - 1L);
                    continue;
                }
                if (!s.equals("CScaleBarAnnotation")) continue;
                this.in.skipBytes(38);
                int extra = this.in.read();
                if (extra <= 16) {
                    this.in.skipBytes(3 + extra);
                    continue;
                }
                this.in.skipBytes(2);
                continue;
            }
            if (s != null && s.indexOf("Decon") != -1) {
                this.in.seek(fp);
                while (this.in.read() != 93) {
                }
                continue;
            }
            if (fp % 2L == 1L) {
                fp -= 2L;
            }
            this.in.seek(fp);
            String checkString = this.in.readString(64);
            if (checkString.indexOf("II") != -1 || checkString.indexOf("MM") != -1) {
                int index = checkString.indexOf("II");
                if (index == -1) {
                    index = checkString.indexOf("MM");
                }
                this.in.seek(fp + (long)index - 4L);
                continue;
            }
            this.in.seek(fp);
            LOGGER.debug("Found pixel offset at {}", (Object)fp);
            this.pixelOffsets.add(new Long(fp));
            try {
                byte[] buf = new byte[8192];
                boolean found = false;
                int n = this.in.read(buf);
                while (!found && this.in.getFilePointer() < this.in.length()) {
                    for (int i = 0; i < n - 6; ++i) {
                        if ((buf[i + 4] != 73 || buf[i + 5] != 73) && (buf[i + 4] != 77 || buf[i + 5] != 77)) continue;
                        if ((buf[i] == 104 || buf[i] == 105) && buf[i + 1] == 0 || buf[i] == 0 && (buf[i + 1] == 104 || buf[i + 1] == 105)) {
                            found = true;
                            this.in.seek(this.in.getFilePointer() - (long)n + (long)i - 20L);
                            if (buf[i] != 105 && buf[i + 1] != 105) break;
                            this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
                            break;
                        }
                        if ((buf[i] != 106 && buf[i] != 107 && buf[i] != 110 || buf[i + 1] != 0) && (buf[i] != 0 || buf[i + 1] != 106 && buf[i + 1] != 107 && buf[i + 1] != 110) && (buf[i] != 111 || buf[i + 1] != 110)) continue;
                        found = true;
                        this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
                        this.in.seek(this.in.getFilePointer() - (long)n + (long)i - 20L);
                        break;
                    }
                    if (found) continue;
                    byte[] tmp = buf;
                    buf = new byte[8192];
                    System.arraycopy(tmp, tmp.length - 20, buf, 0, 20);
                    n = this.in.read(buf, 20, buf.length - 20);
                }
                if (this.in.getFilePointer() <= this.in.length()) {
                    if (this.pixelOffsets.size() <= this.pixelLengths.size()) continue;
                    long length = this.in.getFilePointer() - fp;
                    if (length / 2L % 2L == 1L) {
                        this.pixelOffsets.setElementAt(fp + 2L, this.pixelOffsets.size() - 1);
                        length -= 2L;
                    }
                    if (length >= 1024L) {
                        this.pixelLengths.add(new Long(length));
                        continue;
                    }
                    this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
                    continue;
                }
                this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
            }
            catch (EOFException e) {
                this.pixelOffsets.remove(this.pixelOffsets.size() - 1);
            }
        }
        Vector<Long> orderedSeries = new Vector<Long>();
        Hashtable<Long, Vector<Integer>> uniqueSeries = new Hashtable<Long, Vector<Integer>>();
        for (int i = 0; i < this.pixelOffsets.size(); ++i) {
            int padding;
            long length = this.pixelLengths.get(i);
            long offset = this.pixelOffsets.get(i);
            int n = padding = this.isSpool ? 0 : 7;
            if (length + offset + (long)padding > this.in.length()) {
                this.pixelOffsets.remove(i);
                this.pixelLengths.remove(i);
                --i;
                continue;
            }
            Vector<Integer> v = (Vector<Integer>)uniqueSeries.get(length);
            if (v == null) {
                orderedSeries.add(length);
                v = new Vector<Integer>();
            }
            v.add(i);
            uniqueSeries.put(length, v);
        }
        if (this.pixelOffsets.size() > 1) {
            boolean little = this.isLittleEndian();
            this.core = new CoreMetadata[uniqueSeries.size()];
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                this.core[i] = new CoreMetadata();
                this.core[i].littleEndian = little;
            }
        }
        LOGGER.info("Determining dimensions");
        Vector<Float> pixelSize = new Vector<Float>();
        String objective = null;
        Vector<Double> pixelSizeZ = new Vector<Double>();
        long pixelBytes = 0L;
        for (int i = 0; i < this.pixelLengths.size(); ++i) {
            pixelBytes += this.pixelLengths.get(i).longValue();
        }
        String[] imageNames = new String[this.getSeriesCount()];
        Vector<String> channelNames = new Vector<String>();
        int nextName = 0;
        int[] sizeX = new int[this.pixelOffsets.size()];
        int[] sizeY = new int[this.pixelOffsets.size()];
        int[] sizeZ = new int[this.pixelOffsets.size()];
        int[] sizeC = new int[this.pixelOffsets.size()];
        int iCount = 0;
        int hCount = 0;
        int uCount = 0;
        int prevSeries = -1;
        int prevSeriesU = -1;
        boolean nextChannel = false;
        block12: for (int i = 0; i < this.metadataOffsets.size(); ++i) {
            long off = this.metadataOffsets.get(i);
            this.in.seek(off);
            long next = i == this.metadataOffsets.size() - 1 ? this.in.length() : this.metadataOffsets.get(i + 1).longValue();
            int totalBlocks = (int)((next - off) / 128L);
            block13: for (int q = 0; q < totalBlocks; ++q) {
                short div;
                long end;
                if (this.withinPixels(off + (long)(q * 128))) continue;
                this.in.seek(off + (long)q * 128L);
                char n = (char)this.in.readShort();
                while (n == '\u0000' && this.in.getFilePointer() < off + (long)((q + 1) * 128)) {
                    n = (char)this.in.readShort();
                }
                if (this.in.getFilePointer() >= this.in.length() - 2L) continue block12;
                if (n == 'i') {
                    ++iCount;
                    this.in.skipBytes(94);
                    pixelSizeZ.add(new Double(this.in.readFloat()));
                    this.in.seek(this.in.getFilePointer() - 20L);
                    for (int j = 0; j < this.pixelOffsets.size(); ++j) {
                        long l = end = j == this.pixelOffsets.size() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                        if (this.in.getFilePointer() >= end) continue;
                        if (sizeX[j] == 0) {
                            short x = this.in.readShort();
                            short y = this.in.readShort();
                            if (x != 0 && y != 0) {
                                sizeX[j] = x;
                                sizeY[j] = y;
                                short checkX = this.in.readShort();
                                short checkY = this.in.readShort();
                                div = this.in.readShort();
                                int n2 = j;
                                sizeX[n2] = sizeX[n2] / (div == 0 ? (short)1 : div);
                                div = this.in.readShort();
                                int n3 = j;
                                sizeY[n3] = sizeY[n3] / (div == 0 ? (short)1 : div);
                            } else {
                                this.in.skipBytes(8);
                            }
                        }
                        if (prevSeries != j) {
                            iCount = 1;
                        }
                        prevSeries = j;
                        sizeC[j] = iCount;
                        continue block13;
                    }
                    continue;
                }
                if (n == 'u') {
                    ++uCount;
                    for (int j = 0; j < this.getSeriesCount(); ++j) {
                        long l = end = j == this.getSeriesCount() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                        if (this.in.getFilePointer() >= end) continue;
                        if (prevSeriesU != j) {
                            uCount = 1;
                        }
                        prevSeriesU = j;
                        sizeZ[j] = uCount;
                        continue block13;
                    }
                    continue;
                }
                if (n == 'h') {
                    ++hCount;
                    continue;
                }
                if (n == 'j') {
                    this.in.skipBytes(2);
                    String check = this.in.readString(2);
                    if (!check.equals("II") && !check.equals("MM")) continue;
                    long pointer = this.in.getFilePointer();
                    this.in.skipBytes(10);
                    if (nextName < imageNames.length) {
                        imageNames[nextName++] = this.in.readCString().trim();
                    }
                    long fp = this.in.getFilePointer();
                    if (this.in.getFilePointer() % 2L == 1L) {
                        this.in.skipBytes(1);
                    }
                    while (this.in.readShort() == 0) {
                    }
                    this.in.skipBytes(18);
                    if (this.in.getFilePointer() - fp > 123L && fp % 2L == 0L) {
                        this.in.seek(fp + 123L);
                    }
                    int x = this.in.readInt();
                    int y = this.in.readInt();
                    div = this.in.readShort();
                    short s = div == 0 ? (short)1 : div;
                    div = this.in.readShort();
                    if (!((x /= s) <= 16 || x >= sizeX[nextName - 1] && sizeX[nextName - 1] != 0 || (y /= div == 0 ? (short)1 : div) <= 16 || y >= sizeY[nextName - 1] && sizeY[nextName - 1] != 0)) {
                        sizeX[nextName - 1] = x;
                        sizeY[nextName - 1] = y;
                        this.adjust = false;
                    }
                    this.in.seek(pointer + 214L);
                    short validBits = this.in.readShort();
                    if (this.core[nextName - 1].bitsPerPixel != 0 || validBits > 16) continue;
                    this.core[nextName - 1].bitsPerPixel = validBits;
                    continue;
                }
                if (n == 'm') {
                    if (this.in.getFilePointer() <= this.pixelOffsets.get(0)) continue;
                    this.in.skipBytes(14);
                    channelNames.add(this.in.readCString().trim());
                    continue;
                }
                if (n == 'd') {
                    this.in.skipBytes(6);
                    long fp = this.in.getFilePointer();
                    objective = this.in.readCString();
                    this.in.seek(fp + 144L);
                    pixelSize.add(Float.valueOf(this.in.readFloat()));
                    continue;
                }
                if (n == 'e') {
                    this.in.skipBytes(174);
                    this.ndFilters.add(new Double(this.in.readFloat()));
                    this.in.skipBytes(40);
                    if (nextName >= this.getSeriesCount()) continue;
                    this.setSeries(nextName);
                    this.addSeriesMeta("channel " + this.ndFilters.size() + " intensification", this.in.readShort());
                    continue;
                }
                if (n == 'k') {
                    this.in.skipBytes(14);
                    if (nextName > 0) {
                        this.setSeries(nextName - 1);
                    }
                    this.addSeriesMeta("Mag. changer", this.in.readCString());
                    continue;
                }
                if (!this.isSpool) continue;
                for (int j = 0; j < this.pixelOffsets.size(); ++j) {
                    long l = end = j == this.pixelOffsets.size() - 1 ? this.in.length() : this.pixelOffsets.get(j + 1).longValue();
                    if (this.in.getFilePointer() >= end) continue;
                    this.in.skipBytes(14);
                    short check = this.in.readShort();
                    short x = this.in.readShort();
                    short y = this.in.readShort();
                    if (check == 0 && x > 16 && y > 16) {
                        sizeX[j] = x;
                        sizeY[j] = y;
                    }
                    this.adjust = false;
                    continue block13;
                }
            }
        }
        this.planeOffset = new long[this.getSeriesCount()][];
        boolean divByTwo = false;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            Vector pixelIndexes = (Vector)uniqueSeries.get(orderedSeries.get(i));
            int nBlocks = pixelIndexes.size();
            int index = (Integer)pixelIndexes.get(0);
            long pixels = this.pixelLengths.get(index) / 2L;
            boolean x = true;
            this.core[i].sizeX = sizeX[index];
            this.core[i].sizeY = sizeY[index];
            this.core[i].sizeC = sizeC[index];
            this.core[i].sizeZ = sizeZ[index];
            if (this.core[i].sizeZ % nBlocks == 0) {
                this.core[i].sizeZ /= nBlocks;
            }
            if (divByTwo) {
                this.core[i].sizeX /= 2;
            }
            if (this.getSizeC() == 0) {
                this.core[i].sizeC = 1;
            }
            if (this.getSizeZ() == 0) {
                this.core[i].sizeZ = 1;
            }
            long plane = pixels / (long)(this.getSizeC() * this.getSizeZ());
            if ((long)(this.getSizeX() * this.getSizeY()) == pixels) {
                if (this.getSizeC() == 2 && this.getSizeX() % 2 == 0 && this.getSizeY() % 2 == 0) {
                    this.core[i].sizeX /= 2;
                    divByTwo = true;
                } else {
                    this.core[i].sizeC = 1;
                }
                this.core[i].sizeZ = 1;
            } else if ((long)(this.getSizeX() * this.getSizeY() * this.getSizeZ()) == pixels) {
                if (this.getSizeC() == 2 && this.getSizeX() % 2 == 0 && this.getSizeY() % 2 == 0) {
                    this.core[i].sizeX /= 2;
                    divByTwo = true;
                } else {
                    this.core[i].sizeC = 1;
                    this.core[i].sizeZ = (int)(pixels / (long)(this.getSizeX() * this.getSizeY()));
                }
            } else if ((long)(this.getSizeX() * this.getSizeY() * this.getSizeC()) == pixels) {
                this.core[i].sizeC = (int)(pixels / (long)(this.getSizeX() * this.getSizeY()));
                this.core[i].sizeZ = 1;
            } else {
                long p = pixels / (long)(this.getSizeX() * this.getSizeY());
                if (p * (long)this.getSizeX() * (long)this.getSizeY() == pixels && p != (long)(this.getSizeC() * this.getSizeZ())) {
                    if (p % (long)this.getSizeC() != 0L) {
                        this.core[i].sizeC = 1;
                        this.core[i].sizeZ = (int)p;
                    } else {
                        this.core[i].sizeZ = (int)(p / (long)this.getSizeC());
                    }
                }
            }
            plane = pixels / (long)(this.getSizeC() * this.getSizeZ());
            long diff = 2L * (pixels - (long)(this.getSizeX() * this.getSizeY() * this.getSizeC() * this.getSizeZ()));
            if (this.pixelLengths.get(index) % 2L == 1L) {
                ++diff;
            }
            if (i == 0) {
                diff = 0L;
            }
            if (this.adjust && diff == 0L) {
                boolean widthGreater;
                boolean bl = widthGreater = this.getSizeX() > this.getSizeY();
                while ((long)(this.getSizeX() * this.getSizeY()) > plane) {
                    if (x) {
                        this.core[i].sizeX /= 2;
                    } else {
                        this.core[i].sizeY /= 2;
                    }
                    x = !x;
                }
                while ((long)(this.getSizeX() * this.getSizeY()) < plane || this.getSizeX() < this.getSizeY() && widthGreater) {
                    ++this.core[i].sizeX;
                    this.core[i].sizeY = (int)(plane / (long)this.getSizeX());
                }
            }
            int nPlanes = this.getSizeZ() * this.getSizeC();
            this.core[i].sizeT = (int)(pixels / (long)(this.getSizeX() * this.getSizeY() * nPlanes));
            while ((long)(this.getSizeX() * this.getSizeY() * nPlanes * this.getSizeT()) > pixels) {
                --this.core[i].sizeT;
            }
            if (this.getSizeT() == 0) {
                this.core[i].sizeT = 1;
            }
            this.core[i].sizeT *= nBlocks;
            this.core[i].imageCount = nPlanes * this.getSizeT();
            this.core[i].pixelType = 3;
            this.core[i].dimensionOrder = nBlocks > 1 ? "XYZCT" : "XYZTC";
            this.core[i].indexed = false;
            this.core[i].falseColor = false;
            this.core[i].metadataComplete = true;
            this.planeOffset[i] = new long[this.getImageCount()];
            int nextImage = 0;
            for (Integer pixelIndex : pixelIndexes) {
                long offset = this.pixelOffsets.get(pixelIndex) + diff;
                long length = this.pixelLengths.get(pixelIndex);
                int planeSize = this.getSizeX() * this.getSizeY() * 2;
                int planes = (int)(length / (long)planeSize);
                int p = 0;
                while (p < planes) {
                    if (nextImage < this.planeOffset[i].length) {
                        this.planeOffset[i][nextImage] = offset + (long)(p * planeSize);
                    }
                    ++p;
                    ++nextImage;
                }
            }
        }
        this.setSeries(0);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            if (imageNames[i] != null) {
                store.setImageName(imageNames[i], i);
            }
            MetadataTools.setDefaultCreationDate(store, id, i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int i;
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            int index = 0;
            store.setObjectiveModel(objective, 0, 0);
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setImageObjectiveSettingsID(objectiveID, 0);
            for (i = 0; i < this.getSeriesCount(); ++i) {
                Double size;
                if (i < pixelSize.size() && (size = new Double(((Float)pixelSize.get(i)).floatValue())) > 0.0) {
                    store.setPixelsPhysicalSizeX(new PositiveFloat(size), i);
                    store.setPixelsPhysicalSizeY(new PositiveFloat(size), i);
                }
                int idx = 0;
                for (int q = 0; q < i; ++q) {
                    idx += this.core[q].sizeC;
                }
                if (idx >= pixelSizeZ.size() || pixelSizeZ.get(idx) == null || !((Double)pixelSizeZ.get(idx) > 0.0)) continue;
                store.setPixelsPhysicalSizeZ(new PositiveFloat((Double)pixelSizeZ.get(idx)), i);
            }
            for (i = 0; i < this.getSeriesCount(); ++i) {
                this.setSeries(i);
                for (int c = 0; c < this.getSizeC(); ++c) {
                    if (index < channelNames.size() && channelNames.get(index) != null) {
                        store.setChannelName((String)channelNames.get(index), i, c);
                        this.addSeriesMeta("channel " + c, channelNames.get(index));
                    }
                    if (index < this.ndFilters.size() && this.ndFilters.get(index) != null) {
                        store.setChannelNDFilter(this.ndFilters.get(index), i, c);
                        this.addSeriesMeta("channel " + c + " Neutral density", this.ndFilters.get(index));
                    }
                    ++index;
                }
            }
            this.setSeries(0);
        }
    }

    private boolean withinPixels(long offset) {
        for (int i = 0; i < this.pixelOffsets.size(); ++i) {
            long pixelOffset = this.pixelOffsets.get(i);
            long pixelLength = this.pixelLengths.get(i);
            if (offset < pixelOffset || offset >= pixelOffset + pixelLength) continue;
            return true;
        }
        return false;
    }
}

