/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.ByteArrayHandle;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ChannelSeparator;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.LZOCodec;
import loci.formats.in.MetadataLevel;
import loci.formats.in.PictReader;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class OpenlabReader
extends FormatReader {
    public static final long LIFF_MAGIC_BYTES = 281472450523250L;
    private static final int MAC_1_BIT = 1;
    private static final int MAC_4_GREYS = 2;
    private static final int MAC_16_GREYS = 3;
    private static final int MAC_16_COLORS = 4;
    private static final int MAC_256_GREYS = 5;
    private static final int MAC_256_COLORS = 6;
    private static final int MAC_16_BIT_COLOR = 7;
    private static final int MAC_24_BIT_COLOR = 8;
    private static final int DEEP_GREY_9 = 9;
    private static final int DEEP_GREY_10 = 10;
    private static final int DEEP_GREY_11 = 11;
    private static final int DEEP_GREY_12 = 12;
    private static final int DEEP_GREY_13 = 13;
    private static final int DEEP_GREY_14 = 14;
    private static final int DEEP_GREY_15 = 15;
    private static final int DEEP_GREY_16 = 16;
    private static final int IMAGE_TYPE_1 = 67;
    private static final int IMAGE_TYPE_2 = 68;
    private static final int CALIBRATION = 69;
    private static final int USER = 72;
    private PictReader pict = new PictReader();
    private int version;
    private int numSeries;
    private PlaneInfo[] planes;
    private float xcal;
    private float ycal;
    private long nextTag = 0L;
    private int tag = 0;
    private int subTag = 0;
    private String fmt = "";
    private int[][] planeOffsets;
    private Vector<byte[][]> luts;
    private int lastPlane;
    private String gain;
    private String detectorOffset;
    private String xPos;
    private String yPos;
    private String zPos;
    private boolean specialPlateNames = false;

    public OpenlabReader() {
        super("Openlab LIFF", "liff");
        this.suffixNecessary = false;
        this.domains = new String[]{"Unknown"};
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        return stream.readLong() == 281472450523250L;
    }

    public byte[][] get8BitLookupTable() {
        if (this.luts != null) {
            if (this.series < this.planeOffsets.length && this.lastPlane < this.planeOffsets[this.series].length) {
                return this.luts.get(this.planeOffsets[this.series][this.lastPlane]);
            }
            if (this.lastPlane < this.luts.size()) {
                return this.luts.get(this.lastPlane);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.lastPlane = no;
        PlaneInfo planeInfo = null;
        if (this.specialPlateNames) {
            planeInfo = this.getPlane(this.getZCTCoords(no));
        } else if (no < this.planeOffsets[this.series].length) {
            int index = this.planeOffsets[this.series][no];
            planeInfo = this.planes[index];
        }
        if (planeInfo == null) {
            return buf;
        }
        long first = planeInfo.planeOffset;
        long last = first + (long)(FormatTools.getPlaneSize(this) * 2);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (!planeInfo.pict) {
            if (this.version == 2) {
                this.in.seek(first);
                this.readPlane(this.in, x, y, w, h, buf);
            } else {
                this.in.seek(first + 16L);
                int bytes = bpp * this.getRGBChannelCount();
                byte[] b = new byte[(int)(last - first)];
                this.in.read(b);
                CodecOptions options = new CodecOptions();
                options.width = this.getSizeX();
                options.height = this.getSizeY();
                options.bitsPerSample = bytes * 8;
                options.maxBytes = this.getSizeX() * this.getSizeY() * bytes;
                b = new LZOCodec().decompress(b, options);
                if (this.getSizeX() * this.getSizeY() * 4 <= b.length) {
                    for (int yy = y; yy < h + y; ++yy) {
                        for (int xx = x; xx < w + x; ++xx) {
                            System.arraycopy(b, (yy * (this.getSizeX() + 4) + xx) * 4 + 1, buf, ((yy - y) * w + xx - x) * 3, 3);
                        }
                    }
                } else {
                    int src = b.length / this.getSizeY();
                    if (src - this.getSizeX() * bytes != 16) {
                        src = this.getSizeX() * bytes;
                    }
                    int dest = w * bytes;
                    for (int row = 0; row < h; ++row) {
                        System.arraycopy(b, (row + y) * src + x * bytes, buf, row * dest, dest);
                    }
                }
                b = null;
            }
            if (planeInfo.volumeType == 5 || planeInfo.volumeType == 6) {
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = (byte)(~buf[i] & 0xFF);
                }
            }
        } else {
            Exception exc = null;
            if (this.getPixelType() == 1) {
                this.in.seek(first);
                byte[] b = new byte[(int)(last - first) + 512];
                this.in.read(b, 512, b.length - 512);
                IFormatReader r = this.getRGBChannelCount() == 1 ? new ChannelSeparator(this.pict) : this.pict;
                try {
                    Location.mapFile("OPENLAB_PICT", new ByteArrayHandle(b));
                    r.setId("OPENLAB_PICT");
                    if (this.getPixelType() != r.getPixelType()) {
                        throw new FormatException("Pixel type of inner PICT does not match pixel type of Openlab file");
                    }
                    if (this.isIndexed()) {
                        int index = no;
                        if (this.series < this.planeOffsets.length) {
                            index = this.planeOffsets[this.series][this.lastPlane];
                        }
                        this.luts.setElementAt(this.pict.get8BitLookupTable(), index);
                    }
                    r.openBytes(0, buf, x, y, w, h);
                }
                catch (FormatException e) {
                    exc = e;
                }
                catch (IOException e) {
                    exc = e;
                }
                finally {
                    r.close();
                    Location.mapFile("OPENLAB_PICT", null);
                }
                b = null;
            }
            if (exc != null || this.getPixelType() != 1) {
                LOGGER.debug("", exc);
                this.in.seek(planeInfo.planeOffset - 298L);
                if (this.in.readByte() == 1) {
                    this.in.skipBytes(297);
                } else {
                    this.in.skipBytes(169);
                }
                int size = 0;
                int expectedBlock = 0;
                int totalBlocks = -1;
                byte[] plane = new byte[FormatTools.getPlaneSize(this)];
                for (int pixPos = 0; expectedBlock != totalBlocks && pixPos < plane.length && this.in.getFilePointer() + 32L < last; pixPos += size) {
                    this.findNextBlock();
                    if (this.in.getFilePointer() + 4L >= this.in.length()) break;
                    int num = this.in.readInt();
                    if (num != expectedBlock) {
                        throw new FormatException("Expected iPic block not found");
                    }
                    ++expectedBlock;
                    if (totalBlocks == -1) {
                        totalBlocks = this.in.readInt();
                        this.in.skipBytes(8);
                    } else {
                        this.in.skipBytes(12);
                    }
                    size = this.in.readInt();
                    this.in.skipBytes(4);
                    if (size + pixPos > plane.length) {
                        size = plane.length - pixPos;
                    }
                    this.in.read(plane, pixPos, size);
                }
                RandomAccessInputStream pix = new RandomAccessInputStream(plane);
                this.readPlane(pix, x, y, w, h, buf);
                pix.close();
                plane = null;
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.pict != null) {
            this.pict.close(fileOnly);
        }
        if (!fileOnly) {
            this.planes = null;
            this.luts = null;
            this.lastPlane = 0;
            this.version = 0;
            this.numSeries = 0;
            this.ycal = 0.0f;
            this.xcal = 0.0f;
            this.nextTag = 0L;
            this.subTag = 0;
            this.tag = 0;
            this.fmt = "";
            this.planeOffsets = null;
            this.detectorOffset = null;
            this.gain = null;
            this.zPos = null;
            this.yPos = null;
            this.xPos = null;
            this.specialPlateNames = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.luts = new Vector();
        LOGGER.info("Verifying Openlab LIFF format");
        this.in.order(false);
        this.in.seek(4L);
        if (!this.in.readString(4).equals("impr")) {
            throw new FormatException("Invalid LIFF file.");
        }
        this.version = this.in.readInt();
        if (this.version != 2 && this.version != 5) {
            throw new FormatException("Invalid version : " + this.version);
        }
        short planeCount = this.in.readShort();
        this.planes = new PlaneInfo[planeCount];
        this.in.skipBytes(2);
        int offset = this.in.readInt();
        this.in.seek(offset);
        LOGGER.info("Finding image offsets");
        this.ycal = 0.0f;
        this.xcal = 0.0f;
        int imagesFound = 0;
        Vector<PlaneInfo> representativePlanes = new Vector<PlaneInfo>();
        while (this.in.getFilePointer() + 8L < this.in.length()) {
            int i2;
            long fp = this.in.getFilePointer();
            this.readTagHeader();
            while (this.tag < 67 || this.tag > 76) {
                this.in.seek(--fp);
                this.readTagHeader();
            }
            if (this.tag == 67 || this.tag == 68) {
                this.planes[imagesFound] = new PlaneInfo();
                this.planes[imagesFound].pict = this.fmt.toLowerCase().equals("pict");
                this.planes[imagesFound].compressed = this.subTag == 0;
                this.in.skipBytes(24);
                this.planes[imagesFound].volumeType = this.in.readShort();
                this.in.skipBytes(16);
                long pointer = this.in.getFilePointer();
                this.planes[imagesFound].planeName = this.in.readCString().trim();
                this.in.skipBytes((int)(256L - this.in.getFilePointer() + pointer));
                this.planes[imagesFound].planeOffset = this.in.getFilePointer();
                if (this.version == 2) {
                    this.in.skipBytes(2);
                    short top = this.in.readShort();
                    short left = this.in.readShort();
                    short bottom = this.in.readShort();
                    short right = this.in.readShort();
                    this.planes[imagesFound].width = right - left;
                    this.planes[imagesFound].height = bottom - top;
                } else {
                    this.planes[imagesFound].width = this.in.readInt();
                    this.planes[imagesFound].height = this.in.readInt();
                }
                for (int i3 = 0; i3 < representativePlanes.size(); ++i3) {
                    PlaneInfo p = (PlaneInfo)representativePlanes.get(i3);
                    if (this.planes[imagesFound].width != p.width || this.planes[imagesFound].height != p.height || this.planes[imagesFound].volumeType != p.volumeType && (this.planes[imagesFound].volumeType < 9 || p.volumeType < 9)) continue;
                    this.planes[imagesFound].series = i3;
                    break;
                }
                if (this.planes[imagesFound].series == -1 && !this.planes[imagesFound].planeName.equals("Original Image")) {
                    this.planes[imagesFound].series = representativePlanes.size();
                    representativePlanes.add(this.planes[imagesFound]);
                }
                if (this.planes[imagesFound].volumeType == 6) {
                    this.in.seek(this.nextTag - 2056L);
                    byte[][] lut = new byte[3][256];
                    for (i2 = 0; i2 < 256; ++i2) {
                        this.in.skipBytes(2);
                        lut[0][255 - i2] = (byte)(this.in.readShort() >> 8);
                        lut[1][255 - i2] = (byte)(this.in.readShort() >> 8);
                        lut[2][255 - i2] = (byte)(this.in.readShort() >> 8);
                    }
                    this.luts.add(lut);
                } else {
                    this.luts.add(null);
                }
                ++imagesFound;
            } else if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                char achar;
                String className;
                if (this.tag == 69) {
                    this.in.skipBytes(4);
                    short units = this.in.readShort();
                    float scaling = units == 3 ? 0.001f : 1.0f;
                    this.in.skipBytes(12);
                    this.xcal = this.in.readFloat() * scaling;
                    this.ycal = this.in.readFloat() * scaling;
                } else if (this.tag == 72 && (className = this.in.readCString()).equals("CVariableList") && (achar = this.in.readChar()) == '\u0001') {
                    int numVars = this.in.readShort();
                    for (i2 = 0; i2 < numVars; ++i2) {
                        this.readVariable();
                    }
                }
            }
            this.in.seek(this.nextTag);
        }
        int nSeries = representativePlanes.size();
        this.planeOffsets = new int[nSeries][];
        Vector<Integer> tmpOffsets = new Vector<Integer>();
        Vector<String> names = new Vector<String>();
        this.core = new CoreMetadata[nSeries];
        for (i = 0; i < nSeries; ++i) {
            int q;
            this.setSeries(i);
            this.core[i] = new CoreMetadata();
            for (q = 0; q < this.planes.length; ++q) {
                if (this.planes[q] == null || this.planes[q].series != i) continue;
                tmpOffsets.add(q);
                names.add(this.planes[q].planeName);
            }
            this.planeOffsets[i] = new int[tmpOffsets.size()];
            for (q = 0; q < this.planeOffsets[i].length; ++q) {
                this.planeOffsets[i][q] = (Integer)tmpOffsets.get(q);
                this.addSeriesMeta("Plane " + q + " Name", names.get(q));
            }
            tmpOffsets.clear();
            names.clear();
        }
        for (i = 0; i < nSeries; ++i) {
            this.setSeries(i);
            this.core[i].indexed = false;
            this.core[i].sizeX = this.planes[this.planeOffsets[i][0]].width;
            this.core[i].sizeY = this.planes[this.planeOffsets[i][0]].height;
            this.core[i].imageCount = this.planeOffsets[i].length;
            this.core[i].sizeC = 1;
            switch (this.planes[this.planeOffsets[i][0]].volumeType) {
                case 1: 
                case 2: 
                case 5: {
                    this.core[i].pixelType = 1;
                    this.core[i].indexed = this.planes[this.planeOffsets[i][0]].pict;
                    break;
                }
                case 6: {
                    this.core[i].pixelType = 1;
                    this.core[i].indexed = true;
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    this.core[i].pixelType = 1;
                    this.core[i].sizeC = 3;
                    break;
                }
                case 9: {
                    this.core[i].bitsPerPixel = 9;
                    break;
                }
                case 10: {
                    this.core[i].bitsPerPixel = 10;
                    break;
                }
                case 11: {
                    this.core[i].bitsPerPixel = 11;
                    break;
                }
                case 12: {
                    this.core[i].bitsPerPixel = 12;
                    break;
                }
                case 13: {
                    this.core[i].bitsPerPixel = 13;
                    break;
                }
                case 14: {
                    this.core[i].bitsPerPixel = 14;
                    break;
                }
                case 15: {
                    this.core[i].bitsPerPixel = 15;
                    break;
                }
                case 3: 
                case 16: {
                    this.core[i].pixelType = 3;
                    break;
                }
                default: {
                    throw new FormatException("Unsupported plane type: " + this.planes[this.planeOffsets[i][0]].volumeType);
                }
            }
            if (this.getBitsPerPixel() > 8) {
                this.core[i].pixelType = 3;
            }
            this.core[i].rgb = this.getSizeC() > 1;
            this.core[i].interleaved = this.isRGB() && this.version == 5;
            this.core[i].sizeT = 1;
            this.core[i].sizeZ = this.getImageCount();
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].littleEndian = false;
            this.core[i].falseColor = false;
            this.core[i].metadataComplete = true;
        }
        int seriesCount = this.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            this.setSeries(s);
            this.parseImageNames(s);
        }
        this.setSeries(0);
        MetadataStore store = this.makeFilterMetadata();
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        boolean planeInfoNeeded = level != MetadataLevel.MINIMUM && (this.xPos != null || this.yPos != null || this.zPos != null);
        MetadataTools.populatePixels(store, this, planeInfoNeeded);
        MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
        if (level != MetadataLevel.MINIMUM) {
            Double stageZ;
            if (this.xcal > 0.0f) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(new Double(this.xcal)), 0);
            }
            if (this.ycal > 0.0f) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(new Double(this.ycal)), 0);
            }
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            try {
                if (this.gain != null) {
                    store.setDetectorSettingsGain(new Double(this.gain), 0, 0);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                if (this.detectorOffset != null) {
                    store.setDetectorSettingsOffset(new Double(this.detectorOffset), 0, 0);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            String detectorID = MetadataTools.createLSID("Detector", 0, 0);
            store.setDetectorID(detectorID, 0, 0);
            store.setDetectorType(this.getDetectorType("Other"), 0, 0);
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                PlaneInfo plane = this.getPlane(new int[]{0, c, 0});
                if (plane == null) continue;
                store.setChannelName(plane.channelName, 0, c);
                store.setDetectorSettingsID(detectorID, 0, c);
            }
            Double stageX = this.xPos == null ? null : new Double(this.xPos);
            Double stageY = this.yPos == null ? null : new Double(this.yPos);
            Double d = stageZ = this.zPos == null ? null : new Double(this.zPos);
            if (stageX != null || stageY != null || stageZ != null) {
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    this.setSeries(series);
                    for (int plane = 0; plane < this.getImageCount(); ++plane) {
                        if (stageX != null) {
                            store.setPlanePositionX(stageX, series, plane);
                        }
                        if (stageY != null) {
                            store.setPlanePositionY(stageY, series, plane);
                        }
                        if (stageZ == null) continue;
                        store.setPlanePositionZ(stageZ, series, plane);
                    }
                }
            }
        }
        this.setSeries(0);
    }

    private void readTagHeader() throws IOException {
        this.tag = this.in.readShort();
        this.subTag = this.in.readShort();
        this.nextTag = this.version == 2 ? (long)this.in.readInt() : this.in.readLong();
        this.fmt = this.in.readString(4);
        this.in.skipBytes(this.version == 2 ? 4 : 8);
    }

    private void readVariable() throws FormatException, IOException {
        String className = this.in.readCString();
        String name = "";
        String value = "";
        int derivedClassVersion = this.in.read();
        if (derivedClassVersion != 1) {
            throw new FormatException("Invalid revision");
        }
        if (className.equals("CStringVariable")) {
            int strSize = this.in.readInt();
            value = this.in.readString(strSize);
            this.in.skipBytes(1);
        } else if (className.equals("CFloatVariable")) {
            value = String.valueOf(this.in.readDouble());
        }
        int baseClassVersion = this.in.read();
        if (baseClassVersion != 1 && baseClassVersion != 2) {
            throw new FormatException("Invalid revision: " + baseClassVersion);
        }
        int strSize = this.in.readInt();
        name = this.in.readString(strSize);
        this.in.skipBytes(baseClassVersion * 2 + 1);
        this.addGlobalMeta(name, value);
        if (name.equals("Gain")) {
            this.gain = value;
        } else if (name.equals("Offset")) {
            this.detectorOffset = value;
        } else if (name.equals("X-Y Stage: X Position")) {
            this.xPos = value;
            this.addGlobalMeta("X position for position #1", this.xPos);
        } else if (name.equals("X-Y Stage: Y Position")) {
            this.yPos = value;
            this.addGlobalMeta("Y position for position #1", this.yPos);
        } else if (name.equals("ZPosition")) {
            this.zPos = value;
            this.addGlobalMeta("Z position for position #1", this.zPos);
        }
    }

    private void parseImageNames(int s) {
        Vector<String> uniqueF = new Vector<String>();
        Vector<String> uniqueC = new Vector<String>();
        Vector<String> uniqueZ = new Vector<String>();
        Vector uniqueT = new Vector();
        String[] axes = new String[]{"Z", "C", "T"};
        this.core[s].dimensionOrder = "XY";
        for (PlaneInfo plane : this.planes) {
            if (plane == null || plane.series != s) continue;
            String name = plane.planeName;
            String[] tokens = name.split("_");
            boolean validField = false;
            try {
                Integer.parseInt(tokens[tokens.length - 1]);
                validField = true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (tokens.length == 4 && !tokens[0].toLowerCase().endsWith("xy") && validField) {
                int endIndex;
                this.specialPlateNames = true;
                if (!uniqueF.contains(tokens[3])) {
                    uniqueF.add(tokens[3]);
                }
                plane.channelName = tokens[0];
                for (endIndex = 0; endIndex < plane.channelName.length() && !Character.isDigit(plane.channelName.charAt(endIndex)); ++endIndex) {
                }
                String zSection = plane.channelName.substring(endIndex);
                if (zSection.equals("")) {
                    zSection = "1";
                }
                plane.channelName = plane.channelName.substring(0, endIndex);
                if (!uniqueC.contains(plane.channelName)) {
                    uniqueC.add(plane.channelName);
                }
                if (!uniqueZ.contains(zSection)) {
                    uniqueZ.add(zSection);
                }
                this.core[s].dimensionOrder = "XYCTZ";
                plane.wavelength = uniqueC.indexOf(plane.channelName);
                plane.timepoint = 0;
                plane.zPosition = uniqueZ.indexOf(zSection);
                plane.series = uniqueF.indexOf(tokens[3]);
                continue;
            }
            for (String axis : axes) {
                String i;
                int end;
                Vector<String> unique = null;
                if (axis.equals("Z")) {
                    unique = uniqueZ;
                } else if (axis.equals("C")) {
                    unique = uniqueC;
                } else if (axis.equals("T")) {
                    unique = uniqueT;
                }
                int index = name.indexOf(axis + "=");
                if (index == -1) {
                    index = name.indexOf(axis + " =");
                }
                if (index == -1) continue;
                int nextEqual = name.indexOf("=", index + 3);
                if (nextEqual < 0) {
                    nextEqual = Math.min(index + 3, name.length());
                }
                if ((end = name.lastIndexOf(" ", nextEqual)) < index) {
                    end = name.length();
                }
                if (unique.contains(i = name.substring(name.indexOf("=", index), end))) continue;
                unique.add(i);
                if (unique.size() <= 1 || this.core[s].dimensionOrder.indexOf(axis) != -1) continue;
                this.core[s].dimensionOrder = this.core[s].dimensionOrder + axis;
            }
        }
        if (this.specialPlateNames) {
            this.core[s].sizeC *= uniqueC.size();
            this.core[s].sizeT = uniqueT.size();
            if (this.core[s].sizeT == 0) {
                this.core[s].sizeT = 1;
            }
            this.core[s].sizeZ = uniqueZ.size();
            if (this.core[s].sizeZ == 0) {
                this.core[s].sizeZ = 1;
            }
            this.core[s].imageCount = this.core[s].sizeC * this.core[s].sizeZ * this.core[s].sizeT;
            if (uniqueF.size() > this.core.length) {
                CoreMetadata currentSeries = this.core[s];
                this.core = new CoreMetadata[uniqueF.size()];
                for (int i = 0; i < this.core.length; ++i) {
                    this.core[i] = currentSeries;
                }
            }
            return;
        }
        if (this.core[s].rgb && uniqueC.size() <= 1) {
            this.core[s].dimensionOrder = this.core[s].dimensionOrder.replaceAll("C", "");
            this.core[s].dimensionOrder = "XYC" + this.core[s].dimensionOrder.substring(2);
        }
        for (String axis : axes) {
            if (this.core[s].dimensionOrder.indexOf(axis) != -1) continue;
            this.core[s].dimensionOrder = this.core[s].dimensionOrder + (String)axis;
        }
        if (uniqueC.size() > 1) {
            this.core[s].sizeC *= uniqueC.size();
            this.core[s].sizeZ /= uniqueC.size();
        }
        if (uniqueT.size() > 1) {
            this.core[s].sizeT = uniqueT.size();
            this.core[s].sizeZ /= this.core[s].sizeT;
        }
        int newCount = this.getSizeZ() * this.getSizeT();
        if (!this.isRGB()) {
            newCount *= this.getSizeC();
        }
        if (newCount < this.getImageCount()) {
            char firstAxis = this.getDimensionOrder().charAt(2);
            if (firstAxis == 'Z') {
                ++this.core[s].sizeZ;
            } else if (firstAxis == 'C' && !this.isRGB()) {
                ++this.core[s].sizeC;
            } else {
                ++this.core[s].sizeT;
            }
            this.core[s].imageCount = this.getSizeZ() * this.getSizeT();
            if (!this.isRGB()) {
                this.core[s].imageCount *= this.getSizeC();
            }
        } else if (newCount > this.getImageCount()) {
            this.core[s].imageCount = newCount;
        }
    }

    private PlaneInfo getPlane(int[] zct) {
        for (PlaneInfo plane : this.planes) {
            if (plane == null || plane.zPosition != zct[0] || plane.wavelength != zct[1] || plane.timepoint != zct[2] || plane.series != this.getSeries()) continue;
            return plane;
        }
        return null;
    }

    private void findNextBlock() throws IOException {
        byte[] buf = new byte[8192];
        this.in.read(buf);
        boolean found = false;
        while (!found && this.in.getFilePointer() < this.in.length()) {
            int i;
            for (i = 0; i < buf.length - 7; ++i) {
                if (buf[i] != 73 || buf[i + 1] != 86 || buf[i + 2] != 69 || buf[i + 3] != 65 || buf[i + 4] != 100 || buf[i + 5] != 98 || buf[i + 6] != 112 || buf[i + 7] != 113) continue;
                found = true;
                this.in.seek(this.in.getFilePointer() - (long)buf.length + (long)i + 8L);
                break;
            }
            if (found) continue;
            for (i = 0; i < 7; ++i) {
                buf[i] = buf[buf.length - (7 - i)];
            }
            this.in.read(buf, 7, buf.length - 7);
        }
    }

    protected class PlaneInfo {
        protected long planeOffset;
        protected int zPosition;
        protected int wavelength;
        protected int timepoint;
        protected String planeName;
        protected long timestamp;
        protected boolean pict;
        protected boolean compressed;
        protected int volumeType;
        protected int width;
        protected int height;
        protected int series = -1;
        protected String channelName;

        protected PlaneInfo() {
        }
    }
}

