/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class MolecularImagingReader
extends FormatReader {
    private static final String MAGIC_STRING = "UK SOFT";
    private static final String DATE_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private long pixelOffset = 0L;

    public MolecularImagingReader() {
        super("Molecular Imaging", "stp");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 16;
        if (!FormatTools.validStream(stream, 16, false)) {
            return false;
        }
        return stream.readString(16).indexOf(MAGIC_STRING) > 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset + (long)(no * FormatTools.getPlaneSize(this)));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].sizeZ = 0;
        String date = null;
        double pixelSizeX = 0.0;
        double pixelSizeY = 0.0;
        String line = this.in.readLine().trim();
        while (!line.endsWith("Data_section")) {
            int space = line.indexOf(" ");
            if (space != -1) {
                String key = line.substring(0, space).trim();
                String value = line.substring(space + 1).trim();
                this.addGlobalMeta(key, value);
                if (key.equals("samples_x")) {
                    this.core[0].sizeX = Integer.parseInt(value);
                } else if (key.equals("samples_y")) {
                    this.core[0].sizeY = Integer.parseInt(value);
                } else if (key.equals("buffer_id")) {
                    ++this.core[0].sizeZ;
                } else if (key.equals("Date")) {
                    date = value;
                } else if (key.equals("time")) {
                    date = date + " " + value;
                } else if (key.equals("length_x")) {
                    pixelSizeX = Double.parseDouble(value) / (double)this.getSizeX();
                } else if (key.equals("length_y")) {
                    pixelSizeY = Double.parseDouble(value) / (double)this.getSizeY();
                }
            }
            line = this.in.readLine().trim();
        }
        this.pixelOffset = this.in.getFilePointer();
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = this.getSizeZ();
        this.core[0].rgb = false;
        this.core[0].pixelType = 3;
        this.core[0].littleEndian = true;
        this.core[0].dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (date != null) {
            store.setImageAcquiredDate(DateTools.formatDate(date, DATE_FORMAT), 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setPixelsPhysicalSizeX(new PositiveFloat(Double.valueOf(pixelSizeX)), 0);
            store.setPixelsPhysicalSizeY(new PositiveFloat(Double.valueOf(pixelSizeY)), 0);
        }
    }
}

