/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;

public class LEOReader
extends BaseTiffReader {
    public static final int LEO_TAG = 34118;
    private double xSize;
    private String date;
    private double workingDistance;

    public LEOReader() {
        super("LEO", "sxm");
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser parser = new TiffParser(stream);
        parser.setDoCaching(false);
        IFD ifd = parser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        return ifd.containsKey(34118);
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        String tag = ((IFD)this.ifds.get(0)).getIFDTextValue(34118);
        String[] lines = tag.split("\n");
        this.date = "";
        for (int line = 10; line < lines.length; ++line) {
            if (lines[line].equals("clock")) {
                this.date = this.date + lines[++line];
                continue;
            }
            if (!lines[line].equals("date")) continue;
            this.date = this.date + " " + lines[++line];
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.xSize = Double.parseDouble(lines[3]) * 1000000.0;
            double eht = Double.parseDouble(lines[6]);
            double filament = Double.parseDouble(lines[7]);
            this.workingDistance = Double.parseDouble(lines[9]);
            this.addGlobalMeta("EHT", eht);
            this.addGlobalMeta("Filament", filament);
            this.addGlobalMeta("Working Distance", this.workingDistance);
            this.addGlobalMeta("Physical pixel size", this.xSize + " um");
            this.addGlobalMeta("Acquisition date", this.date);
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        this.date = DateTools.formatDate(this.date, "HH:mm dd-MMM-yyyy");
        store.setImageAcquiredDate(this.date, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setPixelsPhysicalSizeX(new PositiveFloat(Double.valueOf(this.xSize)), 0);
            store.setPixelsPhysicalSizeY(new PositiveFloat(Double.valueOf(this.xSize)), 0);
            String instrument = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrument, 0);
            store.setImageInstrumentRef(instrument, 0);
            store.setObjectiveID(MetadataTools.createLSID("Objective", 0, 0), 0, 0);
            store.setObjectiveWorkingDistance(this.workingDistance, 0, 0);
            store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
        }
    }
}

