/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class KodakReader
extends FormatReader {
    private static final String MAGIC_STRING = "DTag";
    private static final String PIXELS_STRING = "BSfD";
    private static final String DATE_FORMAT = "HH:mm:ss 'on' MM/dd/yyyy";
    private long pixelOffset;

    public KodakReader() {
        super("Kodak Molecular Imaging", "bip");
        this.domains = new String[]{"Gel/Blot Imaging"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 16;
        if (!FormatTools.validStream(stream, 16, false)) {
            return false;
        }
        return stream.readString(16).indexOf(MAGIC_STRING) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = false;
        this.findString(PIXELS_STRING);
        this.pixelOffset = this.in.getFilePointer() + (long)PIXELS_STRING.length() + 20L;
        this.core[0].sizeX = 1024;
        this.core[0].sizeY = 1024;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = 6;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        this.readExtraMetadata(store);
    }

    private void findString(String marker) throws IOException {
        byte[] buf = new byte[8192];
        int overlap = marker.length();
        this.in.read(buf, 0, overlap);
        while (this.in.getFilePointer() < this.in.length()) {
            this.in.read(buf, overlap, buf.length - overlap);
            for (int i = 0; i < buf.length - overlap; ++i) {
                if (!marker.equals(new String(buf, i, marker.length()))) continue;
                this.in.seek(this.in.getFilePointer() - (long)buf.length + (long)i);
                return;
            }
            System.arraycopy(buf, buf.length - overlap, buf, 0, overlap);
        }
    }

    private void readExtraMetadata(MetadataStore store) throws IOException {
        String[] lines;
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        this.in.seek(0L);
        this.findString("Image Capture Source");
        String metadata = this.in.readCString();
        for (String line : lines = metadata.split("\n")) {
            Double size;
            int index = line.indexOf(":");
            if (index < 0 || line.startsWith("#") || line.startsWith("-")) continue;
            String key = line.substring(0, index).trim();
            String value = line.substring(index + 1).trim();
            this.addGlobalMeta(key, value);
            if (key.equals("Image Capture Source")) {
                String instrument = MetadataTools.createLSID("Instrument", 0);
                store.setInstrumentID(instrument, 0);
                store.setImageInstrumentRef(instrument, 0);
                store.setMicroscopeModel(value, 0);
                continue;
            }
            if (key.equals("Capture Time/Date")) {
                store.setImageAcquiredDate(DateTools.formatDate(value, DATE_FORMAT), 0);
                continue;
            }
            if (key.equals("Exposure Time")) {
                Double exposure = new Double(value.substring(0, value.indexOf(" ")));
                store.setPlaneExposureTime(exposure, 0, 0);
                continue;
            }
            if (key.equals("Vertical Resolution")) {
                value = value.substring(0, value.indexOf(" "));
                size = new Double(value);
                size = 1.0 / (size * 3.937007874015748E-5);
                store.setPixelsPhysicalSizeY(new PositiveFloat(size), 0);
                continue;
            }
            if (key.equals("Horizontal Resolution")) {
                value = value.substring(0, value.indexOf(" "));
                size = new Double(value);
                size = 1.0 / (size * 3.937007874015748E-5);
                store.setPixelsPhysicalSizeX(new PositiveFloat(size), 0);
                continue;
            }
            if (!key.equals("CCD Temperature")) continue;
            Double temp = new Double(value.substring(0, value.indexOf(" ")));
            store.setImagingEnvironmentTemperature(temp, 0);
        }
    }
}

