/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.DelegateReader;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.ImageIOReader;
import loci.formats.in.TileJPEGReader;

public class JPEGReader
extends DelegateReader {
    private static final int MAX_SIZE = 8192;

    public JPEGReader() {
        super("JPEG", new String[]{"jpg", "jpeg", "jpe"});
        this.nativeReader = new DefaultJPEGReader();
        this.legacyReader = new TileJPEGReader();
        this.nativeReaderInitialized = false;
        this.legacyReaderInitialized = false;
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
    }

    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        if (this.getSizeX() > 8192 && this.getSizeY() > 8192 && !this.legacyReaderInitialized) {
            this.close();
            this.useLegacy = true;
            super.setId(id);
        }
    }

    class DefaultJPEGReader
    extends ImageIOReader {
        public DefaultJPEGReader() {
            super("JPEG", new String[]{"jpg", "jpeg", "jpe"});
            this.suffixNecessary = false;
            this.suffixSufficient = false;
        }

        public boolean isThisType(RandomAccessInputStream stream) throws IOException {
            int blockLen = 4;
            if (!FormatTools.validStream(stream, 4, false)) {
                return false;
            }
            byte[] signature = new byte[4];
            stream.read(signature);
            return signature[0] == -1 && signature[1] == -40 && signature[2] == -1 && (signature[3] & 0xF0) == 224;
        }
    }
}

