/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.TileJPEGReader;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class HamamatsuVMSReader
extends FormatReader {
    private ArrayList<String> files = new ArrayList();
    private String[][][] tileFiles;
    private TileJPEGReader[] jpeg;

    public HamamatsuVMSReader() {
        super("Hamamatsu VMS", "vms");
        this.domains = new String[]{"Histology"};
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        ArrayList<String> f = new ArrayList<String>();
        f.add(this.jpeg[this.getSeries()].getCurrentFile());
        f.addAll(this.files);
        return f.toArray(new String[f.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.jpeg[this.getSeries()].openBytes(no, buf, x, y, w, h);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tileFiles = null;
            this.files.clear();
            if (this.jpeg != null) {
                for (TileJPEGReader j : this.jpeg) {
                    if (j == null) continue;
                    j.close();
                }
                this.jpeg = null;
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        IniParser parser = new IniParser();
        IniList layout = parser.parseINI(new BufferedReader(new FileReader(id)));
        IniTable slideInfo = layout.getTable("Virtual Microscope Specimen");
        int nLayers = Integer.parseInt((String)slideInfo.get("NoLayers"));
        int nRows = Integer.parseInt((String)slideInfo.get("NoJpegRows"));
        int nCols = Integer.parseInt((String)slideInfo.get("NoJpegColumns"));
        String imageFile = (String)slideInfo.get("ImageFile");
        String mapFile = (String)slideInfo.get("MapFile");
        String optimisationFile = (String)slideInfo.get("OptimisationFile");
        String macroFile = (String)slideInfo.get("MacroImage");
        Double physicalWidth = new Double((String)slideInfo.get("PhysicalWidth"));
        Double physicalHeight = new Double((String)slideInfo.get("PhysicalHeight"));
        Double magnification = new Double((String)slideInfo.get("SourceLens"));
        Double macroWidth = new Double((String)slideInfo.get("PhysicalMacroWidth"));
        Double macroHeight = new Double((String)slideInfo.get("PhysicalMacroHeight"));
        for (String key : slideInfo.keySet()) {
            this.addGlobalMeta(key, slideInfo.get(key));
        }
        Location dir = new Location(id).getAbsoluteFile().getParentFile();
        this.tileFiles = new String[nLayers][nRows][nCols];
        for (int layer = 0; layer < nLayers; ++layer) {
            for (int row = 0; row < nRows; ++row) {
                for (int col = 0; col < nCols; ++col) {
                    this.tileFiles[layer][row][col] = (String)slideInfo.get("ImageFile(" + col + "," + row + ")");
                    if (this.tileFiles[layer][row][col] == null) continue;
                    this.files.add(new Location(dir, this.tileFiles[layer][row][col]).getAbsolutePath());
                }
            }
        }
        if (imageFile != null) {
            imageFile = new Location(dir, imageFile).getAbsolutePath();
        }
        if (mapFile != null) {
            mapFile = new Location(dir, mapFile).getAbsolutePath();
        }
        if (optimisationFile != null) {
            optimisationFile = new Location(dir, optimisationFile).getAbsolutePath();
            this.files.add(optimisationFile);
        }
        if (macroFile != null) {
            macroFile = new Location(dir, macroFile).getAbsolutePath();
        }
        this.jpeg = new TileJPEGReader[3];
        this.core = new CoreMetadata[3];
        for (int i = 0; i < this.core.length; ++i) {
            String file = null;
            switch (i) {
                case 0: {
                    file = imageFile;
                    break;
                }
                case 1: {
                    file = macroFile;
                    break;
                }
                case 2: {
                    file = mapFile;
                }
            }
            this.jpeg[i] = new TileJPEGReader();
            this.jpeg[i].setId(file);
            this.core[i] = this.jpeg[i].getCoreMetadata()[0];
            this.core[i].thumbnail = i > 0;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String path = new Location(this.currentId).getAbsoluteFile().getName();
        store.setImageName(path + " full resolution", 0);
        store.setImageName(path + " macro", 1);
        store.setImageName(path + " map", 2);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setPixelsPhysicalSizeX(new PositiveFloat(Double.valueOf(physicalWidth / (double)this.core[0].sizeX)), 0);
            store.setPixelsPhysicalSizeY(new PositiveFloat(Double.valueOf(physicalHeight / (double)this.core[0].sizeY)), 0);
            store.setPixelsPhysicalSizeX(new PositiveFloat(Double.valueOf(macroWidth / (double)this.core[1].sizeX)), 1);
            store.setPixelsPhysicalSizeY(new PositiveFloat(Double.valueOf(macroHeight / (double)this.core[1].sizeY)), 1);
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setObjectiveNominalMagnification(new PositiveInteger(Integer.valueOf(magnification.intValue())), 0, 0);
            store.setImageObjectiveSettingsID(objectiveID, 0);
        }
    }
}

