/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class GatanReader
extends FormatReader {
    public static final int DM3_MAGIC_BYTES = 3;
    private static final int GROUP = 20;
    private static final int VALUE = 21;
    private static final int ARRAY = 15;
    private static final int SHORT = 2;
    private static final int USHORT = 4;
    private static final int INT = 3;
    private static final int UINT = 5;
    private static final int FLOAT = 6;
    private static final int DOUBLE = 7;
    private static final int BYTE = 8;
    private static final int UBYTE = 9;
    private static final int CHAR = 10;
    private long pixelOffset;
    private Vector<Double> pixelSizes;
    private int bytesPerPixel;
    private int pixelDataNum = 0;
    private int numPixelBytes;
    private boolean signed;
    private long timestamp;
    private double gamma;
    private double mag;
    private double voltage;
    private String info;
    private boolean adjustEndianness = true;

    public GatanReader() {
        super("Gatan Digital Micrograph", "dm3");
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == 3;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
            this.numPixelBytes = 0;
            this.pixelDataNum = 0;
            this.bytesPerPixel = 0;
            this.pixelSizes = null;
            this.signed = false;
            this.timestamp = 0L;
            this.voltage = 0.0;
            this.mag = 0.0;
            this.gamma = 0.0;
            this.info = null;
            this.adjustEndianness = true;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.pixelOffset = 0L;
        LOGGER.info("Verifying Gatan format");
        this.core[0].littleEndian = false;
        this.pixelSizes = new Vector();
        this.in.order(this.isLittleEndian());
        if (this.in.readInt() != 3) {
            throw new FormatException("invalid header");
        }
        LOGGER.info("Reading tags");
        this.in.skipBytes(4);
        this.core[0].littleEndian = this.in.readInt() != 1;
        this.in.order(this.isLittleEndian());
        this.in.skipBytes(2);
        int numTags = this.in.readInt();
        if ((long)numTags > this.in.length()) {
            this.core[0].littleEndian = !this.isLittleEndian();
            this.in.order(this.isLittleEndian());
            this.adjustEndianness = false;
        }
        LOGGER.debug("tags ({}) {", (Object)numTags);
        this.parseTags(numTags, null, "  ");
        LOGGER.debug("}");
        LOGGER.info("Populating metadata");
        this.core[0].littleEndian = true;
        if (this.getSizeX() == 0 || this.getSizeY() == 0) {
            throw new FormatException("Dimensions information not found");
        }
        int bytes = this.numPixelBytes / (this.getSizeX() * this.getSizeY());
        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bytes, this.signed, false);
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYZTC";
        this.core[0].imageCount = 1;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String[] scopeInfo;
            if (this.pixelSizes.size() >= 3) {
                int index = this.pixelSizes.size() - 3;
                Double x = this.pixelSizes.get(index);
                Double y = this.pixelSizes.get(index + 1);
                Double z = this.pixelSizes.get(index + 2);
                store.setPixelsPhysicalSizeX(new PositiveFloat(x), 0);
                store.setPixelsPhysicalSizeY(new PositiveFloat(y), 0);
                store.setPixelsPhysicalSizeZ(new PositiveFloat(z), 0);
            }
            if (this.info == null) {
                this.info = "";
            }
            for (String token : scopeInfo = this.info.split("\\(")) {
                if (!(token = token.trim()).startsWith("Mode")) continue;
                String mode = (token = token.substring(token.indexOf(" ")).trim()).substring(0, token.indexOf(" ")).trim();
                if (mode.equals("TEM")) {
                    mode = "Other";
                }
                store.setChannelAcquisitionMode(this.getAcquisitionMode(mode), 0, 0);
            }
        }
    }

    private void parseTags(int numTags, String parent, String indent) throws FormatException, IOException {
        for (int i = 0; i < numTags && this.in.getFilePointer() < this.in.length(); ++i) {
            byte type = this.in.readByte();
            int length = this.in.readShort();
            String labelString = null;
            String value = null;
            if (type == 21) {
                int j;
                int numFields;
                labelString = this.in.readString(length);
                int skip = this.in.readInt();
                int n = this.in.readInt();
                int dataType = this.in.readInt();
                String sb = labelString;
                if (sb.length() > 32) {
                    sb = sb.substring(0, 20) + "... (" + sb.length() + ")";
                }
                LOGGER.debug("{}{}: n={}, dataType={}, label={}", new Object[]{indent, i, n, dataType, sb});
                if (skip != 0x25252525) {
                    LOGGER.warn("Skip mismatch: {}", (Object)skip);
                }
                if (n == 1) {
                    if ("Dimensions".equals(parent) && labelString.length() == 0) {
                        if (this.adjustEndianness) {
                            this.in.order(!this.in.isLittleEndian());
                        }
                        if (i == 0) {
                            this.core[0].sizeX = this.in.readInt();
                        } else if (i == 1) {
                            this.core[0].sizeY = this.in.readInt();
                        }
                        if (this.adjustEndianness) {
                            this.in.order(!this.in.isLittleEndian());
                        }
                    } else {
                        value = String.valueOf(this.readValue(dataType));
                    }
                } else if (n == 2) {
                    if (dataType == 18) {
                        length = this.in.readInt();
                    } else {
                        LOGGER.warn("dataType mismatch: {}", (Object)dataType);
                    }
                    value = this.in.readString(length);
                } else if (n == 3) {
                    if (dataType == 20) {
                        dataType = this.in.readInt();
                        length = this.in.readInt();
                        if (labelString.equals("Data")) {
                            this.pixelOffset = this.in.getFilePointer();
                            this.in.skipBytes(this.getNumBytes(dataType) * length);
                            this.numPixelBytes = (int)(this.in.getFilePointer() - this.pixelOffset);
                        } else if (dataType == 10) {
                            this.in.skipBytes(length);
                        } else {
                            value = DataTools.stripString(this.in.readString(length * 2));
                        }
                    } else {
                        LOGGER.warn("dataType mismatch: {}", (Object)dataType);
                    }
                } else if (dataType == 15) {
                    boolean lastTag;
                    this.in.skipBytes(4);
                    numFields = this.in.readInt();
                    StringBuffer s = new StringBuffer();
                    this.in.skipBytes(4);
                    for (j = 0; j < numFields; ++j) {
                        dataType = this.in.readInt();
                        s.append(this.readValue(dataType));
                        if (j >= numFields - 1) continue;
                        s.append(", ");
                    }
                    value = s.toString();
                    boolean bl = lastTag = parent == null && i == numTags - 1;
                    if (!lastTag) {
                        int b = 0;
                        int[] jumps = new int[]{4, 7, 5, 9};
                        for (int j2 = 0; j2 < jumps.length; ++j2) {
                            this.in.skipBytes(jumps[j2]);
                            if (this.in.getFilePointer() >= this.in.length()) {
                                return;
                            }
                            b = this.in.readByte();
                            if (b == 20 || b == 21) break;
                        }
                        if (b != 20 && b != 21) {
                            throw new FormatException("Cannot find next tag (pos=" + this.in.getFilePointer() + ", label=" + labelString + ")");
                        }
                        this.in.seek(this.in.getFilePointer() - 1L);
                    }
                } else if (dataType == 20) {
                    dataType = this.in.readInt();
                    if (dataType == 15) {
                        this.in.skipBytes(4);
                        numFields = this.in.readInt();
                        int[] dataTypes = new int[numFields];
                        for (j = 0; j < numFields; ++j) {
                            this.in.skipBytes(4);
                            dataTypes[j] = this.in.readInt();
                        }
                        int len = this.in.readInt();
                        double[][] values = new double[numFields][len];
                        for (int k = 0; k < len; ++k) {
                            for (int q = 0; q < numFields; ++q) {
                                values[q][k] = this.readValue(dataTypes[q]);
                            }
                        }
                    } else {
                        LOGGER.warn("dataType mismatch: {}", (Object)dataType);
                    }
                }
            } else if (type == 20) {
                labelString = this.in.readString(length);
                this.in.skipBytes(2);
                int num = this.in.readInt();
                LOGGER.debug("{}{}: group({}) {", new Object[]{indent, i, num});
                this.parseTags(num, labelString, indent + "  ");
                LOGGER.debug("{}}", (Object)indent);
            } else {
                LOGGER.debug("{}{}: unknown type: {}", new Object[]{indent, i, type});
            }
            if (value == null) continue;
            this.addGlobalMeta(labelString, value);
            if (labelString.equals("Scale")) {
                if (value.indexOf(",") == -1) {
                    this.pixelSizes.add(new Double(value));
                }
            } else if (labelString.equals("LowLimit")) {
                this.signed = Double.parseDouble(value) < 0.0;
            } else if (labelString.equals("Acquisition Start Time (epoch)")) {
                this.timestamp = (long)Double.parseDouble(value);
            } else if (labelString.equals("Voltage")) {
                this.voltage = Double.parseDouble(value);
            } else if (labelString.equals("Microscope Info")) {
                this.info = value;
            } else if (labelString.equals("Indicated Magnification")) {
                this.mag = Double.parseDouble(value);
            } else if (labelString.equals("Gamma")) {
                this.gamma = Double.parseDouble(value);
            }
            value = null;
        }
    }

    private double readValue(int type) throws IOException {
        switch (type) {
            case 2: 
            case 4: {
                return this.in.readShort();
            }
            case 3: 
            case 5: {
                return this.in.readInt();
            }
            case 6: {
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                float f = this.in.readFloat();
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                return f;
            }
            case 7: {
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                double dbl = this.in.readDouble();
                if (this.adjustEndianness) {
                    this.in.order(!this.in.isLittleEndian());
                }
                return dbl;
            }
            case 8: 
            case 9: 
            case 10: {
                return this.in.readByte();
            }
        }
        return 0.0;
    }

    private int getNumBytes(int type) {
        switch (type) {
            case 2: 
            case 4: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: 
            case 9: 
            case 10: {
                return 1;
            }
        }
        return 0;
    }
}

