/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BMPReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class FV1000Reader
extends FormatReader {
    public static final String FV1000_MAGIC_STRING_1 = "FileInformation";
    public static final String FV1000_MAGIC_STRING_2 = "Acquisition Parameters";
    public static final String[] OIB_SUFFIX = new String[]{"oib"};
    public static final String[] OIF_SUFFIX = new String[]{"oif"};
    public static final String[] FV1000_SUFFIXES = new String[]{"oib", "oif"};
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int NUM_DIMENSIONS = 9;
    private static final int POINT = 2;
    private static final int LINE = 3;
    private static final int POLYLINE = 4;
    private static final int RECTANGLE = 5;
    private static final int CIRCLE = 6;
    private static final int ELLIPSE = 7;
    private static final int POLYGON = 8;
    private static final int FREE_SHAPE = 9;
    private static final int FREE_LINE = 10;
    private static final int GRID = 11;
    private static final int ARROW = 12;
    private static final int COLOR_BAR = 13;
    private static final int SCALE = 15;
    private static final String ROTATION = "rotate(%d %f %f)";
    private IniParser parser = new IniParser();
    private Vector<String> tiffs;
    private String thumbId;
    private BMPReader thumbReader;
    private Vector<String> usedFiles;
    private boolean isOIB;
    private Hashtable<String, String> oibMapping;
    private String[] code;
    private String[] size;
    private Double[] pixelSize;
    private int imageDepth;
    private Vector<String> previewNames;
    private String pixelSizeX;
    private String pixelSizeY;
    private int validBits;
    private Vector<String> illuminations;
    private Vector<Integer> wavelengths;
    private String pinholeSize;
    private String magnification;
    private String lensNA;
    private String objectiveName;
    private String workingDistance;
    private String creationDate;
    private Vector<ChannelData> channels;
    private Vector<String> lutNames = new Vector();
    private Hashtable<Integer, String> filenames = new Hashtable();
    private Hashtable<Integer, String> roiFilenames = new Hashtable();
    private POIService poi;
    private short[][][] lut;
    private int lastChannel;
    private double pixelSizeZ = 1.0;
    private double pixelSizeT = 1.0;
    private String ptyStart = null;
    private String ptyEnd = null;
    private String ptyPattern = null;
    private String line = null;

    public FV1000Reader() {
        super("Olympus FV1000", new String[]{"oib", "oif", "pty", "lut"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        RandomAccessInputStream plane = this.getPlane(this.getSeries(), 0);
        if (plane == null) {
            return super.getOptimalTileWidth();
        }
        try {
            TiffParser tp = new TiffParser(plane);
            IFD ifd = tp.getFirstIFD();
            plane.close();
            return (int)ifd.getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug("Could not retrieve tile width", (Throwable)e);
        }
        return super.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        RandomAccessInputStream plane = this.getPlane(this.getSeries(), 0);
        if (plane == null) {
            return super.getOptimalTileHeight();
        }
        try {
            TiffParser tp = new TiffParser(plane);
            IFD ifd = tp.getFirstIFD();
            plane.close();
            return (int)ifd.getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug("Could not retrieve tile height", (Throwable)e);
        }
        return super.getOptimalTileHeight();
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return FV1000Reader.checkSuffix(id, OIB_SUFFIX);
    }

    public boolean isThisType(String name, boolean open) {
        if (FV1000Reader.checkSuffix(name, FV1000_SUFFIXES)) {
            return true;
        }
        if (!open) {
            return false;
        }
        try {
            Location oif = new Location(this.findOIFFile(name));
            return oif.exists() && !oif.isDirectory() && FV1000Reader.checkSuffix(oif.getAbsolutePath(), "oif") && !FV1000Reader.checkSuffix(name, "bmp");
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 1024;
        if (!FormatTools.validStream(stream, 1024, false)) {
            return false;
        }
        String s = DataTools.stripString(stream.readString(1024));
        return s.indexOf(FV1000_MAGIC_STRING_1) >= 0 || s.indexOf(FV1000_MAGIC_STRING_2) >= 0;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        if (FV1000Reader.checkSuffix(id, OIB_SUFFIX)) {
            return 2;
        }
        return 0;
    }

    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut == null || !this.isIndexed() ? (short[][])null : this.lut[this.lastChannel];
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int nFiles = this.getSeries() == 0 ? this.tiffs.size() : this.previewNames.size();
        int image = no % (this.getImageCount() / nFiles);
        int[] coords = this.getZCTCoords(image);
        this.lastChannel = coords[1];
        RandomAccessInputStream plane = this.getPlane(this.getSeries(), no);
        if (plane == null) {
            return buf;
        }
        TiffParser tp = new TiffParser(plane);
        IFDList ifds = tp.getIFDs();
        if (image >= ifds.size()) {
            return buf;
        }
        IFD ifd = (IFD)ifds.get(image);
        if ((long)this.getSizeY() != ifd.getImageLength()) {
            tp.getSamples(ifd, buf, x, this.getIndex(coords[0], 0, coords[2]), w, 1L);
        } else {
            tp.getSamples(ifd, buf, x, y, w, h);
        }
        plane.close();
        plane = null;
        tp = null;
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.isOIB) {
            String[] stringArray;
            if (noPixels) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.currentId;
            }
            return stringArray;
        }
        Vector<String> files = new Vector<String>();
        if (this.usedFiles != null) {
            for (String file : this.usedFiles) {
                String f = file.toLowerCase();
                if (f.endsWith(".tif") || f.endsWith(".tiff") || f.endsWith(".bmp")) continue;
                files.add(file);
            }
        }
        if (!noPixels) {
            if (this.getSeries() == 0 && this.tiffs != null) {
                files.addAll(this.tiffs);
            } else if (this.getSeries() == 1 && this.previewNames != null) {
                files.addAll(this.previewNames);
            }
        }
        return files.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.thumbReader != null) {
            this.thumbReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.usedFiles = null;
            this.tiffs = null;
            this.filenames = new Hashtable();
            this.roiFilenames = new Hashtable();
            this.thumbReader = null;
            this.thumbId = null;
            this.isOIB = false;
            this.previewNames = null;
            if (this.poi != null) {
                this.poi.close();
            }
            this.poi = null;
            this.lastChannel = 0;
            this.wavelengths = null;
            this.illuminations = null;
            this.oibMapping = null;
            this.size = null;
            this.code = null;
            this.pixelSize = null;
            this.imageDepth = 0;
            this.pixelSizeY = null;
            this.pixelSizeX = null;
            this.validBits = 0;
            this.pinholeSize = null;
            this.workingDistance = null;
            this.objectiveName = null;
            this.lensNA = null;
            this.magnification = null;
            this.creationDate = null;
            this.lut = null;
            this.channels = null;
            if (this.lutNames != null) {
                this.lutNames.clear();
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String key;
        String[] saveKeys;
        super.initFile(id);
        this.parser.setCommentDelimiter(null);
        this.isOIB = FV1000Reader.checkSuffix(id, OIB_SUFFIX);
        if (this.isOIB) {
            try {
                ServiceFactory factory = new ServiceFactory();
                this.poi = factory.getInstance(POIService.class);
            }
            catch (DependencyException de) {
                throw new FormatException("POI library not found", de);
            }
            this.poi.initialize(Location.getMappedId(id));
        }
        boolean mappedOIF = !this.isOIB && !new File(id).getAbsoluteFile().exists();
        this.wavelengths = new Vector();
        this.illuminations = new Vector();
        this.channels = new Vector();
        String oifName = null;
        if (this.isOIB) {
            oifName = this.mapOIBFiles();
        } else {
            if (!FV1000Reader.checkSuffix(id, OIF_SUFFIX)) {
                this.currentId = this.findOIFFile(id);
                this.initFile(this.currentId);
            }
            oifName = this.currentId;
        }
        String oifPath = new Location(oifName).getAbsoluteFile().getAbsolutePath();
        String path = this.isOIB || !oifPath.endsWith(oifName) || mappedOIF ? "" : oifPath.substring(0, oifPath.lastIndexOf(File.separator) + 1);
        try {
            RandomAccessInputStream s = this.getFile(oifName);
            s.close();
        }
        catch (IOException e) {
            oifName = oifName.replaceAll(".oif", ".OIF");
        }
        this.code = new String[9];
        this.size = new String[9];
        this.pixelSize = new Double[9];
        this.previewNames = new Vector();
        boolean laserEnabled = true;
        IniList f = this.getIniFile(oifName);
        IniTable saveInfo = f.getTable("ProfileSaveInfo");
        for (String key2 : saveKeys = saveInfo.keySet().toArray(new String[saveInfo.size()])) {
            String value = ((String)saveInfo.get(key2)).toString();
            value = this.sanitizeValue(value).trim();
            if (key2.startsWith("IniFileName") && key2.indexOf("Thumb") == -1 && !this.isPreviewName(value)) {
                if (mappedOIF) {
                    value = value.substring(value.lastIndexOf(File.separator) + 1).trim();
                }
                this.filenames.put(new Integer(key2.substring(11)), value);
                continue;
            }
            if (key2.startsWith("RoiFileName") && key2.indexOf("Thumb") == -1 && !this.isPreviewName(value)) {
                if (mappedOIF) {
                    value = value.substring(value.lastIndexOf(File.separator) + 1).trim();
                }
                try {
                    this.roiFilenames.put(new Integer(key2.substring(11)), value);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (key2.equals("PtyFileNameS")) {
                this.ptyStart = value;
                continue;
            }
            if (key2.equals("PtyFileNameE")) {
                this.ptyEnd = value;
                continue;
            }
            if (key2.equals("PtyFileNameT2")) {
                this.ptyPattern = value;
                continue;
            }
            if (key2.indexOf("Thumb") != -1) {
                if (mappedOIF) {
                    value = value.substring(value.lastIndexOf(File.separator) + 1);
                }
                if (this.thumbId != null) continue;
                this.thumbId = value.trim();
                continue;
            }
            if (key2.startsWith("LutFileName")) {
                if (mappedOIF) {
                    value = value.substring(value.lastIndexOf(File.separator) + 1);
                }
                this.lutNames.add(path + value);
                continue;
            }
            if (!this.isPreviewName(value)) continue;
            if (mappedOIF) {
                value = value.substring(value.lastIndexOf(File.separator) + 1);
            }
            this.previewNames.add(path + value.trim());
        }
        if (this.filenames.size() == 0) {
            this.addPtyFiles();
        }
        for (int i = 0; i < 9; ++i) {
            IniTable commonParams = f.getTable("Axis " + i + " Parameters Common");
            this.code[i] = (String)commonParams.get("AxisCode");
            this.size[i] = (String)commonParams.get("MaxSize");
            double end = Double.parseDouble((String)commonParams.get("EndPosition"));
            double start = Double.parseDouble((String)commonParams.get("StartPosition"));
            this.pixelSize[i] = end - start;
        }
        IniTable referenceParams = f.getTable("Reference Image Parameter");
        this.imageDepth = Integer.parseInt((String)referenceParams.get("ImageDepth"));
        this.pixelSizeX = (String)referenceParams.get("WidthConvertValue");
        this.pixelSizeY = (String)referenceParams.get("HeightConvertValue");
        String ripValidBitCounts = (String)referenceParams.get("ValidBitCounts");
        if (ripValidBitCounts != null) {
            this.validBits = Integer.parseInt(ripValidBitCounts);
        }
        int index = 0;
        IniTable laser = f.getTable("Laser " + index + " Parameters");
        while (laser != null) {
            laserEnabled = ((String)laser.get("Laser Enable")).equals("1");
            if (laserEnabled) {
                this.wavelengths.add(new Integer((String)laser.get("LaserWavelength")));
            }
            this.creationDate = (String)laser.get("ImageCaputreDate");
            if (this.creationDate == null) {
                this.creationDate = (String)laser.get("ImageCaptureDate");
            }
            laser = f.getTable("Laser " + ++index + " Parameters");
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Object channel;
            index = 1;
            IniTable guiChannel = f.getTable("GUI Channel " + index + " Parameters");
            while (guiChannel != null) {
                String voltage;
                channel = new ChannelData();
                String gain = (String)guiChannel.get("AnalogPMTGain");
                if (gain != null) {
                    ((ChannelData)channel).gain = new Double(gain);
                }
                if ((voltage = (String)guiChannel.get("AnalogPMTVoltage")) != null) {
                    ((ChannelData)channel).voltage = new Double(voltage);
                }
                ((ChannelData)channel).barrierFilter = (String)guiChannel.get("BF Name");
                ((ChannelData)channel).active = Integer.parseInt((String)guiChannel.get("CH Activate")) != 0;
                ((ChannelData)channel).name = (String)guiChannel.get("CH Name");
                ((ChannelData)channel).dyeName = (String)guiChannel.get("DyeName");
                ((ChannelData)channel).emissionFilter = (String)guiChannel.get("EmissionDM Name");
                ((ChannelData)channel).emWave = new Integer((String)guiChannel.get("EmissionWavelength"));
                ((ChannelData)channel).excitationFilter = (String)guiChannel.get("ExcitationDM Name");
                ((ChannelData)channel).exWave = new Integer((String)guiChannel.get("ExcitationWavelength"));
                this.channels.add((ChannelData)channel);
                guiChannel = f.getTable("GUI Channel " + ++index + " Parameters");
            }
            index = 1;
            channel = f.getTable("Channel " + index + " Parameters");
            while (channel != null) {
                String illumination = (String)((HashMap)channel).get("LightType");
                if (illumination != null) {
                    illumination = illumination.toLowerCase();
                }
                if (illumination != null) {
                    illumination = illumination.indexOf("fluorescence") != -1 ? "Epifluorescence" : (illumination.indexOf("transmitted") != -1 ? "Transmitted" : null);
                }
                this.illuminations.add(illumination);
                channel = f.getTable("Channel " + ++index + " Parameters");
            }
            HashMap<String, String> iniMap = f.flattenIntoHashMap();
            this.metadata.putAll(iniMap);
        }
        LOGGER.info("Initializing helper readers");
        if (this.previewNames.size() > 0) {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < this.previewNames.size(); ++i) {
                String ss = this.previewNames.get(i);
                if (!(ss = this.replaceExtension(ss, "pty", "tif")).endsWith(".tif")) continue;
                v.add(ss);
            }
            this.previewNames = v;
            if (this.previewNames.size() > 0) {
                this.core = new CoreMetadata[2];
                this.core[0] = new CoreMetadata();
                this.core[1] = new CoreMetadata();
                ArrayList ifds = null;
                for (String previewName : this.previewNames) {
                    RandomAccessInputStream preview = this.getFile(previewName);
                    TiffParser tp = new TiffParser(preview);
                    ifds = tp.getIFDs();
                    preview.close();
                    tp = null;
                    this.core[1].imageCount += ifds.size();
                }
                this.core[1].sizeX = (int)((IFD)ifds.get(0)).getImageWidth();
                this.core[1].sizeY = (int)((IFD)ifds.get(0)).getImageLength();
                this.core[1].sizeZ = 1;
                this.core[1].sizeT = 1;
                this.core[1].sizeC = this.core[1].imageCount;
                this.core[1].rgb = false;
                int bits = ((IFD)ifds.get(0)).getBitsPerSample()[0];
                while (bits % 8 != 0) {
                    ++bits;
                }
                this.core[1].pixelType = FormatTools.pixelTypeFromBytes(bits /= 8, false, false);
                this.core[1].dimensionOrder = "XYCZT";
                this.core[1].indexed = false;
            }
        }
        this.core[0].imageCount = this.filenames.size();
        this.tiffs = new Vector(this.getImageCount());
        this.thumbReader = new BMPReader();
        this.thumbId = this.replaceExtension(this.thumbId, "pty", "bmp");
        this.thumbId = this.sanitizeFile(this.thumbId, path);
        LOGGER.info("Reading additional metadata");
        String tiffPath = null;
        this.core[0].dimensionOrder = "XY";
        Hashtable values = new Hashtable();
        Vector<String> baseKeys = new Vector<String>();
        int i = 0;
        for (int ii = 0; ii < this.getImageCount(); ++ii) {
            String file = this.filenames.get(new Integer(i));
            while (file == null) {
                file = this.filenames.get(new Integer(++i));
            }
            tiffPath = (file = this.sanitizeFile(file, path)).indexOf(File.separator) != -1 ? file.substring(0, file.lastIndexOf(File.separator)) : file;
            Location ptyFile = new Location(file);
            if (!this.isOIB && !ptyFile.exists()) {
                LOGGER.warn("Could not find .pty file ({}); guessing at the corresponding TIFF file.", (Object)file);
                String tiff = this.replaceExtension(file, ".pty", ".tif");
                this.tiffs.add(ii, tiff);
            } else {
                IniTable axis;
                IniList pty = this.getIniFile(file);
                IniTable fileInfo = pty.getTable("File Info");
                if (!this.isPreviewName(file = this.sanitizeValue((String)fileInfo.get("DataName")))) {
                    while (file.indexOf("GST") != -1) {
                        file = this.removeGST(file);
                    }
                    if (!mappedOIF) {
                        file = this.isOIB ? tiffPath + File.separator + file : new Location(tiffPath, file).getAbsolutePath();
                    }
                    this.tiffs.add(ii, file);
                }
                for (int dim = 0; dim < 9 && (axis = pty.getTable("Axis " + dim + " Parameters")) != null; ++dim) {
                    boolean addAxis;
                    boolean bl = addAxis = Integer.parseInt((String)axis.get("Number")) > 1;
                    if (dim == 2) {
                        if (!addAxis || this.getDimensionOrder().indexOf("C") != -1) continue;
                        this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                        continue;
                    }
                    if (dim == 3) {
                        if (!addAxis || this.getDimensionOrder().indexOf("Z") != -1) continue;
                        this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                        continue;
                    }
                    if (dim != 4 || !addAxis || this.getDimensionOrder().indexOf("T") != -1) continue;
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
                }
                this.core[0].bitsPerPixel = this.validBits;
                IniTable acquisition = pty.getTable("Acquisition Parameters Common");
                if (acquisition != null) {
                    this.magnification = (String)acquisition.get("Magnification");
                    this.lensNA = (String)acquisition.get("ObjectiveLens NAValue");
                    this.objectiveName = (String)acquisition.get("ObjectiveLens Name");
                    this.workingDistance = (String)acquisition.get("ObjectiveLens WDValue");
                    this.pinholeSize = (String)acquisition.get("PinholeDiameter");
                    String validBitCounts = (String)acquisition.get("ValidBitCounts");
                    if (validBitCounts != null) {
                        this.core[0].bitsPerPixel = Integer.parseInt(validBitCounts);
                    }
                }
                if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                    for (IniTable table : pty) {
                        String[] keys;
                        for (String key3 : keys = table.keySet().toArray(new String[table.size()])) {
                            values.put("Image " + ii + " : " + key3, table.get(key3));
                            if (baseKeys.contains(key3)) continue;
                            baseKeys.add(key3);
                        }
                    }
                }
            }
            ++i;
        }
        Iterator i$ = baseKeys.iterator();
        while (i$.hasNext() && !(key = (String)i$.next()).equals("DataName") && key.indexOf("FileName") < 0) {
            int i2;
            boolean equal = true;
            String first = (String)values.get("Image 0 : " + key);
            for (i2 = 1; i2 < this.getImageCount(); ++i2) {
                if (first.equals(values.get("Image " + i2 + " : " + key))) continue;
                equal = false;
                break;
            }
            if (equal) {
                this.addGlobalMeta(key, first);
                continue;
            }
            for (i2 = 0; i2 < this.getImageCount(); ++i2) {
                String k = "Image " + i2 + " : " + key;
                this.addGlobalMeta(k, values.get(k));
            }
        }
        if (this.tiffs.size() != this.getImageCount()) {
            this.core[0].imageCount = this.tiffs.size();
        }
        this.usedFiles = new Vector();
        if (tiffPath != null) {
            this.usedFiles.add(this.isOIB ? id : oifName);
            if (!this.isOIB) {
                Location dir = new Location(tiffPath);
                if (!dir.exists()) {
                    throw new FormatException("Required directory " + tiffPath + " was not found.");
                }
                String[] list = mappedOIF ? Location.getIdMap().keySet().toArray(new String[0]) : dir.list(true);
                for (int i3 = 0; i3 < list.length; ++i3) {
                    if (mappedOIF) {
                        this.usedFiles.add(list[i3]);
                        continue;
                    }
                    String p = new Location(tiffPath, list[i3]).getAbsolutePath();
                    String check = p.toLowerCase();
                    if (!check.endsWith(".tif") && !check.endsWith(".pty") && !check.endsWith(".roi") && !check.endsWith(".lut") && !check.endsWith(".bmp")) continue;
                    this.usedFiles.add(p);
                }
            }
        }
        LOGGER.info("Populating metadata");
        int realChannels = 0;
        for (int i4 = 0; i4 < 9; ++i4) {
            int ss = Integer.parseInt(this.size[i4]);
            if (this.pixelSize[i4] == null) {
                this.pixelSize[i4] = 1.0;
            }
            if (this.code[i4].equals("X")) {
                this.core[0].sizeX = ss;
                continue;
            }
            if (this.code[i4].equals("Y") && ss > 1) {
                this.core[0].sizeY = ss;
                continue;
            }
            if (this.code[i4].equals("Z")) {
                if (this.getSizeY() == 0) {
                    this.core[0].sizeY = ss;
                    continue;
                }
                this.core[0].sizeZ = ss;
                this.pixelSizeZ = Math.abs(this.pixelSize[i4] / (double)(this.getSizeZ() - 1) / 1000.0);
                continue;
            }
            if (this.code[i4].equals("T")) {
                if (this.getSizeY() == 0) {
                    this.core[0].sizeY = ss;
                    continue;
                }
                this.core[0].sizeT = ss;
                this.pixelSizeT = Math.abs(this.pixelSize[i4] / (double)(this.getSizeT() - 1) / 1000.0);
                continue;
            }
            if (ss <= 0) continue;
            this.core[0].sizeC = this.getSizeC() == 0 ? ss : (this.core[0].sizeC *= ss);
            if (!this.code[i4].equals("C")) continue;
            realChannels = ss;
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.getImageCount() == this.getSizeC() && this.getSizeY() == 1) {
            this.core[0].imageCount *= this.getSizeZ() * this.getSizeT();
        } else if (this.getImageCount() == this.getSizeC()) {
            this.core[0].sizeZ = 1;
            this.core[0].sizeT = 1;
        }
        if (this.getSizeZ() * this.getSizeT() * this.getSizeC() != this.getImageCount()) {
            int diff = this.getSizeZ() * this.getSizeC() * this.getSizeT() - this.getImageCount();
            if (diff == this.previewNames.size() || diff < 0) {
                diff /= this.getSizeC();
                if (this.getSizeT() > 1 && this.getSizeZ() == 1) {
                    this.core[0].sizeT -= diff;
                } else if (this.getSizeZ() > 1 && this.getSizeT() == 1) {
                    this.core[0].sizeZ -= diff;
                }
            } else {
                this.core[0].imageCount += diff;
            }
        }
        if (this.getSizeC() > 1 && this.getSizeZ() == 1 && this.getSizeT() == 1 && this.getDimensionOrder().indexOf("C") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getDimensionOrder().indexOf("Z") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("C") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getDimensionOrder().indexOf("T") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(this.imageDepth, false, false);
        try {
            RandomAccessInputStream thumb = this.getFile(this.thumbId);
            byte[] b = new byte[(int)thumb.length()];
            thumb.read(b);
            thumb.close();
            Location.mapFile("thumbnail.bmp", new ByteArrayHandle(b));
            this.thumbReader.setId("thumbnail.bmp");
            for (int i5 = 0; i5 < this.getSeriesCount(); ++i5) {
                this.core[i5].thumbSizeX = this.thumbReader.getSizeX();
                this.core[i5].thumbSizeY = this.thumbReader.getSizeY();
            }
            Location.mapFile("thumbnail.bmp", null);
        }
        catch (IOException e) {
            LOGGER.debug("Could not read thumbnail", (Throwable)e);
        }
        catch (FormatException e) {
            LOGGER.debug("Could not read thumbnail", (Throwable)e);
        }
        this.lut = new short[this.getSizeC()][3][65536];
        byte[] buffer = new byte[262144];
        int count = Math.min(this.getSizeC(), this.lutNames.size());
        for (int c = 0; c < count; ++c) {
            Exception exc = null;
            try {
                RandomAccessInputStream stream = this.getFile(this.lutNames.get(c));
                stream.seek(stream.length() - 262144L);
                stream.read(buffer);
                stream.close();
                for (int q = 0; q < buffer.length; q += 4) {
                    this.lut[c][0][q / 4] = buffer[q + 2];
                    this.lut[c][1][q / 4] = buffer[q + 1];
                    this.lut[c][2][q / 4] = buffer[q];
                }
            }
            catch (IOException e) {
                exc = e;
            }
            catch (FormatException e) {
                exc = e;
            }
            if (exc == null) continue;
            LOGGER.debug("Could not read LUT", (Throwable)exc);
            this.lut = null;
            break;
        }
        for (int i6 = 0; i6 < this.getSeriesCount(); ++i6) {
            this.core[i6].rgb = false;
            this.core[i6].littleEndian = true;
            this.core[i6].interleaved = false;
            this.core[i6].metadataComplete = true;
            this.core[i6].indexed = this.lut != null;
            this.core[i6].falseColor = true;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.creationDate != null) {
            this.creationDate = this.creationDate.replaceAll("'", "");
            this.creationDate = DateTools.formatDate(this.creationDate, DATE_FORMAT);
        }
        for (int i7 = 0; i7 < this.getSeriesCount(); ++i7) {
            store.setImageName("Series " + (i7 + 1), i7);
            if (this.creationDate != null) {
                store.setImageAcquiredDate(this.creationDate, i7);
                continue;
            }
            MetadataTools.setDefaultCreationDate(store, id, i7);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.populateMetadataStore(store, path);
        }
    }

    private void populateMetadataStore(MetadataStore store, String path) throws FormatException, IOException {
        int mag;
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            Double sizeY;
            Double sizeX;
            store.setImageInstrumentRef(instrumentID, i);
            if (this.pixelSizeX != null && (sizeX = new Double(this.pixelSizeX)) > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(sizeX), i);
            }
            if (this.pixelSizeY != null && (sizeY = new Double(this.pixelSizeY)) > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(sizeY), i);
            }
            if (this.pixelSizeZ == Double.NEGATIVE_INFINITY || this.pixelSizeZ == Double.POSITIVE_INFINITY || this.getSizeZ() == 1) {
                this.pixelSizeZ = 1.0;
            }
            if (this.pixelSizeT == Double.NEGATIVE_INFINITY || this.pixelSizeT == Double.POSITIVE_INFINITY || this.getSizeT() == 1) {
                this.pixelSizeT = 1.0;
            }
            if (this.pixelSizeZ > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(Double.valueOf(this.pixelSizeZ)), i);
            }
            store.setPixelsTimeIncrement(this.pixelSizeT, i);
            for (int c = 0; c < this.core[i].sizeC; ++c) {
                if (c >= this.illuminations.size()) continue;
                store.setChannelIlluminationType(this.getIlluminationType(this.illuminations.get(c)), i, c);
            }
        }
        int channelIndex = 0;
        for (ChannelData channel : this.channels) {
            if (!channel.active) continue;
            if (channelIndex >= this.getEffectiveSizeC()) break;
            String detectorID = MetadataTools.createLSID("Detector", 0, channelIndex);
            store.setDetectorID(detectorID, 0, channelIndex);
            store.setDetectorSettingsID(detectorID, 0, channelIndex);
            store.setDetectorGain(channel.gain, 0, channelIndex);
            store.setDetectorVoltage(channel.voltage, 0, channelIndex);
            store.setDetectorType(this.getDetectorType("PMT"), 0, channelIndex);
            store.setChannelName(channel.name, 0, channelIndex);
            String lightSourceID = MetadataTools.createLSID("LightSource", 0, channelIndex);
            store.setChannelLightSourceSettingsID(lightSourceID, 0, channelIndex);
            if (channel.emWave > 0) {
                store.setChannelEmissionWavelength(new PositiveInteger(channel.emWave), 0, channelIndex);
            }
            if (channel.exWave > 0) {
                store.setChannelExcitationWavelength(new PositiveInteger(channel.exWave), 0, channelIndex);
                store.setChannelLightSourceSettingsWavelength(new PositiveInteger(channel.exWave), 0, channelIndex);
            }
            if (channel.barrierFilter != null) {
                String filterID = MetadataTools.createLSID("Filter", 0, channelIndex);
                store.setFilterID(filterID, 0, channelIndex);
                store.setFilterModel(channel.barrierFilter, 0, channelIndex);
                if (channel.barrierFilter.indexOf("-") != -1) {
                    String[] emValues = channel.barrierFilter.split("-");
                    for (int i = 0; i < emValues.length; ++i) {
                        emValues[i] = emValues[i].replaceAll("\\D", "");
                    }
                    try {
                        store.setTransmittanceRangeCutIn(PositiveInteger.valueOf((String)emValues[0]), 0, channelIndex);
                        store.setTransmittanceRangeCutOut(PositiveInteger.valueOf((String)emValues[1]), 0, channelIndex);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                store.setLightPathEmissionFilterRef(filterID, 0, channelIndex, 0);
            }
            int emIndex = channelIndex * 2;
            int exIndex = channelIndex * 2 + 1;
            String emFilter = MetadataTools.createLSID("Dichroic", 0, emIndex);
            String exFilter = MetadataTools.createLSID("Dichroic", 0, exIndex);
            store.setDichroicID(emFilter, 0, emIndex);
            store.setDichroicModel(channel.emissionFilter, 0, emIndex);
            store.setDichroicID(exFilter, 0, exIndex);
            store.setDichroicModel(channel.excitationFilter, 0, exIndex);
            store.setLightPathDichroicRef(exFilter, 0, channelIndex);
            store.setLaserID(lightSourceID, 0, channelIndex);
            store.setLaserLaserMedium(this.getLaserMedium(channel.dyeName), 0, channelIndex);
            if (channelIndex < this.wavelengths.size()) {
                store.setLaserWavelength(new PositiveInteger(this.wavelengths.get(channelIndex)), 0, channelIndex);
            }
            store.setLaserType(this.getLaserType("Other"), 0, channelIndex);
            ++channelIndex;
        }
        if (this.lensNA != null) {
            store.setObjectiveLensNA(new Double(this.lensNA), 0, 0);
        }
        store.setObjectiveModel(this.objectiveName, 0, 0);
        if (this.magnification != null && (mag = (int)Float.parseFloat(this.magnification)) > 0) {
            store.setObjectiveNominalMagnification(new PositiveInteger(Integer.valueOf(mag)), 0, 0);
        }
        if (this.workingDistance != null) {
            store.setObjectiveWorkingDistance(new Double(this.workingDistance), 0, 0);
        }
        store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
        store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        store.setImageObjectiveSettingsID(objectiveID, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.NO_OVERLAYS) {
            int nextROI = -1;
            for (int i = 0; i < this.roiFilenames.size() && i < this.getImageCount(); ++i) {
                String filename = this.roiFilenames.get(new Integer(i));
                filename = this.sanitizeFile(filename, path);
                nextROI = this.parseROIFile(filename, store, nextROI, i);
            }
        }
    }

    private int parseROIFile(String filename, MetadataStore store, int nextROI, int plane) throws FormatException, IOException {
        int[] coordinates = this.getZCTCoords(plane);
        IniList roiFile = null;
        try {
            roiFile = this.getIniFile(filename);
        }
        catch (FormatException e) {
            LOGGER.debug("Could not parse ROI file {}", (Object)filename, (Object)e);
            return nextROI;
        }
        catch (IOException e) {
            LOGGER.debug("Could not parse ROI file {}", (Object)filename, (Object)e);
            return nextROI;
        }
        boolean validROI = false;
        int shape = -1;
        int shapeType = -1;
        String[] xc = null;
        String[] yc = null;
        int divide = 0;
        int fontSize = 0;
        int lineWidth = 0;
        int angle = 0;
        String fontName = null;
        String name = null;
        for (IniTable table : roiFile) {
            int height;
            String tableName = (String)table.get("header");
            if (tableName.equals("ROIBase FileInformation")) {
                try {
                    String roiName = ((String)table.get("Name")).replaceAll("\"", "");
                    validROI = Integer.parseInt(roiName) > 1;
                }
                catch (NumberFormatException e) {
                    validROI = false;
                }
                if (validROI) continue;
                continue;
            }
            if (!tableName.equals("ROIBase Body")) continue;
            shapeType = Integer.parseInt((String)table.get("SHAPE"));
            divide = Integer.parseInt((String)table.get("DIVIDE"));
            String[] fontAttributes = ((String)table.get("FONT")).split(",");
            fontName = fontAttributes[0];
            fontSize = Integer.parseInt(fontAttributes[1]);
            lineWidth = Integer.parseInt((String)table.get("LINEWIDTH"));
            name = (String)table.get("NAME");
            angle = Integer.parseInt((String)table.get("ANGLE"));
            xc = ((String)table.get("X")).split(",");
            yc = ((String)table.get("Y")).split(",");
            int x = Integer.parseInt(xc[0]);
            int width = xc.length > 1 ? Integer.parseInt(xc[1]) - x : 0;
            int y = Integer.parseInt(yc[0]);
            int n = height = yc.length > 1 ? Integer.parseInt(yc[1]) - y : 0;
            if (width + x > this.getSizeX() || height + y > this.getSizeY()) continue;
            Integer zIndex = new Integer(coordinates[0]);
            Integer tIndex = new Integer(coordinates[2]);
            if (++shape == 0) {
                ++nextROI;
                if (shapeType == 2 || shapeType == 11 || shapeType == 5 || shapeType == 3 || shapeType == 6 || shapeType == 7 || shapeType == 8 || shapeType == 9 || shapeType == 4 || shapeType == 10) {
                    String roiID = MetadataTools.createLSID("ROI", nextROI);
                    store.setROIID(roiID, nextROI);
                    store.setImageROIRef(roiID, 0, nextROI);
                }
            }
            String shapeID = MetadataTools.createLSID("Shape", nextROI--, shape);
            if (shapeType == 2) {
                store.setPointID(shapeID, nextROI, shape);
                store.setPointTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                store.setPointTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                store.setPointFontSize(new NonNegativeInteger(Integer.valueOf(fontSize)), nextROI, shape);
                store.setPointStrokeWidth(new Double(lineWidth), nextROI, shape);
                store.setPointX(new Double(xc[0]), nextROI, shape);
                store.setPointY(new Double(yc[0]), nextROI, shape);
                continue;
            }
            if (shapeType == 11 || shapeType == 5) {
                if (shapeType == 5) {
                    divide = 1;
                }
                width /= divide;
                height /= divide;
                for (int row = 0; row < divide; ++row) {
                    for (int col = 0; col < divide; ++col) {
                        double realX = x + col * width;
                        double realY = y + row * height;
                        shapeID = MetadataTools.createLSID("Shape", nextROI, shape);
                        store.setRectangleID(shapeID, nextROI, shape);
                        store.setRectangleX(realX, nextROI, shape);
                        store.setRectangleY(realY, nextROI, shape);
                        store.setRectangleWidth(new Double(width), nextROI, shape);
                        store.setRectangleHeight(new Double(height), nextROI, shape);
                        store.setRectangleTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                        store.setRectangleTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                        store.setRectangleFontSize(new NonNegativeInteger(Integer.valueOf(fontSize)), nextROI, shape);
                        store.setRectangleStrokeWidth(new Double(lineWidth), nextROI, shape);
                        double centerX = realX + (double)(width / 2);
                        double centerY = realY + (double)(height / 2);
                        store.setRectangleTransform(String.format(ROTATION, angle, centerX, centerY), nextROI, shape);
                        if (row >= divide - 1 && col >= divide - 1) continue;
                        ++shape;
                    }
                }
                continue;
            }
            if (shapeType == 3) {
                store.setLineID(shapeID, nextROI, shape);
                store.setLineX1(new Double(x), nextROI, shape);
                store.setLineY1(new Double(y), nextROI, shape);
                store.setLineX2(new Double(x + width), nextROI, shape);
                store.setLineY2(new Double(y + height), nextROI, shape);
                store.setLineTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                store.setLineTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                store.setLineFontSize(new NonNegativeInteger(Integer.valueOf(fontSize)), nextROI, shape);
                store.setLineStrokeWidth(new Double(lineWidth), nextROI, shape);
                int centerX = x + width / 2;
                int centerY = y + height / 2;
                store.setLineTransform(String.format(ROTATION, angle, Float.valueOf(centerX), Float.valueOf(centerY)), nextROI, shape);
                continue;
            }
            if (shapeType == 6 || shapeType == 7) {
                double rx = width / 2;
                double ry = shapeType == 6 ? rx : (double)(height / 2);
                store.setEllipseID(shapeID, nextROI, shape);
                store.setEllipseX((double)x + rx, nextROI, shape);
                store.setEllipseY((double)y + ry, nextROI, shape);
                store.setEllipseRadiusX(rx, nextROI, shape);
                store.setEllipseRadiusY(ry, nextROI, shape);
                store.setEllipseTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                store.setEllipseTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                store.setEllipseFontSize(new NonNegativeInteger(Integer.valueOf(fontSize)), nextROI, shape);
                store.setEllipseStrokeWidth(new Double(lineWidth), nextROI, shape);
                store.setEllipseTransform(String.format(ROTATION, angle, (double)x + rx, (double)y + ry), nextROI, shape);
                continue;
            }
            if (shapeType == 8 || shapeType == 9 || shapeType == 4 || shapeType == 10) {
                StringBuffer points = new StringBuffer();
                for (int point = 0; point < xc.length; ++point) {
                    points.append(xc[point]);
                    points.append(",");
                    points.append(yc[point]);
                    if (point >= xc.length - 1) continue;
                    points.append(" ");
                }
                store.setPolylineID(shapeID, nextROI, shape);
                store.setPolylinePoints(points.toString(), nextROI, shape);
                store.setPolylineTransform("rotate(" + angle + ")", nextROI, shape);
                store.setPolylineClosed(shapeType == 8 || shapeType == 9, nextROI, shape);
                store.setPolylineTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                store.setPolylineTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                store.setPolylineFontSize(new NonNegativeInteger(Integer.valueOf(fontSize)), nextROI, shape);
                store.setPolylineStrokeWidth(new Double(lineWidth), nextROI, shape);
                continue;
            }
            if (shape == 0) {
                // empty if block
            }
            --shape;
        }
        return nextROI;
    }

    private void addPtyFiles() throws FormatException {
        if (this.ptyStart != null && this.ptyEnd != null && this.ptyPattern != null) {
            String[] prefixes = this.ptyPattern.split("%03d");
            int[] first = FV1000Reader.scanFormat(this.ptyPattern, this.ptyStart);
            int[] last = FV1000Reader.scanFormat(this.ptyPattern, this.ptyEnd);
            int[] lengths = new int[prefixes.length - 1];
            int totalFiles = 1;
            for (int i = 0; i < first.length; ++i) {
                lengths[i] = last[i] - first[i] + 1;
                totalFiles *= lengths[i];
            }
            for (int file = 0; file < totalFiles; ++file) {
                int[] pos = FormatTools.rasterToPosition(lengths, file);
                StringBuffer pty = new StringBuffer();
                for (int block = 0; block < prefixes.length; ++block) {
                    pty.append(prefixes[block]);
                    if (block >= pos.length) continue;
                    String num = String.valueOf(pos[block] + 1);
                    for (int q = 0; q < 3 - num.length(); ++q) {
                        pty.append("0");
                    }
                    pty.append(num);
                }
                this.filenames.put(new Integer(file), pty.toString());
            }
        }
    }

    private String findOIFFile(String baseFile) throws FormatException {
        Location current = new Location(baseFile).getAbsoluteFile();
        String parent = current.getParent();
        Location tmp = new Location(parent).getParentFile();
        parent = tmp.getAbsolutePath();
        baseFile = current.getName();
        if (baseFile == null || baseFile.indexOf("_") == -1) {
            return null;
        }
        baseFile = baseFile.substring(0, baseFile.lastIndexOf("_"));
        if (FV1000Reader.checkSuffix(current.getName(), new String[]{"roi", "lut"}) && !new Location(tmp, baseFile + ".oif").exists() && !new Location(tmp, baseFile + ".OIF").exists() && baseFile.indexOf("_") >= 0) {
            baseFile = baseFile.substring(0, baseFile.lastIndexOf("_"));
        }
        baseFile = baseFile + ".oif";
        tmp = new Location(tmp, baseFile);
        String oifFile = tmp.getAbsolutePath();
        if (!tmp.exists() && !(tmp = new Location(oifFile = oifFile.substring(0, oifFile.lastIndexOf(".")) + ".OIF")).exists()) {
            baseFile = current.getParent();
            baseFile = baseFile.substring(0, baseFile.lastIndexOf("."));
            baseFile = baseFile.substring(0, baseFile.lastIndexOf("."));
            tmp = new Location(baseFile + ".oif");
            oifFile = tmp.getAbsolutePath();
            if (!tmp.exists()) {
                tmp = new Location(tmp.getParent(), tmp.getName().toUpperCase());
                oifFile = tmp.getAbsolutePath();
                if (!tmp.exists()) {
                    if (parent.endsWith(File.separator)) {
                        parent = parent.substring(0, parent.length() - 1);
                    }
                    String dir = parent.substring(parent.lastIndexOf(File.separator));
                    tmp = new Location(parent);
                    oifFile = new Location(tmp, dir = dir.substring(0, dir.lastIndexOf("."))).getAbsolutePath();
                    if (!new Location(oifFile).exists()) {
                        throw new FormatException("OIF file not found");
                    }
                }
            }
        }
        return oifFile;
    }

    private String mapOIBFiles() throws FormatException, IOException {
        String oifName = null;
        String infoFile = null;
        Vector<String> list = this.poi.getDocumentList();
        for (String name : list) {
            if (!name.endsWith("OibInfo.txt")) continue;
            infoFile = name;
            break;
        }
        if (infoFile == null) {
            throw new FormatException("OibInfo.txt not found in " + this.currentId);
        }
        RandomAccessInputStream ras = this.poi.getDocumentStream(infoFile);
        this.oibMapping = new Hashtable();
        String s = DataTools.stripString(ras.readString((int)ras.length()));
        ras.close();
        Object[] lines = s.split("\n");
        Arrays.sort(lines);
        String directoryKey = null;
        String directoryValue = null;
        String key = null;
        String value = null;
        for (Object line : lines) {
            if (((String)(line = ((String)line).trim())).indexOf("=") == -1) continue;
            key = ((String)line).substring(0, ((String)line).indexOf("="));
            value = ((String)line).substring(((String)line).indexOf("=") + 1);
            if (directoryKey != null && directoryValue != null) {
                value = value.replaceAll(directoryKey, directoryValue);
            }
            value = this.removeGST(value);
            if (key.startsWith("Stream")) {
                if (FV1000Reader.checkSuffix(value = this.sanitizeFile(value, ""), OIF_SUFFIX)) {
                    oifName = value;
                }
                if (directoryKey != null && value.startsWith(directoryValue)) {
                    this.oibMapping.put(value, "Root Entry" + File.separator + directoryKey + File.separator + key);
                    continue;
                }
                this.oibMapping.put(value, "Root Entry" + File.separator + key);
                continue;
            }
            if (!key.startsWith("Storage")) continue;
            directoryKey = key;
            directoryValue = value;
        }
        s = null;
        return oifName;
    }

    private String sanitizeValue(String value) {
        String f = value.replaceAll("\"", "");
        f = f.replace('\\', File.separatorChar);
        f = f.replace('/', File.separatorChar);
        while (f.indexOf("GST") != -1) {
            f = this.removeGST(f);
        }
        return f;
    }

    private String sanitizeFile(String file, String path) {
        String f = this.sanitizeValue(file);
        if (path.equals("")) {
            return f;
        }
        return path + File.separator + f;
    }

    private String removeGST(String s) {
        if (s.indexOf("GST") != -1) {
            String first = s.substring(0, s.indexOf("GST"));
            int ndx = s.indexOf(File.separator) < s.indexOf("GST") ? s.length() : s.indexOf(File.separator);
            String last = s.substring(s.lastIndexOf("=", ndx) + 1);
            return first + last;
        }
        return s;
    }

    private RandomAccessInputStream getFile(String name) throws FormatException, IOException {
        if (this.isOIB) {
            name = name.replace('\\', File.separatorChar);
            String realName = this.oibMapping.get(name = name.replace('/', File.separatorChar));
            if (realName == null) {
                throw new FormatException("File " + name + " not found.");
            }
            return this.poi.getDocumentStream(realName);
        }
        return new RandomAccessInputStream(name);
    }

    private RandomAccessInputStream getPlane(int seriesIndex, int planeIndex) {
        int file = planeIndex;
        file = seriesIndex == 0 ? planeIndex / (this.getImageCount() / this.tiffs.size()) : planeIndex / (this.getImageCount() / this.previewNames.size());
        String filename = seriesIndex == 0 ? this.tiffs.get(file) : this.previewNames.get(file);
        RandomAccessInputStream plane = null;
        try {
            plane = this.getFile(filename);
        }
        catch (FormatException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return plane;
    }

    private boolean isPreviewName(String name) {
        int index = name.indexOf("-R");
        return index == name.length() - 9;
    }

    private String replaceExtension(String name, String oldExt, String newExt) {
        if (!name.endsWith("." + oldExt)) {
            return name;
        }
        return name.substring(0, name.length() - oldExt.length()) + newExt;
    }

    private static int[] scanFormat(String pattern, String string) throws FormatException {
        Vector<Integer> percentOffsets = new Vector<Integer>();
        int offset = -1;
        while ((offset = pattern.indexOf(37, offset + 1)) >= 0 && offset + 1 < pattern.length()) {
            if (pattern.charAt(offset + 1) == '%') continue;
            percentOffsets.add(new Integer(offset));
        }
        int[] result = new int[percentOffsets.size()];
        int patternOffset = 0;
        offset = 0;
        for (int i = 0; i < result.length; ++i) {
            int endOffset;
            int percent = (Integer)percentOffsets.get(i);
            if (!string.regionMatches(offset, pattern, patternOffset, percent - patternOffset)) {
                throw new FormatException("String '" + string + "' does not match format '" + pattern + "'");
            }
            offset += percent - patternOffset;
            patternOffset = percent;
            for (endOffset = offset; endOffset < string.length() && Character.isDigit(string.charAt(endOffset)); ++endOffset) {
            }
            result[i] = Integer.parseInt(string.substring(offset, endOffset));
            offset = endOffset;
            while (++patternOffset < pattern.length() && pattern.charAt(patternOffset - 1) != 'd') {
            }
        }
        int remaining = pattern.length() - patternOffset;
        if (string.length() - offset != remaining || !string.regionMatches(offset, pattern, patternOffset, remaining)) {
            throw new FormatException("String '" + string + "' does not match format '" + pattern + "'");
        }
        return result;
    }

    private IniList getIniFile(String filename) throws FormatException, IOException {
        RandomAccessInputStream stream = this.getFile(filename);
        String data = stream.readString((int)stream.length());
        if (!data.startsWith("[")) {
            data = data.substring(data.indexOf("["), data.length());
        }
        data = DataTools.stripString(data);
        BufferedReader reader = new BufferedReader(new StringReader(data));
        stream.close();
        IniList list = this.parser.parseINI(reader);
        for (IniTable table : list) {
            String[] keys;
            LOGGER.debug("");
            LOGGER.debug("[" + (String)table.get("header") + "]");
            for (String key : keys = table.keySet().toArray(new String[table.size()])) {
                String value = this.sanitizeValue((String)table.get(key));
                LOGGER.debug(key + " = " + value);
                table.put(key, value);
            }
        }
        reader.close();
        return list;
    }

    class ChannelData {
        public boolean active;
        public Double gain;
        public Double voltage;
        public String name;
        public String emissionFilter;
        public String excitationFilter;
        public Integer emWave;
        public Integer exWave;
        public String dyeName;
        public String barrierFilter;

        ChannelData() {
        }
    }
}

