/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class BioRadReader
extends FormatReader {
    private static final int PIC_FILE_ID = 12345;
    private static final boolean LITTLE_ENDIAN = true;
    private static final String[] MERGE_NAMES = new String[]{"MERGE_OFF", "MERGE_16", "MERGE_ALTERNATE", "MERGE_COLUMN", "MERGE_ROW", "MERGE_MAXIMUM", "MERGE_OPT12", "MERGE_OPT12_V2"};
    public static final String[] NOTE_NAMES = new String[]{"0", "LIVE", "FILE1", "NUMBER", "USER", "LINE", "COLLECT", "FILE2", "SCALEBAR", "MERGE", "THRUVIEW", "ARROW", "12", "13", "14", "15", "16", "17", "18", "19", "VARIABLE", "STRUCTURE", "4D SERIES"};
    public static final int NOTE_TYPE_LIVE = 1;
    public static final int NOTE_TYPE_FILE1 = 2;
    public static final int NOTE_TYPE_NUMBER = 3;
    public static final int NOTE_TYPE_USER = 4;
    public static final int NOTE_TYPE_LINE = 5;
    public static final int NOTE_TYPE_COLLECT = 6;
    public static final int NOTE_TYPE_FILE2 = 7;
    public static final int NOTE_TYPE_SCALEBAR = 8;
    public static final int NOTE_TYPE_MERGE = 9;
    public static final int NOTE_TYPE_THRUVIEW = 10;
    public static final int NOTE_TYPE_ARROW = 11;
    public static final int NOTE_TYPE_VARIABLE = 20;
    public static final int NOTE_TYPE_STRUCTURE = 21;
    public static final int NOTE_TYPE_4D_SERIES = 22;
    public static final String[] STRUCTURE_LABELS_1 = new String[]{"Scan Channel", "Both mode", "Speed", "Filter", "Factor", "Number of scans", "Photon counting mode (channel 1)", "Photon counting detector (channel 1)", "Photon counting mode (channel 2)", "Photon counting detector (channel 2)", "Photon mode", "Objective magnification", "Zoom factor", "Motor on", "Z Step Size"};
    public static final String[] STRUCTURE_LABELS_2 = new String[]{"Z Start", "Z Stop", "Scan area X coordinate", "Scan area Y coordinate", "Scan area width", "Scan area height"};
    public static final String[] STRUCTURE_LABELS_3 = new String[]{"Iris for PMT", "Gain for PMT", "Black level for PMT", "Emission filter for PMT", "Multiplier for channel"};
    public static final String[] STRUCTURE_LABELS_4 = new String[]{"enhanced", "PMT 1 percentage", "PMT 2 percentage", "Transmission 1 percentage", "Transmission 2 percentage", "Transmission 3 percentage"};
    public static final String[] STRUCTURE_LABELS_5 = new String[]{"laser ", "excitation filter for laser ", "ND filter for laser ", "emission filter for laser "};
    public static final String[] STRUCTURE_LABELS_6 = new String[]{"Part number for laser 3", "Part number for excitation filter for laser 3", "Part number for ND filter for laser 3", "Part number for emission filter for laser 3", "Part number for filter block 1", "Part number for filter block 2"};
    public static final String[] PIC_SUFFIX = new String[]{"pic"};
    public static final int LUT_LENGTH = 256;
    private Vector<String> used;
    private String[] picFiles;
    private byte[][][] lut;
    private int lastChannel;
    private boolean brokenNotes = false;
    private Vector<Note> noteStrings;
    private Vector<Double> offset;
    private Vector<Double> gain;

    public BioRadReader() {
        super("Bio-Rad PIC", new String[]{"pic", "xml", "raw"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        if (BioRadReader.checkSuffix(name, PIC_SUFFIX)) {
            return true;
        }
        String fname = new File(name.toLowerCase()).getName();
        return fname.equals("lse.xml") || fname.equals("data.raw");
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 56;
        if (!FormatTools.validStream(stream, 56, true)) {
            return false;
        }
        String c = stream.readString(56);
        stream.seek(54L);
        return stream.readShort() == 12345 || c.startsWith("[Input Sources]");
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        String[] list;
        Location thisFile = new Location(id).getAbsoluteFile();
        Location parent = thisFile.getParentFile();
        for (String f : list = parent.list(true)) {
            if (!BioRadReader.checkSuffix(f, "raw") && !BioRadReader.checkSuffix(f, "xml")) continue;
            return 0;
        }
        return 1;
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut == null ? (byte[][])null : this.lut[this.lastChannel];
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            Vector<String> files = new Vector<String>();
            for (String f : this.used) {
                if (BioRadReader.checkSuffix(f, PIC_SUFFIX)) continue;
                files.add(f);
            }
            return files.toArray(new String[files.size()]);
        }
        return this.used.toArray(new String[this.used.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.lastChannel = this.getZCTCoords(no)[1];
        if (this.picFiles != null) {
            int file = no % this.picFiles.length;
            RandomAccessInputStream ras = new RandomAccessInputStream(this.picFiles[file]);
            long offset = no / this.picFiles.length * FormatTools.getPlaneSize(this);
            ras.seek(offset + 76L);
            this.readPlane(ras, x, y, w, h, buf);
            ras.close();
        } else {
            this.in.seek(no * FormatTools.getPlaneSize(this) + 76);
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.used = null;
            this.picFiles = null;
            this.lut = null;
            this.lastChannel = 0;
            this.noteStrings = null;
            this.gain = null;
            this.offset = null;
            this.brokenNotes = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        if (!BioRadReader.checkSuffix(id, PIC_SUFFIX)) {
            Location dir = new Location(id).getAbsoluteFile().getParentFile();
            String[] list = dir.list(true);
            for (int i2 = 0; i2 < list.length; ++i2) {
                if (!BioRadReader.checkSuffix(list[i2], PIC_SUFFIX)) continue;
                id = new Location(dir.getAbsolutePath(), list[i2]).getAbsolutePath();
            }
            if (!BioRadReader.checkSuffix(id, PIC_SUFFIX)) {
                throw new FormatException("No .pic files found - invalid dataset.");
            }
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        this.offset = new Vector();
        this.gain = new Vector();
        this.used = new Vector();
        this.used.add(this.currentId);
        LOGGER.info("Reading image dimensions");
        this.noteStrings = new Vector();
        this.core[0].sizeX = this.in.readShort();
        this.core[0].sizeY = this.in.readShort();
        short npic = this.in.readShort();
        this.core[0].imageCount = npic;
        short ramp1min = this.in.readShort();
        short ramp1max = this.in.readShort();
        boolean notes = this.in.readInt() != 0;
        this.core[0].pixelType = this.in.readShort() == 0 ? 3 : 1;
        short imageNumber = this.in.readShort();
        String name = this.in.readString(32);
        for (int i3 = 0; i3 < name.length(); ++i3) {
            if (name.charAt(i3) != '\u0000') continue;
            name = name.substring(0, i3);
            break;
        }
        float magFactor = 1.0f;
        short lens = 0;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            short merged = this.in.readShort();
            short color1 = this.in.readShort();
            short fileId = this.in.readShort();
            short ramp2min = this.in.readShort();
            short ramp2max = this.in.readShort();
            short color2 = this.in.readShort();
            short edited = this.in.readShort();
            lens = this.in.readShort();
            magFactor = this.in.readFloat();
            if (fileId != 12345) {
                throw new FormatException("Invalid file header : " + fileId);
            }
            this.addGlobalMeta("nx", this.getSizeX());
            this.addGlobalMeta("ny", this.getSizeY());
            this.addGlobalMeta("npic", this.getImageCount());
            this.addGlobalMeta("ramp1_min", (int)ramp1min);
            this.addGlobalMeta("ramp1_max", (int)ramp1max);
            this.addGlobalMeta("notes", notes);
            this.addGlobalMeta("image_number", (int)imageNumber);
            this.addGlobalMeta("name", name);
            this.addGlobalMeta("merged", MERGE_NAMES[merged]);
            this.addGlobalMeta("color1", (int)color1);
            this.addGlobalMeta("file_id", (int)fileId);
            this.addGlobalMeta("ramp2_min", (int)ramp2min);
            this.addGlobalMeta("ramp2_max", (int)ramp2max);
            this.addGlobalMeta("color2", (int)color2);
            this.addGlobalMeta("edited", (int)edited);
            this.addGlobalMeta("lens", (int)lens);
            this.addGlobalMeta("mag_factor", magFactor);
        } else {
            this.in.skipBytes(20);
        }
        int imageLen = this.getSizeX() * this.getSizeY();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        this.in.skipBytes(bpp * this.getImageCount() * imageLen + 6);
        this.core[0].sizeZ = this.getImageCount();
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].orderCertain = false;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = true;
        this.core[0].metadataComplete = true;
        this.core[0].falseColor = true;
        LOGGER.info("Reading notes");
        Object zoom = null;
        Object zstart = null;
        Object zstop = null;
        Object mag = null;
        Object gain1 = null;
        Object gain2 = null;
        Object gain3 = null;
        Object offset1 = null;
        Object ex1 = null;
        Object ex2 = null;
        Object ex3 = null;
        Object em1 = null;
        Object em2 = null;
        Object em3 = null;
        MetadataStore store = this.makeFilterMetadata();
        this.readNotes(this.in, true);
        LOGGER.info("Populating metadata");
        Vector<String> pics = new Vector<String>();
        if (this.isGroupFiles()) {
            Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
            String parentPath = parent.getAbsolutePath();
            Object[] list = parent.list(true);
            Arrays.sort(list);
            for (i = 0; i < list.length; ++i) {
                if (((String)list[i]).endsWith("lse.xml")) {
                    String path = new Location(parentPath, (String)list[i]).getAbsolutePath();
                    this.used.add(path);
                    BioRadHandler handler = new BioRadHandler();
                    RandomAccessInputStream xml = new RandomAccessInputStream(path);
                    XMLTools.parseXML(xml, (DefaultHandler)handler);
                    xml.close();
                    this.used.remove(this.currentId);
                    for (int q = 0; q < list.length; ++q) {
                        if (!BioRadReader.checkSuffix((String)list[q], PIC_SUFFIX)) continue;
                        path = new Location(parentPath, (String)list[q]).getAbsolutePath();
                        pics.add(path);
                        if (this.used.contains(path)) continue;
                        this.used.add(path);
                    }
                    continue;
                }
                if (!((String)list[i]).endsWith("data.raw")) continue;
                this.used.add(new Location(parentPath, (String)list[i]).getAbsolutePath());
            }
        }
        this.core[0].dimensionOrder = "XYCTZ";
        boolean multipleFiles = this.parseNotes(store);
        if (multipleFiles && this.isGroupFiles() && pics.size() == 0) {
            String[] patternFiles;
            this.used.remove(this.currentId);
            long length = new Location(this.currentId).length();
            FilePattern pattern = new FilePattern(new Location(id).getAbsoluteFile());
            for (String file : patternFiles = pattern.getFiles()) {
                Location f = new Location(file);
                if (f.length() != length) continue;
                pics.add(file);
                this.used.add(file);
            }
            if (pics.size() == 1) {
                this.core[0].sizeC = 1;
            }
        }
        this.picFiles = pics.toArray(new String[pics.size()]);
        Arrays.sort(this.picFiles);
        if (this.picFiles.length > 0) {
            if (this.getSizeC() == 0) {
                this.core[0].sizeC = 1;
            }
            this.core[0].imageCount = npic * this.picFiles.length;
            if (multipleFiles) {
                this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
            } else {
                this.core[0].sizeC = this.getImageCount() / (this.getSizeZ() * this.getSizeT());
            }
        } else {
            this.picFiles = null;
        }
        if (this.getEffectiveSizeC() != this.getSizeC() && !this.isRGB()) {
            this.core[0].sizeC = 1;
        }
        LOGGER.info("Reading lookup tables");
        this.lut = new byte[this.getEffectiveSizeC()][][];
        for (int channel = 0; channel < this.lut.length; ++channel) {
            int plane = this.getIndex(0, channel, 0);
            String file = this.picFiles == null ? this.currentId : this.picFiles[plane % this.picFiles.length];
            LOGGER.trace("reading table for C = {} from {}", (Object)channel, (Object)file);
            RandomAccessInputStream s = new RandomAccessInputStream(file);
            s.order(true);
            this.readLookupTables(s);
            s.close();
            if (this.lut == null) break;
        }
        this.core[0].indexed = this.lut != null;
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
        store.setImageName(name, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setImageObjectiveSettingsID(objectiveID, 0);
            store.setObjectiveLensNA(new Double(lens), 0, 0);
            if ((int)magFactor > 0) {
                store.setObjectiveNominalMagnification(new PositiveInteger(Integer.valueOf((int)magFactor)), 0, 0);
            }
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
            for (i = 0; i < this.getEffectiveSizeC(); ++i) {
                Double detectorGain;
                Double detectorOffset = i < this.offset.size() ? this.offset.get(i) : null;
                Double d = detectorGain = i < this.gain.size() ? this.gain.get(i) : null;
                if (detectorOffset != null || detectorGain != null) {
                    String detectorID = MetadataTools.createLSID("Detector", 0, i);
                    store.setDetectorSettingsID(detectorID, 0, i);
                    store.setDetectorID(detectorID, 0, i);
                    store.setDetectorType(this.getDetectorType("Other"), 0, i);
                }
                if (detectorOffset != null) {
                    store.setDetectorSettingsOffset(detectorOffset, 0, i);
                }
                if (detectorGain == null) continue;
                store.setDetectorSettingsGain(detectorGain, 0, i);
            }
        }
    }

    private void readNotes(RandomAccessInputStream s, boolean add) throws IOException {
        s.seek(70L);
        int imageLen = this.getSizeX() * this.getSizeY();
        imageLen = this.picFiles == null ? (imageLen *= this.getImageCount()) : (imageLen *= this.getImageCount() / this.picFiles.length);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        s.skipBytes(bpp * imageLen + 6);
        boolean notes = true;
        while (notes) {
            if (s.getFilePointer() >= s.length()) {
                this.brokenNotes = true;
                break;
            }
            Note n = new Note();
            n.level = s.readShort();
            notes = s.readInt() != 0;
            n.num = s.readShort();
            n.status = s.readShort();
            n.type = s.readShort();
            n.x = s.readShort();
            n.y = s.readShort();
            n.p = s.readString(80);
            if (n.type < 0 || n.type >= NOTE_NAMES.length) {
                notes = false;
                this.brokenNotes = true;
                break;
            }
            if (!add) continue;
            int ndx = n.p.length();
            for (int i = 0; i < n.p.length(); ++i) {
                if (n.p.charAt(i) != '\u0000') continue;
                ndx = i;
                break;
            }
            n.p = n.p.substring(0, ndx).trim();
            String value = n.p.replaceAll("=", "");
            Vector<String> v = new Vector<String>();
            StringTokenizer t = new StringTokenizer(value, " ");
            while (t.hasMoreTokens()) {
                String token = t.nextToken().trim();
                if (token.length() <= 0) continue;
                v.add(token);
            }
            String[] tokens = v.toArray(new String[v.size()]);
            try {
                int noteType;
                if (tokens.length > 1 && (noteType = Integer.parseInt(tokens[1])) == 2 && value.indexOf("AXIS_4") != -1) {
                    this.core[0].sizeZ = 1;
                    this.core[0].sizeT = this.getImageCount();
                    this.core[0].orderCertain = true;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.noteStrings.add(n);
        }
    }

    private boolean parseNotes(MetadataStore store) throws FormatException {
        boolean multipleFiles = false;
        int nextDetector = 0;
        int nLasers = 0;
        block41: for (int noteIndex = 0; noteIndex < this.noteStrings.size(); ++noteIndex) {
            Note n;
            block86: {
                n = this.noteStrings.get(noteIndex);
                if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) break block86;
                block1 : switch (n.type) {
                    case 4: {
                        this.addGlobalMeta("Note #" + noteIndex, n.toString());
                        break;
                    }
                    case 8: {
                        this.addGlobalMeta("Note #" + noteIndex, n.toString());
                        break;
                    }
                    case 11: {
                        this.addGlobalMeta("Note #" + noteIndex, n.toString());
                        break;
                    }
                    case 20: {
                        if (n.p.indexOf("=") >= 0) {
                            String key = n.p.substring(0, n.p.indexOf("=")).trim();
                            String value = n.p.substring(n.p.indexOf("=") + 1).trim();
                            this.addGlobalMeta(key, value);
                            if (key.equals("INFO_OBJECTIVE_NAME")) {
                                store.setObjectiveModel(value, 0, 0);
                                break;
                            }
                            if (key.equals("INFO_OBJECTIVE_MAGNIFICATION")) {
                                store.setObjectiveNominalMagnification(new PositiveInteger(Integer.valueOf((int)Float.parseFloat(value))), 0, 0);
                                break;
                            }
                            if (key.equals("LENS_MAGNIFICATION")) {
                                int magnification = (int)Float.parseFloat(value);
                                if (magnification <= 0) break;
                                store.setObjectiveNominalMagnification(new PositiveInteger(Integer.valueOf(magnification)), 0, 0);
                                break;
                            }
                            if (key.startsWith("SETTING")) {
                                if (key.indexOf("_DET_") == -1) break;
                                int index = key.indexOf("_DET_") + 5;
                                if (key.lastIndexOf("_") <= index) break;
                                String detectorID = MetadataTools.createLSID("Detector", 0, nextDetector);
                                store.setDetectorID(detectorID, 0, nextDetector);
                                store.setDetectorType(this.getDetectorType("Other"), 0, nextDetector);
                                if (key.endsWith("OFFSET")) {
                                    if (nextDetector < this.offset.size()) {
                                        this.offset.setElementAt(new Double(value), nextDetector);
                                    } else {
                                        while (nextDetector > this.offset.size()) {
                                            this.offset.add(null);
                                        }
                                        this.offset.add(new Double(value));
                                    }
                                } else if (key.endsWith("GAIN")) {
                                    if (nextDetector < this.gain.size()) {
                                        this.gain.setElementAt(new Double(value), nextDetector);
                                    } else {
                                        while (nextDetector > this.gain.size()) {
                                            this.gain.add(null);
                                        }
                                        this.gain.add(new Double(value));
                                    }
                                }
                                ++nextDetector;
                                break;
                            }
                            String[] values = value.split(" ");
                            if (values.length <= 1) break;
                            try {
                                int type = Integer.parseInt(values[0]);
                                if (type != 257 || values.length < 3) break;
                                Double pixelSize = new Double(values[2]);
                                if (key.equals("AXIS_2")) {
                                    store.setPixelsPhysicalSizeX(new PositiveFloat(pixelSize), 0);
                                    break;
                                }
                                if (!key.equals("AXIS_3")) break;
                                store.setPixelsPhysicalSizeY(new PositiveFloat(pixelSize), 0);
                            }
                            catch (NumberFormatException e) {}
                            break;
                        }
                        if (n.p.startsWith("AXIS_2")) {
                            String[] values = n.p.split(" ");
                            Double pixelSize = new Double(values[3]);
                            store.setPixelsPhysicalSizeX(new PositiveFloat(pixelSize), 0);
                            break;
                        }
                        if (n.p.startsWith("AXIS_3")) {
                            String[] values = n.p.split(" ");
                            Double pixelSize = new Double(values[3]);
                            store.setPixelsPhysicalSizeY(new PositiveFloat(pixelSize), 0);
                            break;
                        }
                        this.addGlobalMeta("Note #" + noteIndex, n.toString());
                        break;
                    }
                    case 21: {
                        int structureType = (n.x & 0xFF00) >> 8;
                        int version = n.x & 0xFF;
                        String[] values = n.p.split(" ");
                        if (structureType != 1) break;
                        switch (n.y) {
                            case 1: {
                                for (int i = 0; i < STRUCTURE_LABELS_1.length; ++i) {
                                    this.addGlobalMeta(STRUCTURE_LABELS_1[i], values[i]);
                                }
                                int mag = (int)Float.parseFloat(values[11]);
                                store.setObjectiveNominalMagnification(new PositiveInteger(Integer.valueOf(mag)), 0, 0);
                                Double sizeZ = new Double(values[14]);
                                if (sizeZ > 0.0) {
                                    store.setPixelsPhysicalSizeZ(new PositiveFloat(sizeZ), 0);
                                    break;
                                }
                                break block86;
                            }
                            case 2: {
                                for (int i = 0; i < STRUCTURE_LABELS_2.length; ++i) {
                                    this.addGlobalMeta(STRUCTURE_LABELS_2[i], values[i]);
                                }
                                double x1 = Double.parseDouble(values[2]);
                                double x2 = Double.parseDouble(values[4]);
                                double width = x2 - x1;
                                width /= (double)this.getSizeX();
                                double y1 = Double.parseDouble(values[3]);
                                double y2 = Double.parseDouble(values[5]);
                                double height = y2 - y1;
                                height /= (double)this.getSizeY();
                                if (width > 0.0) {
                                    store.setPixelsPhysicalSizeX(new PositiveFloat(Double.valueOf(width)), 0);
                                }
                                if (height > 0.0) {
                                    store.setPixelsPhysicalSizeY(new PositiveFloat(Double.valueOf(height)), 0);
                                    break;
                                }
                                break block86;
                            }
                            case 3: {
                                for (int i = 0; i < 3; ++i) {
                                    for (int j = 0; j < STRUCTURE_LABELS_3.length; ++j) {
                                        String v = j == STRUCTURE_LABELS_3.length - 1 ? values[12 + i] : values[i * 4 + j];
                                        this.addGlobalMeta(STRUCTURE_LABELS_3[j] + " " + (i + 1), v);
                                    }
                                }
                                break block1;
                            }
                            case 4: {
                                int i;
                                nLasers = Integer.parseInt(values[0]);
                                this.addGlobalMeta("Number of lasers", values[0]);
                                this.addGlobalMeta("Number of transmission detectors", values[1]);
                                this.addGlobalMeta("Number of PMTs", values[2]);
                                for (i = 1; i <= 3; ++i) {
                                    int idx = (i + 1) * 3;
                                    this.addGlobalMeta("Shutter present for laser " + i, values[i + 2]);
                                    this.addGlobalMeta("Neutral density filter for laser " + i, values[idx]);
                                    this.addGlobalMeta("Excitation filter for laser " + i, values[idx + 1]);
                                    this.addGlobalMeta("Use laser " + i, values[idx + 2]);
                                }
                                for (i = 0; i < nLasers; ++i) {
                                    this.addGlobalMeta("Neutral density filter name - laser " + (i + 1), values[15 + i]);
                                }
                                break block1;
                            }
                            case 5: {
                                int i;
                                String prefix = "Excitation filter name - laser ";
                                for (i = 0; i < nLasers; ++i) {
                                    this.addGlobalMeta(prefix + (i + 1), values[i]);
                                }
                                break block1;
                            }
                            case 6: {
                                int i;
                                String prefix = "Emission filter name - laser ";
                                for (i = 0; i < nLasers; ++i) {
                                    this.addGlobalMeta(prefix + (i + 1), values[i]);
                                }
                                break block1;
                            }
                            case 7: {
                                int i;
                                for (i = 0; i < 2; ++i) {
                                    String prefix = "Mixer " + i + " - ";
                                    for (int j = 0; j < STRUCTURE_LABELS_4.length; ++j) {
                                        this.addGlobalMeta(prefix + STRUCTURE_LABELS_4[j], values[i * 7 + j]);
                                    }
                                }
                                this.addGlobalMeta("Mixer 0 - low signal on", values[14]);
                                this.addGlobalMeta("Mixer 1 - low signal on", values[15]);
                                break;
                            }
                            case 8: 
                            case 9: 
                            case 10: {
                                this.addGlobalMeta("Laser name - laser " + (n.y - 7), values[0]);
                                break;
                            }
                            case 11: {
                                int i;
                                for (i = 0; i < 3; ++i) {
                                    String prefix = "Transmission detector " + (i + 1) + " - ";
                                    this.addGlobalMeta(prefix + "offset", values[i * 3]);
                                    this.addGlobalMeta(prefix + "gain", values[i * 3 + 1]);
                                    this.addGlobalMeta(prefix + "black level", values[i * 3 + 2]);
                                    String detectorID = MetadataTools.createLSID("Detector", 0, i);
                                    store.setDetectorID(detectorID, 0, i);
                                    store.setDetectorOffset(new Double(values[i * 3]), 0, i);
                                    store.setDetectorGain(new Double(values[i * 3 + 1]), 0, i);
                                    store.setDetectorType(this.getDetectorType("Other"), 0, i);
                                }
                                break block1;
                            }
                            case 12: {
                                int i;
                                for (i = 0; i < 2; ++i) {
                                    String prefix = "Part number for ";
                                    for (int j = 0; j < STRUCTURE_LABELS_5.length; ++j) {
                                        this.addGlobalMeta(prefix + STRUCTURE_LABELS_5[j] + (i + 1), values[i * 4 + j]);
                                    }
                                }
                                break block1;
                            }
                            case 13: {
                                int i;
                                for (i = 0; i < STRUCTURE_LABELS_6.length; ++i) {
                                    this.addGlobalMeta(STRUCTURE_LABELS_6[i], values[i]);
                                }
                                break block1;
                            }
                            case 14: {
                                String prefix = "Filter Block Name - filter block ";
                                this.addGlobalMeta(prefix + "1", values[0]);
                                this.addGlobalMeta(prefix + "2", values[1]);
                                break;
                            }
                            case 15: {
                                int i;
                                for (i = 0; i < 5; ++i) {
                                    this.addGlobalMeta("Image bands status - band " + (i + 1), values[i * 3]);
                                    this.addGlobalMeta("Image bands min - band " + (i + 1), values[i * 3 + 1]);
                                    this.addGlobalMeta("Image bands max - band " + (i + 1), values[i * 3 + 2]);
                                    if (!(store instanceof IMinMaxStore)) continue;
                                    ((IMinMaxStore)((Object)store)).setChannelGlobalMinMax(i, Double.parseDouble(values[i * 3 + 1]), Double.parseDouble(values[i * 3 + 2]), 0);
                                }
                                break block1;
                            }
                            case 17: {
                                int year = Integer.parseInt(values[5]) + 1900;
                                for (int i = 0; i < 5; ++i) {
                                    if (values[i].length() != 1) continue;
                                    values[i] = "0" + values[i];
                                }
                                String date = year + "-" + values[4] + "-" + values[3] + "T" + values[2] + ":" + values[1] + ":" + values[0];
                                this.addGlobalMeta("Acquisition date", date);
                                store.setImageAcquiredDate(date, 0);
                                break;
                            }
                            case 18: {
                                this.addGlobalMeta("Mixer 3 - enhanced", values[0]);
                                for (int i = 1; i <= 3; ++i) {
                                    this.addGlobalMeta("Mixer 3 - PMT " + i + " percentage", values[i]);
                                    this.addGlobalMeta("Mixer 3 - Transmission " + i + " percentage", values[i + 3]);
                                    this.addGlobalMeta("Mixer 3 - photon counting " + i, values[i + 7]);
                                }
                                this.addGlobalMeta("Mixer 3 - low signal on", values[7]);
                                this.addGlobalMeta("Mixer 3 - mode", values[11]);
                                break;
                            }
                            case 19: {
                                for (int i = 1; i <= 2; ++i) {
                                    String prefix = "Mixer " + i + " - ";
                                    String photon = prefix + "photon counting ";
                                    this.addGlobalMeta(photon + "1", values[i * 4 - 4]);
                                    this.addGlobalMeta(photon + "2", values[i * 4 - 3]);
                                    this.addGlobalMeta(photon + "3", values[i * 4 - 2]);
                                    this.addGlobalMeta(prefix + "mode", values[i * 4 - 1]);
                                }
                                break block1;
                            }
                            case 20: {
                                this.addGlobalMeta("Display mode", values[0]);
                                this.addGlobalMeta("Course", values[1]);
                                this.addGlobalMeta("Time Course - experiment type", values[2]);
                                this.addGlobalMeta("Time Course - kd factor", values[3]);
                                String experimentID = MetadataTools.createLSID("Experiment", 0);
                                store.setExperimentID(experimentID, 0);
                                store.setExperimentType(this.getExperimentType(values[2]), 0);
                                break;
                            }
                            case 21: {
                                this.addGlobalMeta("Time Course - ion name", values[0]);
                                break;
                            }
                            case 22: {
                                this.addGlobalMeta("PIC file generated on Isoscan (lite)", values[0]);
                                for (int i = 1; i <= 3; ++i) {
                                    this.addGlobalMeta("Photon counting used (PMT " + i + ")", values[i]);
                                    this.addGlobalMeta("Hot spot filter used (PMT " + i + ")", values[i + 3]);
                                    this.addGlobalMeta("Tx Selector used (TX " + i + ")", values[i + 6]);
                                }
                            }
                        }
                        break;
                    }
                    default: {
                        this.addGlobalMeta("Note #" + noteIndex, n.toString());
                    }
                }
            }
            if (n.p.indexOf("AXIS") == -1) continue;
            n.p = n.p.replaceAll("=", "");
            Vector<String> v = new Vector<String>();
            StringTokenizer tokens = new StringTokenizer(n.p, " ");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.length() <= 0) continue;
                v.add(token);
            }
            String[] values = v.toArray(new String[v.size()]);
            String key = values[0];
            String noteType = values[1];
            int axisType = Integer.parseInt(noteType);
            if (axisType == 11 && values.length > 2) {
                this.addGlobalMeta(key + " RGB type (X)", values[2]);
                this.addGlobalMeta(key + " RGB type (Y)", values[3]);
                if (key.equals("AXIS_4")) {
                    this.core[0].sizeC = this.getImageCount();
                    this.core[0].sizeZ = 1;
                    this.core[0].sizeT = 1;
                } else if (key.equals("AXIS_9")) {
                    multipleFiles = true;
                    this.core[0].sizeC = (int)Double.parseDouble(values[3]);
                }
            }
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM || values.length <= 2) continue;
            switch (axisType) {
                case 1: {
                    this.addGlobalMeta(key + " distance (X) in microns", values[2]);
                    this.addGlobalMeta(key + " distance (Y) in microns", values[3]);
                    continue block41;
                }
                case 3: {
                    this.addGlobalMeta(key + " angle (X) in degrees", values[2]);
                    this.addGlobalMeta(key + " angle (Y) in degrees", values[3]);
                    continue block41;
                }
                case 4: {
                    this.addGlobalMeta(key + " intensity (X)", values[2]);
                    this.addGlobalMeta(key + " intensity (Y)", values[3]);
                    continue block41;
                }
                case 6: {
                    this.addGlobalMeta(key + " ratio (X)", values[2]);
                    this.addGlobalMeta(key + " ratio (Y)", values[3]);
                    continue block41;
                }
                case 7: {
                    this.addGlobalMeta(key + " log ratio (X)", values[2]);
                    this.addGlobalMeta(key + " log ratio (Y)", values[3]);
                    continue block41;
                }
                case 9: {
                    this.addGlobalMeta(key + " noncalibrated intensity min", values[2]);
                    this.addGlobalMeta(key + " noncalibrated intensity max", values[3]);
                    this.addGlobalMeta(key + " calibrated intensity min", values[4]);
                    this.addGlobalMeta(key + " calibrated intensity max", values[5]);
                    continue block41;
                }
                case 14: {
                    this.addGlobalMeta(key + " time course type (X)", values[2]);
                    this.addGlobalMeta(key + " time course type (Y)", values[3]);
                    continue block41;
                }
                case 15: {
                    String prefix = " inverse sigmoid calibrated intensity ";
                    this.addGlobalMeta(key + prefix + "(min)", values[2]);
                    this.addGlobalMeta(key + prefix + "(max)", values[3]);
                    this.addGlobalMeta(key + prefix + "(beta)", values[4]);
                    this.addGlobalMeta(key + prefix + "(Kd)", values[5]);
                    continue block41;
                }
                case 16: {
                    String prefix = " log inverse sigmoid calibrated intensity ";
                    this.addGlobalMeta(key + prefix + "(min)", values[2]);
                    this.addGlobalMeta(key + prefix + "(max)", values[3]);
                    this.addGlobalMeta(key + prefix + "(beta)", values[4]);
                    this.addGlobalMeta(key + prefix + "(Kd)", values[5]);
                }
            }
        }
        return multipleFiles;
    }

    private void readLookupTables(RandomAccessInputStream s) throws IOException {
        int channel;
        for (channel = 0; channel < this.lut.length && this.lut[channel] != null; ++channel) {
        }
        if (channel >= this.lut.length) {
            return;
        }
        this.readNotes(s, false);
        boolean eof = false;
        int next = 0;
        while (!eof && channel < this.lut.length && !this.brokenNotes) {
            if (s.getFilePointer() + 256L <= s.length()) {
                if (this.lut[channel] == null) {
                    this.lut[channel] = new byte[3][256];
                }
                s.read(this.lut[channel][next++]);
                if (next == 3) {
                    next = 0;
                    ++channel;
                }
            } else {
                eof = true;
            }
            if (!eof || channel != 0) continue;
            this.lut = null;
        }
        if (this.brokenNotes) {
            this.lut = null;
        }
    }

    class Note {
        public int num;
        public int level;
        public int status;
        public int type;
        public int x;
        public int y;
        public String p;

        Note() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("level=");
            sb.append(this.level);
            sb.append("; num=");
            sb.append(this.num);
            sb.append("; status=");
            sb.append(this.status);
            sb.append("; type=");
            sb.append(NOTE_NAMES[this.type]);
            sb.append("; x=");
            sb.append(this.x);
            sb.append("; y=");
            sb.append(this.y);
            sb.append("; text=");
            sb.append(this.p == null ? "null" : this.p.trim());
            return sb.toString();
        }
    }

    class BioRadHandler
    extends DefaultHandler {
        BioRadHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Pixels")) {
                String sizeZ = attributes.getValue("SizeZ");
                String sizeC = attributes.getValue("SizeC");
                String sizeT = attributes.getValue("SizeT");
                int z = sizeZ == null ? 1 : Integer.parseInt(sizeZ);
                int c = sizeC == null ? 1 : Integer.parseInt(sizeC);
                int t = sizeT == null ? 1 : Integer.parseInt(sizeT);
                int count = BioRadReader.this.getSizeZ() * BioRadReader.this.getSizeC() * BioRadReader.this.getSizeT();
                ((BioRadReader)BioRadReader.this).core[0].sizeZ = z;
                ((BioRadReader)BioRadReader.this).core[0].sizeC = c;
                ((BioRadReader)BioRadReader.this).core[0].sizeT = t;
                if (count >= BioRadReader.this.getImageCount()) {
                    ((BioRadReader)BioRadReader.this).core[0].imageCount = count;
                } else {
                    ((BioRadReader)BioRadReader.this).core[0].sizeC = BioRadReader.this.getImageCount() / count;
                }
            } else if (qName.equals("Z") || qName.equals("C") || qName.equals("T")) {
                String stamp = attributes.getValue("TimeCompleted");
                int count = 0;
                while (BioRadReader.this.metadata.containsKey("Timestamp " + count)) {
                    ++count;
                }
                BioRadReader.this.addGlobalMeta("Timestamp " + count, stamp);
            }
        }
    }
}

