/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class AIMReader
extends FormatReader {
    private long pixelOffset;

    public AIMReader() {
        super("AIM", "aim");
        this.domains = new String[]{"Unknown"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset + (long)(FormatTools.getPlaneSize(this) * no));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] lines;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.in.seek(56L);
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.core[0].sizeZ = this.in.readInt();
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = this.getSizeZ();
        this.core[0].pixelType = 2;
        this.core[0].dimensionOrder = "XYZCT";
        this.in.seek(160L);
        String processingLog = this.in.readCString();
        this.pixelOffset = this.in.getFilePointer();
        String date = null;
        Double xSize = null;
        Double xLength = null;
        Double ySize = null;
        Double yLength = null;
        Double zSize = null;
        Double zLength = null;
        for (String line : lines = processingLog.split("\n")) {
            String[] tokens;
            int split = (line = line.trim()).indexOf("  ");
            if (split <= 0) continue;
            String key = line.substring(0, split).trim();
            String value = line.substring(split).trim();
            this.addGlobalMeta(key, value);
            if (key.equals("Original Creation-Date")) {
                date = DateTools.formatDate(value, "dd-MMM-yyyy HH:mm:ss.SS");
                continue;
            }
            if (key.equals("Orig-ISQ-Dim-p")) {
                for (String token : tokens = value.split(" ")) {
                    if ((token = token.trim()).length() <= 0) continue;
                    if (xSize == null) {
                        xSize = new Double(token);
                        continue;
                    }
                    if (ySize == null) {
                        ySize = new Double(token);
                        continue;
                    }
                    if (zSize != null) continue;
                    zSize = new Double(token);
                }
                continue;
            }
            if (!key.equals("Orig-ISQ-Dim-um")) continue;
            for (String token : tokens = value.split(" ")) {
                if ((token = token.trim()).length() <= 0) continue;
                if (xLength == null) {
                    xLength = new Double(token);
                    continue;
                }
                if (yLength == null) {
                    yLength = new Double(token);
                    continue;
                }
                if (zLength != null) continue;
                zLength = new Double(token);
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (date != null) {
            store.setImageAcquiredDate(date, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (xSize != null && xLength != null) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(Double.valueOf(xLength / xSize)), 0);
            }
            if (ySize != null && yLength != null) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(Double.valueOf(yLength / ySize)), 0);
            }
            if (zSize != null && zLength != null) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(Double.valueOf(zLength / zSize)), 0);
            }
        }
    }
}

