/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import loci.common.DataTools;
import loci.common.Location;
import loci.formats.AxisGuesser;
import loci.formats.FilePatternBlock;
import loci.formats.NumberFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePattern.class);
    private String pattern;
    private boolean valid;
    private String msg;
    private int[] startIndex;
    private int[] endIndex;
    private FilePatternBlock[] blocks;
    private String[] files;
    private boolean isRegex = false;

    public FilePattern(Location file) {
        this(FilePattern.findPattern(file));
    }

    public FilePattern(String name, String dir) {
        this(FilePattern.findPattern(name, dir));
    }

    public FilePattern(String pattern) {
        int i;
        this.pattern = pattern;
        this.valid = false;
        if (pattern == null) {
            this.msg = "Null pattern string.";
            return;
        }
        int len = pattern.length();
        ArrayList<Integer> lt = new ArrayList<Integer>(len);
        ArrayList<Integer> gt = new ArrayList<Integer>(len);
        int left = -1;
        while ((left = pattern.indexOf("<", left + 1)) >= 0) {
            lt.add(new Integer(left));
        }
        int right = -1;
        while ((right = pattern.indexOf(">", right + 1)) >= 0) {
            gt.add(new Integer(right));
        }
        int num = lt.size();
        if (num != gt.size()) {
            this.msg = "Mismatched numerical block markers.";
            return;
        }
        this.startIndex = new int[num];
        this.endIndex = new int[num];
        for (i = 0; i < num; ++i) {
            int val = (Integer)lt.get(i);
            if (i > 0 && val < this.endIndex[i - 1]) {
                this.msg = "Bad numerical block marker order.";
                return;
            }
            this.startIndex[i] = val;
            val = (Integer)gt.get(i);
            if (val <= this.startIndex[i]) {
                this.msg = "Bad numerical block marker order.";
                return;
            }
            this.endIndex[i] = val + 1;
        }
        this.blocks = new FilePatternBlock[num];
        for (i = 0; i < num; ++i) {
            String block = pattern.substring(this.startIndex[i], this.endIndex[i]);
            this.blocks[i] = new FilePatternBlock(block);
        }
        ArrayList<String> fileList = new ArrayList<String>();
        this.buildFiles("", num, fileList);
        this.files = fileList.toArray(new String[0]);
        if (this.files.length == 0 && new Location(pattern).exists()) {
            this.files = new String[]{pattern};
        }
        this.valid = true;
    }

    public boolean isRegex() {
        return this.isRegex;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getErrorMessage() {
        return this.msg;
    }

    public String[] getFiles() {
        return this.files;
    }

    public String[][] getElements() {
        String[][] elements = new String[this.blocks.length][];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.blocks[i].getElements();
        }
        return elements;
    }

    public int[] getCount() {
        int[] count = new int[this.blocks.length];
        for (int i = 0; i < count.length; ++i) {
            count[i] = this.blocks[i].getElements().length;
        }
        return count;
    }

    public String getBlock(int i) {
        if (i < 0 || i >= this.startIndex.length) {
            return null;
        }
        return this.pattern.substring(this.startIndex[i], this.endIndex[i]);
    }

    public String[] getBlocks() {
        String[] s = new String[this.startIndex.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.getBlock(i);
        }
        return s;
    }

    public String getPrefix() {
        int dot;
        int s = this.pattern.lastIndexOf(File.separator) + 1;
        int e = this.startIndex.length > 0 ? this.startIndex[0] : ((dot = this.pattern.lastIndexOf(".")) < s ? this.pattern.length() : dot);
        return s <= e ? this.pattern.substring(s, e) : "";
    }

    public String getSuffix() {
        return this.endIndex.length > 0 ? this.pattern.substring(this.endIndex[this.endIndex.length - 1]) : this.pattern;
    }

    public String getPrefix(int i) {
        if (i < 0 || i >= this.startIndex.length) {
            return null;
        }
        int s = i > 0 ? this.endIndex[i - 1] : this.pattern.lastIndexOf(File.separator) + 1;
        int e = this.startIndex[i];
        return s <= e ? this.pattern.substring(s, e) : null;
    }

    public String[] getPrefixes() {
        String[] s = new String[this.startIndex.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.getPrefix(i);
        }
        return s;
    }

    public static String findPattern(String path) {
        return FilePattern.findPattern(new Location(path));
    }

    public static String findPattern(Location file) {
        return FilePattern.findPattern(file.getName(), file.getAbsoluteFile().getParent());
    }

    public static String findPattern(File file) {
        return FilePattern.findPattern(file.getName(), file.getAbsoluteFile().getParent());
    }

    public static String findPattern(String name, String dir) {
        if (dir == null) {
            dir = "";
        } else if (!dir.equals("") && !dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        Location dirFile = new Location(dir.equals("") ? "." : dir);
        Location[] f = dirFile.listFiles();
        if (f == null) {
            return null;
        }
        String[] nameList = new String[f.length];
        for (int i = 0; i < nameList.length; ++i) {
            nameList[i] = f[i].getName();
        }
        return FilePattern.findPattern(name, dir, nameList);
    }

    public static String findPattern(String name, String dir, String[] nameList) {
        return FilePattern.findPattern(name, dir, nameList, null);
    }

    public static String findPattern(String name, String dir, String[] nameList, int[] excludeAxes) {
        int i;
        if (excludeAxes == null) {
            excludeAxes = new int[]{};
        }
        if (dir == null) {
            dir = "";
        } else if (!dir.equals("") && !dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        int len = name.length();
        int bound = (len + 1) / 2;
        int[] indexList = new int[bound];
        int[] endList = new int[bound];
        int q = 0;
        boolean num = false;
        int ndx = -1;
        int e = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char c = name.charAt(i2);
            if (c >= '0' && c <= '9') {
                if (num) {
                    ++e;
                    continue;
                }
                num = true;
                ndx = i2;
                e = ndx + 1;
                continue;
            }
            if (!num) continue;
            num = false;
            indexList[q] = ndx;
            endList[q] = e;
            ++q;
        }
        if (num) {
            indexList[q] = ndx;
            endList[q] = e;
            ++q;
        }
        StringBuffer sb = new StringBuffer(dir);
        for (i = 0; i < q; ++i) {
            int last = i > 0 ? endList[i - 1] : 0;
            String prefix = name.substring(last, indexList[i]);
            int axisType = AxisGuesser.getAxisType(prefix);
            if (DataTools.containsValue(excludeAxes, axisType)) {
                sb.append(name.substring(last, endList[i]));
                continue;
            }
            sb.append(prefix);
            String pre = name.substring(0, indexList[i]);
            String post = name.substring(endList[i]);
            NumberFilter filter = new NumberFilter(pre, post);
            String[] list = FilePattern.matchFiles(nameList, filter);
            if (list == null || list.length == 0) {
                return null;
            }
            if (list.length == 1) {
                sb.append(name.substring(indexList[i], endList[i]));
                continue;
            }
            boolean fix = true;
            for (String s : list) {
                if (s.length() == len) continue;
                fix = false;
                break;
            }
            if (fix) {
                int j;
                int width = endList[i] - indexList[i];
                boolean[] same = new boolean[width];
                block3: for (j = 0; j < width; ++j) {
                    same[j] = true;
                    int jx = indexList[i] + j;
                    char c = name.charAt(jx);
                    for (String s : list) {
                        if (s.charAt(jx) == c) continue;
                        same[j] = false;
                        continue block3;
                    }
                }
                j = 0;
                while (j < width) {
                    int c;
                    int jx = indexList[i] + j;
                    if (same[j]) {
                        sb.append(name.charAt(jx));
                        ++j;
                        continue;
                    }
                    while (j < width && !same[j]) {
                        ++j;
                    }
                    String p = FilePattern.findPattern(name, nameList, jx, indexList[i] + j, "");
                    int n = c = indexList[i] > 0 ? (int)name.charAt(indexList[i] - 1) : 46;
                    if (p == null && c != 83 && c != 115 && c != 69 && c != 101) {
                        return null;
                    }
                    if (p == null) {
                        sb.append(name.charAt(endList[i] - 1));
                        continue;
                    }
                    sb.append(p);
                }
                continue;
            }
            Object[] numbers = new BigInteger[list.length];
            for (int j = 0; j < list.length; ++j) {
                numbers[j] = filter.getNumber(list[j]);
            }
            Arrays.sort(numbers);
            String bounds = FilePattern.getBounds((BigInteger[])numbers, false);
            if (bounds == null) {
                return null;
            }
            sb.append(bounds);
        }
        sb.append(q > 0 ? name.substring(endList[q - 1]) : name);
        for (i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\\') continue;
            sb.insert(i, '\\');
            ++i;
        }
        return sb.toString();
    }

    public static String findPattern(String[] names) {
        String dir = names[0].substring(0, names[0].lastIndexOf(File.separator) + 1);
        StringBuffer pattern = new StringBuffer();
        pattern.append(Pattern.quote(dir));
        for (int i = 0; i < names.length; ++i) {
            pattern.append("(?:");
            String name = names[i].substring(names[i].lastIndexOf(File.separator) + 1);
            pattern.append(Pattern.quote(name));
            pattern.append(")");
            if (i >= names.length - 1) continue;
            pattern.append("|");
        }
        return pattern.toString();
    }

    public static String[] findSeriesPatterns(String base) {
        Location file = new Location(base).getAbsoluteFile();
        Location parent = file.getParentFile();
        String[] list = parent.list(true);
        return FilePattern.findSeriesPatterns(base, parent.getAbsolutePath(), list);
    }

    public static String[] findSeriesPatterns(String base, String dir, String[] nameList) {
        String baseSuffix = base.substring(base.lastIndexOf(File.separator) + 1);
        int dot = baseSuffix.indexOf(".");
        baseSuffix = dot < 0 ? "" : baseSuffix.substring(dot + 1);
        ArrayList<String> patterns = new ArrayList<String>();
        int[] exclude = new int[]{4};
        for (String name : nameList) {
            String patternSuffix;
            String pattern = FilePattern.findPattern(name, dir, nameList, exclude);
            if (pattern == null) continue;
            int start = pattern.lastIndexOf(File.separator) + 1;
            if (start < 0) {
                start = 0;
            }
            patternSuffix = (dot = (patternSuffix = pattern.substring(start)).indexOf(".")) < 0 ? "" : patternSuffix.substring(dot + 1);
            String checkPattern = FilePattern.findPattern(name, dir, nameList);
            Object[] checkFiles = new FilePattern(checkPattern).getFiles();
            if (patterns.contains(pattern) || new Location(pattern).exists() && !base.equals(pattern) || !patternSuffix.equals(baseSuffix) || DataTools.indexOf(checkFiles, base) < 0) continue;
            patterns.add(pattern);
        }
        Object[] s = patterns.toArray(new String[patterns.size()]);
        Arrays.sort(s);
        return s;
    }

    private static String findPattern(String name, String[] nameList, int ndx, int end, String p) {
        if (ndx == end) {
            return p;
        }
        for (int i = end - ndx; i >= 1; --i) {
            String pat;
            NumberFilter filter = new NumberFilter(name.substring(0, ndx), name.substring(ndx + i));
            String[] list = FilePattern.matchFiles(nameList, filter);
            Object[] numbers = new BigInteger[list.length];
            for (int j = 0; j < list.length; ++j) {
                numbers[j] = new BigInteger(list[j].substring(ndx, ndx + i));
            }
            Arrays.sort(numbers);
            String bounds = FilePattern.getBounds((BigInteger[])numbers, true);
            if (bounds == null || (pat = FilePattern.findPattern(name, nameList, ndx + i, end, p + bounds)) == null) continue;
            return pat;
        }
        return null;
    }

    private static String getBounds(BigInteger[] numbers, boolean fixed) {
        if (numbers.length < 2) {
            return null;
        }
        BigInteger b = numbers[0];
        BigInteger e = numbers[numbers.length - 1];
        BigInteger s = numbers[1].subtract(b);
        if (s.equals(BigInteger.ZERO)) {
            return null;
        }
        for (int i = 2; i < numbers.length; ++i) {
            if (numbers[i].subtract(numbers[i - 1]).equals(s)) continue;
            return null;
        }
        String sb = b.toString();
        String se = e.toString();
        StringBuffer bounds = new StringBuffer("<");
        if (fixed) {
            int zeroes = se.length() - sb.length();
            for (int i = 0; i < zeroes; ++i) {
                bounds.append("0");
            }
        }
        bounds.append(sb);
        bounds.append("-");
        bounds.append(se);
        if (!s.equals(BigInteger.ONE)) {
            bounds.append(":");
            bounds.append(s);
        }
        bounds.append(">");
        return bounds.toString();
    }

    private static String[] matchFiles(String[] inFiles, NumberFilter filter) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < inFiles.length; ++i) {
            if (!filter.accept(inFiles[i])) continue;
            list.add(inFiles[i]);
        }
        return list.toArray(new String[0]);
    }

    private void buildFiles(String prefix, int ndx, List<String> fileList) {
        if (this.blocks.length == 0) {
            int end;
            String dir;
            if (new Location(this.pattern).exists()) {
                fileList.add(this.pattern);
                return;
            }
            this.isRegex = true;
            Object[] files = null;
            int endRegex = this.pattern.indexOf(File.separator + "\\E") + 1;
            int endNotRegex = this.pattern.lastIndexOf(File.separator) + 1;
            if (this.pattern.startsWith("\\Q") && endRegex > 0 && endRegex <= endNotRegex) {
                dir = this.pattern.substring(2, endRegex);
                end = endRegex + 2;
            } else {
                dir = this.pattern.substring(0, endNotRegex);
                end = endNotRegex;
            }
            if (dir.equals("") || !new Location(dir).exists()) {
                files = Location.getIdMap().keySet().toArray(new String[0]);
                if (files.length == 0) {
                    dir = ".";
                    files = new Location(dir).list();
                }
            } else {
                files = new Location(dir).list();
            }
            Arrays.sort(files);
            String basePattern = this.pattern.substring(end);
            Pattern regex = null;
            try {
                regex = Pattern.compile(basePattern);
            }
            catch (PatternSyntaxException e) {
                regex = Pattern.compile(this.pattern);
            }
            for (Object f : files) {
                Location path = new Location(dir, (String)f);
                if (!regex.matcher((CharSequence)f).matches() && !regex.matcher(path.getAbsolutePath()).matches()) continue;
                if (path.exists()) {
                    fileList.add(path.getAbsolutePath());
                    continue;
                }
                fileList.add((String)f);
            }
        } else {
            int num = this.startIndex.length;
            int n1 = ndx == 0 ? 0 : this.endIndex[ndx - 1];
            int n2 = ndx == num ? this.pattern.length() : this.startIndex[ndx];
            String pre = this.pattern.substring(n1, n2);
            if (ndx == 0) {
                fileList.add(pre + prefix);
            } else {
                String[] blockElements;
                FilePatternBlock block = this.blocks[--ndx];
                for (String element : blockElements = block.getElements()) {
                    this.buildFiles(element + pre + prefix, ndx, fileList);
                }
            }
        }
    }

    public static void main(String[] args) {
        int i;
        String pat = null;
        if (args.length > 0) {
            Location file = new Location(args[0]);
            LOGGER.info("File = {}", (Object)file.getAbsoluteFile());
            pat = FilePattern.findPattern(file);
        } else {
            String[] nameList = new String[289];
            nameList[0] = "outlier.ext";
            int count = 1;
            for (i = 1; i <= 2; ++i) {
                for (int j = 1; j <= 4; ++j) {
                    for (int k = 0; k <= 2; ++k) {
                        for (int l = 1; l <= 12; ++l) {
                            String sl = (l < 10 ? "0" : "") + l;
                            nameList[count++] = "hypothetical" + sl + k + j + "c" + i + ".ext";
                        }
                    }
                }
            }
            pat = FilePattern.findPattern(nameList[1], null, nameList);
        }
        if (pat == null) {
            LOGGER.info("No pattern found.");
        } else {
            LOGGER.info("Pattern = {}", (Object)pat);
            FilePattern fp = new FilePattern(pat);
            if (fp.isValid()) {
                LOGGER.info("Pattern is valid.");
                LOGGER.info("Files:");
                String[] ids = fp.getFiles();
                for (i = 0; i < ids.length; ++i) {
                    LOGGER.info("  #{}: {}", (Object)i, (Object)ids[i]);
                }
            } else {
                LOGGER.info("Pattern is invalid: {}", (Object)fp.getErrorMessage());
            }
        }
    }

    public BigInteger[] getFirst() {
        BigInteger[] first = new BigInteger[this.blocks.length];
        for (int i = 0; i < first.length; ++i) {
            first[i] = this.blocks[i].getFirst();
        }
        return first;
    }

    public BigInteger[] getLast() {
        BigInteger[] last = new BigInteger[this.blocks.length];
        for (int i = 0; i < last.length; ++i) {
            last[i] = this.blocks[i].getLast();
        }
        return last;
    }

    public BigInteger[] getStep() {
        BigInteger[] step = new BigInteger[this.blocks.length];
        for (int i = 0; i < step.length; ++i) {
            step[i] = this.blocks[i].getStep();
        }
        return step;
    }
}

