/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.util.metadata;

import java.util.Arrays;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedSpace;

public class CalibratedSpaceImpl
implements CalibratedSpace {
    private final AxisType[] m_axes;
    private final double[] m_cal;

    public CalibratedSpaceImpl(int numDims) {
        this.m_axes = new AxisType[numDims];
        Arrays.fill(this.m_axes, Axes.UNKNOWN);
        this.m_cal = new double[numDims];
    }

    public CalibratedSpaceImpl(String ... axisLabels) {
        this.m_axes = new AxisType[axisLabels.length];
        for (int i = 0; i < this.m_axes.length; ++i) {
            this.m_axes[i] = Axes.get(axisLabels[i]);
        }
        this.m_cal = new double[axisLabels.length];
    }

    public CalibratedSpaceImpl(AxisType[] axes, double[] calibration) {
        this.m_axes = axes;
        this.m_cal = calibration;
    }

    public CalibratedSpaceImpl(CalibratedSpace axes) {
        this.m_axes = new AxisType[axes.numDimensions()];
        this.m_cal = new double[axes.numDimensions()];
        axes.axes(this.m_axes);
        axes.calibration(this.m_cal);
    }

    public CalibratedSpaceImpl(String[] axisLabels, double[] calibration) {
        this.m_axes = new AxisType[axisLabels.length];
        this.m_cal = (double[])calibration.clone();
        for (int d = 0; d < axisLabels.length; ++d) {
            this.m_axes[d] = Axes.get(axisLabels[d]);
        }
    }

    @Override
    public int getAxisIndex(AxisType axis) {
        for (int i = 0; i < this.m_axes.length; ++i) {
            if (!this.m_axes[i].getLabel().equals(axis.getLabel())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AxisType axis(int d) {
        return this.m_axes[d];
    }

    @Override
    public void axes(AxisType[] target) {
        for (int i = 0; i < this.m_axes.length; ++i) {
            target[i] = this.m_axes[i];
        }
    }

    @Override
    public void setAxis(AxisType axis, int d) {
        this.m_axes[d] = axis;
    }

    @Override
    public double calibration(int d) {
        return this.m_cal[d];
    }

    @Override
    public void calibration(double[] target) {
        for (int i = 0; i < target.length; ++i) {
            target[i] = this.m_cal[i];
        }
    }

    @Override
    public void setCalibration(double value, int d) {
        this.m_cal[d] = value;
    }

    @Override
    public int numDimensions() {
        return this.m_axes.length;
    }

    @Override
    public void calibration(float[] cal) {
        for (int d = 0; d < cal.length; ++d) {
            cal[d] = (float)this.m_cal[d];
        }
    }

    @Override
    public void setCalibration(double[] cal) {
        for (int d = 0; d < cal.length; ++d) {
            this.m_cal[d] = cal[d];
        }
    }

    @Override
    public void setCalibration(float[] cal) {
        for (int d = 0; d < cal.length; ++d) {
            this.m_cal[d] = cal[d];
        }
    }
}

