/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.util;

import net.imglib2.type.numeric.ComplexType;

public class ComplexHelper {
    private ComplexHelper() {
    }

    public static double getModulus(ComplexType<?> z) {
        return Math.sqrt(ComplexHelper.getModulus2(z));
    }

    public static double getModulus2(ComplexType<?> z) {
        return z.getRealDouble() * z.getRealDouble() + z.getImaginaryDouble() * z.getImaginaryDouble();
    }

    public static double getArgument(ComplexType<?> z) {
        double x = z.getRealDouble();
        double y = z.getImaginaryDouble();
        double theta = x == 0.0 ? (y > 0.0 ? 1.5707963267948966 : (y < 0.0 ? -1.5707963267948966 : Double.NaN)) : (y == 0.0 ? (x > 0.0 ? 0.0 : Math.PI) : Math.atan2(y, x));
        return theta;
    }

    public static double getPrincipleArgument(double angle) {
        double arg;
        for (arg = angle; arg <= -Math.PI; arg += Math.PI * 2) {
        }
        while (arg > Math.PI) {
            arg -= Math.PI * 2;
        }
        return arg;
    }

    public static void setPolar(ComplexType<?> z, double r, double theta) {
        double x = r * Math.cos(theta);
        double y = r * Math.sin(theta);
        z.setComplexNumber(x, y);
    }
}

