/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.sandbox;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;

public class RealAverageOperation<U extends RealType<U>, V extends RealType<V>> {
    public void evaluate(IterableInterval<U> region, V output) {
        double sum = 0.0;
        long numElements = 0L;
        Cursor<U> cursor = region.cursor();
        while (cursor.hasNext()) {
            sum += ((RealType)cursor.next()).getRealDouble();
            ++numElements;
        }
        if (numElements == 0L) {
            output.setReal(0.0f);
        } else {
            output.setReal(sum / (double)numElements);
        }
    }

    public V createOutput(U dataHint) {
        return null;
    }

    public RealAverageOperation<U, V> copy() {
        return new RealAverageOperation<U, V>();
    }
}

