/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.sandbox;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Sampler;

public class NewIterableInterval<T>
extends AbstractInterval
implements IterableInterval<T> {
    private List<PrivateCursor<T>> cursors = new ArrayList<PrivateCursor<T>>();

    public NewIterableInterval(long[] min, long[] max) {
        super(min, max);
    }

    public void relocate(long[] newOrigin) {
        for (int i = 0; i < newOrigin.length; ++i) {
            int n = i;
            this.max[n] = this.max[n] + (newOrigin[i] - this.min[i]);
            this.min[i] = newOrigin[i];
        }
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public T firstElement() {
        return null;
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public Iterator<T> iterator() {
        return null;
    }

    @Override
    public Cursor<T> cursor() {
        PrivateCursor cursor = new PrivateCursor(this);
        this.cursors.add(cursor);
        return cursor;
    }

    @Override
    public Cursor<T> localizingCursor() {
        return new PrivateCursor(this);
    }

    private class PrivateCursor<M>
    implements Cursor<M> {
        private long[] cmin;
        private long[] cmax;
        private long[] cpos;
        private NewIterableInterval<M> interval;

        public PrivateCursor(NewIterableInterval<M> interval) {
            this.interval = interval;
            this.cmin = ((NewIterableInterval)interval).min;
            this.cmax = ((NewIterableInterval)interval).max;
            this.cpos = (long[])this.cmin.clone();
        }

        @Override
        public void localize(float[] position) {
            for (int i = 0; i < NewIterableInterval.this.n; ++i) {
                position[i] = this.cpos[i];
            }
        }

        @Override
        public void localize(double[] position) {
            for (int i = 0; i < NewIterableInterval.this.n; ++i) {
                position[i] = this.cpos[i];
            }
        }

        @Override
        public float getFloatPosition(int d) {
            return this.getLongPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.getLongPosition(d);
        }

        @Override
        public int numDimensions() {
            return NewIterableInterval.this.n;
        }

        @Override
        public M get() {
            return null;
        }

        @Override
        public Sampler<M> copy() {
            return null;
        }

        @Override
        public void jumpFwd(long steps) {
        }

        @Override
        public void fwd() {
        }

        @Override
        public void reset() {
            for (int i = 0; i < NewIterableInterval.this.n; ++i) {
                this.cmin[i] = NewIterableInterval.this.min[i];
                this.cmax[i] = NewIterableInterval.this.max[i];
                this.cpos[i] = NewIterableInterval.this.min[i];
            }
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public M next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void localize(int[] position) {
        }

        @Override
        public void localize(long[] position) {
        }

        @Override
        public int getIntPosition(int d) {
            return (int)this.getLongPosition(d);
        }

        @Override
        public long getLongPosition(int d) {
            return this.cpos[d];
        }

        @Override
        public Cursor<M> copyCursor() {
            return new PrivateCursor<M>(this.interval);
        }
    }
}

