/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.sandbox;

import net.imglib2.RealCursor;
import net.imglib2.ops.sandbox.NewFunc;
import net.imglib2.ops.sandbox.NewIterableInterval;
import net.imglib2.type.numeric.RealType;

public class NewIntegralFunc<U extends RealType<U>>
implements NewFunc<U, U> {
    private NewFunc<U, U> otherFunc;
    private double[] deltas;
    private double cellSize;
    U tmp;

    public NewIntegralFunc(double[] deltas, NewFunc<U, U> otherFunc) {
        this.otherFunc = otherFunc;
        this.deltas = deltas;
        this.cellSize = 1.0;
        this.tmp = this.createOutput();
    }

    @Override
    public void evaluate(NewIterableInterval<U> interval, U output) {
        RealCursor cursor = interval.cursor();
        double sum = 0.0;
        while (cursor.hasNext()) {
            this.otherFunc.evaluate(interval, this.tmp);
            sum += this.cellSize * this.tmp.getRealDouble();
        }
        output.setReal(sum);
    }

    @Override
    public U createOutput() {
        return (U)((RealType)this.otherFunc.createOutput());
    }

    @Override
    public NewFunc<U, U> copy() {
        return null;
    }
}

