/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.sandbox;

import net.imglib2.Cursor;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.ops.sandbox.NewFunc;
import net.imglib2.ops.sandbox.NewIterableInterval;
import net.imglib2.type.numeric.RealType;

public class NewAvgFunc<U extends RealType<U>, V extends RealType<V>>
implements NewFunc<U, V> {
    private Cursor<U> crs = null;
    private V outType = null;

    public NewAvgFunc(V outType) {
        this.outType = outType;
    }

    @Override
    public void evaluate(NewIterableInterval<U> i, V output) {
        if (this.crs == null) {
            this.crs = i.cursor();
        }
        this.crs.reset();
        double sum = 0.0;
        long numElements = 0L;
        while (this.crs.hasNext()) {
            sum += ((RealType)this.crs.next()).getRealDouble();
            ++numElements;
        }
        if (numElements == 0L) {
            output.setZero();
        } else {
            output.setReal(sum / (double)numElements);
        }
    }

    @Override
    public void evaluate(RealRandomAccessibleRealInterval<U> interval, V output) {
        interval.realRandomAccess();
    }

    @Override
    public void evaluate(Cursor<U> cursor, V output) {
        if (this.crs == null) {
            this.crs = cursor.copyCursor();
        }
        this.crs.reset();
        double sum = 0.0;
        long numElements = 0L;
        while (this.crs.hasNext()) {
            sum += ((RealType)this.crs.next()).getRealDouble();
            ++numElements;
        }
        if (numElements == 0L) {
            output.setZero();
        } else {
            output.setReal(sum / (double)numElements);
        }
    }

    @Override
    public V createOutput() {
        return (V)((RealType)this.outType.createVariable());
    }

    @Override
    public NewAvgFunc<U, V> copy() {
        return new NewAvgFunc<U, V>(this.outType);
    }
}

