/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.sandbox;

import net.imglib2.AbstractInterval;
import net.imglib2.Interval;
import net.imglib2.Iterator;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.real.DoubleType;

public class FunctionDefinitionIdeas {
    public void skeleton() {
        RandomAccessibleInterval image;
        ComplexFunction func = null;
        DoubleType output = new DoubleType();
        RandomAccessibleInterval interval = image = null;
        long MAX_X = 200L;
        long MAX_Y = 200L;
        long[] keyPt = new long[2];
        SubInterval subInterval = new SubInterval(image);
        keyPt[0] = 0L;
        keyPt[1] = 0L;
        subInterval.orient(keyPt);
        func.evaluate(keyPt, subInterval, output);
        subInterval = new SubInterval(image, new long[]{1L, 1L}, new long[]{1L, 1L});
        keyPt[0] = MAX_X / 2L;
        keyPt[1] = MAX_Y / 2L;
        subInterval.orient(keyPt);
        func.evaluate(keyPt, subInterval, output);
        subInterval = new SubInterval(interval, new long[]{2L, 2L}, new long[]{2L, 2L});
        for (long x = 0L; x < MAX_X; ++x) {
            long y = 0L;
            while (y < MAX_Y) {
                keyPt[0] = x;
                keyPt[1] = y++;
                subInterval.orient(keyPt);
                func.evaluate(keyPt, subInterval, output);
            }
        }
    }

    private static class AverageFunction<T extends Type<T>>
    implements ComplexFunction<T> {
        private T type;
        final /* synthetic */ FunctionDefinitionIdeas this$0;

        public AverageFunction(T type) {
            this.this$0 = var1_1;
            this.type = type.createVariable();
        }

        @Override
        public T createVariable() {
            return this.type.createVariable();
        }

        @Override
        public void evaluate(long[] coordinate, SubInterval<T> interval, ComplexType<?> output) {
            double sum = 0.0;
            long numElem = 0L;
            Iterator cursor = null;
            while (cursor.hasNext()) {
                sum += ((RealType)cursor.get()).getRealDouble();
                ++numElem;
            }
            if (numElem == 0L) {
                output.setReal(0.0f);
            } else {
                output.setReal(sum / (double)numElem);
            }
        }
    }

    private static class SumOf3Averages<T extends Type<T>>
    implements ComplexFunction<T> {
        private T type;
        private ComplexDoubleType temp;
        private SubInterval<T> interval1;
        private SubInterval<T> interval2;
        private SubInterval<T> interval3;
        private AverageFunction<T> aveFunc;
        final /* synthetic */ FunctionDefinitionIdeas this$0;

        public SumOf3Averages(T type) {
            this.this$0 = var1_1;
            this.type = type.createVariable();
            this.temp = new ComplexDoubleType();
        }

        @Override
        public T createVariable() {
            return this.type.createVariable();
        }

        @Override
        public void evaluate(long[] coordinate, SubInterval<T> interval, ComplexType<?> output) {
            if (this.aveFunc == null) {
                this.aveFunc = new AverageFunction(this.this$0, this.type);
                long[] planeSize = new long[]{interval.dimension(0), interval.dimension(1), 1L};
                this.interval1 = this.this$0.new SubInterval<T>(interval, new long[3], planeSize);
                this.interval2 = this.this$0.new SubInterval<T>(interval, new long[3], planeSize);
                this.interval3 = this.this$0.new SubInterval<T>(interval, new long[3], planeSize);
                long[] newKeyPt = new long[3];
                newKeyPt[2] = 0L;
                this.interval1.orient(newKeyPt);
                newKeyPt[2] = 1L;
                this.interval2.orient(newKeyPt);
                newKeyPt[2] = 2L;
                this.interval3.orient(newKeyPt);
            }
            double sumR = 0.0;
            double sumI = 0.0;
            this.aveFunc.evaluate(coordinate, this.interval1, this.temp);
            sumR += this.temp.getRealDouble();
            sumI += this.temp.getRealDouble();
            this.aveFunc.evaluate(coordinate, this.interval2, this.temp);
            sumR += this.temp.getRealDouble();
            sumI += this.temp.getRealDouble();
            this.aveFunc.evaluate(coordinate, this.interval3, this.temp);
            output.setReal(sumR += this.temp.getRealDouble());
            output.setImaginary(sumI += this.temp.getRealDouble());
        }
    }

    private class SubInterval<K>
    extends AbstractInterval
    implements RandomAccessibleInterval<K> {
        SubInterval(RandomAccessibleInterval<K> interval) {
            super(interval);
            long[] dims = new long[interval.numDimensions()];
            long[] negOffs = new long[interval.numDimensions()];
            long[] posOffs = new long[interval.numDimensions()];
            for (int i = 0; i < dims.length; ++i) {
                posOffs[i] = dims[i] - 1L;
            }
            this.init(interval, negOffs, posOffs);
        }

        SubInterval(RandomAccessibleInterval<K> interval, long[] negOffs, long[] posOffs) {
            super(interval);
            this.init(interval, negOffs, posOffs);
        }

        void orient(long[] newKeyPt) {
        }

        private void init(RandomAccessibleInterval<K> interval, long[] negOffs, long[] posOffs) {
        }

        @Override
        public RandomAccess<K> randomAccess() {
            return null;
        }

        @Override
        public RandomAccess<K> randomAccess(Interval interval) {
            return null;
        }
    }

    private static interface ComplexFunction<T> {
        public void evaluate(long[] var1, SubInterval<T> var2, ComplexType<?> var3);

        public T createVariable();
    }
}

