/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.sandbox;

import net.imglib2.ops.util.DataCopier;

public final class Complex
implements Comparable<Complex>,
DataCopier<Complex> {
    private double x = 0.0;
    private double y = 0.0;
    private boolean polarInvalid = true;
    private double r;
    private double theta;

    public static double findPrincipleArgument(double angle) {
        double arg;
        for (arg = angle; arg <= -Math.PI; arg += Math.PI * 2) {
        }
        while (arg > Math.PI) {
            arg -= Math.PI * 2;
        }
        return arg;
    }

    public static Complex createCartesian(double x, double y) {
        Complex c = new Complex();
        c.setCartesian(x, y);
        return c;
    }

    public static Complex createPolar(double r, double theta) {
        Complex c = new Complex();
        c.setPolar(r, theta);
        return c;
    }

    public void setCartesian(double x, double y) {
        this.x = x;
        this.y = y;
        this.polarInvalid = true;
    }

    public void setCartesianX(double x) {
        this.x = x;
        this.polarInvalid = true;
    }

    public void setCartesianY(double y) {
        this.y = y;
        this.polarInvalid = true;
    }

    public void setPolar(double r, double theta) {
        this.r = r;
        this.theta = theta;
        this.calcXY();
        this.polarInvalid = false;
    }

    public void setPolarR(double r) {
        if (this.polarInvalid) {
            this.calcTheta();
        }
        this.r = r;
        this.calcXY();
        this.polarInvalid = false;
    }

    public void setPolarTheta(double theta) {
        if (this.polarInvalid) {
            this.calcR();
        }
        this.theta = theta;
        this.calcXY();
        this.polarInvalid = false;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getModulus() {
        if (this.polarInvalid) {
            this.calcRTheta();
        }
        return this.r;
    }

    public double getArgument() {
        if (this.polarInvalid) {
            this.calcRTheta();
        }
        return this.theta;
    }

    public double getPrincipleArgument() {
        return Complex.findPrincipleArgument(this.getArgument());
    }

    @Override
    public int compareTo(Complex other) {
        double otherVal;
        if (this.x == other.getX() && this.y == other.getY()) {
            return 0;
        }
        double myVal = this.magnitudeSquared();
        if (myVal < (otherVal = other.magnitudeSquared())) {
            return -1;
        }
        if (myVal > otherVal) {
            return 1;
        }
        if (this.x < other.getX()) {
            return -1;
        }
        if (this.x > other.getX()) {
            return 1;
        }
        if (this.y < other.getY()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Complex) {
            Complex other = (Complex)obj;
            return this.x == other.getX() && this.y == other.getY();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        long tmp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(tmp ^ tmp >>> 32);
        tmp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(tmp ^ tmp >>> 32);
        return result;
    }

    @Override
    public void setValue(Complex fromValue) {
        this.setCartesian(fromValue.getX(), fromValue.getY());
    }

    private double magnitudeSquared() {
        return this.x * this.x + this.y * this.y;
    }

    private void calcXY() {
        this.x = this.r * Math.cos(this.theta);
        this.y = this.r * Math.sin(this.theta);
    }

    private void calcRTheta() {
        this.calcR();
        this.calcTheta();
        this.polarInvalid = false;
    }

    private void calcR() {
        this.r = Math.sqrt(this.magnitudeSquared());
    }

    private void calcTheta() {
        this.theta = this.x == 0.0 ? (this.y > 0.0 ? 1.5707963267948966 : (this.y < 0.0 ? -1.5707963267948966 : Double.NaN)) : (this.y == 0.0 ? (this.x > 0.0 ? 0.0 : Math.PI) : Math.atan2(this.y, this.x));
    }
}

