/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.relation.general.binary;

import net.imglib2.ops.relation.BinaryRelation;

public final class XorRelation<T, U>
implements BinaryRelation<T, U> {
    private final BinaryRelation<T, U> rel1;
    private final BinaryRelation<T, U> rel2;

    public XorRelation(BinaryRelation<T, U> rel1, BinaryRelation<T, U> rel2) {
        this.rel1 = rel1;
        this.rel2 = rel2;
    }

    @Override
    public boolean holds(T val1, U val2) {
        boolean twoHolds;
        boolean oneHolds = this.rel1.holds(val1, val2);
        if (oneHolds & !(twoHolds = this.rel2.holds(val1, val2))) {
            return true;
        }
        return !oneHolds & twoHolds;
    }

    @Override
    public XorRelation<T, U> copy() {
        return new XorRelation<T, U>(this.rel1.copy(), this.rel2.copy());
    }
}

