/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.relation.complex.binary;

import net.imglib2.ops.relation.BinaryRelation;
import net.imglib2.type.numeric.ComplexType;

public final class ComplexCartesianNear<T extends ComplexType<T>, U extends ComplexType<U>>
implements BinaryRelation<T, U> {
    private final double rTol;
    private final double iTol;

    public ComplexCartesianNear() {
        this.rTol = 1.0E-6;
        this.iTol = 1.0E-6;
    }

    public ComplexCartesianNear(double rTol, double iTol) {
        this.rTol = rTol;
        this.iTol = iTol;
    }

    @Override
    public boolean holds(T val1, U val2) {
        return Math.abs(val1.getRealDouble() - val2.getRealDouble()) <= this.rTol && Math.abs(val1.getImaginaryDouble() - val2.getImaginaryDouble()) <= this.iTol;
    }

    @Override
    public ComplexCartesianNear<T, U> copy() {
        return new ComplexCartesianNear<T, U>(this.rTol, this.iTol);
    }
}

