/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.pointset;

import net.imglib2.AbstractCursor;
import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;

public class UniversalPointSet
extends AbstractPointSet {
    private final long[] origin = new long[0];

    @Override
    public long[] getOrigin() {
        return this.origin;
    }

    @Override
    public void translate(long[] deltas) {
        this.invalidateBounds();
    }

    @Override
    public PointSetIterator iterator() {
        return new UniversalPointSetIterator();
    }

    @Override
    public int numDimensions() {
        return 0;
    }

    @Override
    protected long[] findBoundMin() {
        return this.origin;
    }

    @Override
    protected long[] findBoundMax() {
        return this.origin;
    }

    @Override
    public boolean includes(long[] point) {
        return true;
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException("UniversalPointSet is infinite in size");
    }

    @Override
    public PointSet copy() {
        return new UniversalPointSet();
    }

    private class UniversalPointSetIterator
    extends AbstractCursor<long[]>
    implements PointSetIterator {
        public UniversalPointSetIterator() {
            super(0);
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public long[] next() {
            throw new UnsupportedOperationException("Cannot iterate over UniversalPointSet");
        }

        @Override
        public void reset() {
        }

        @Override
        public long[] get() {
            throw new UnsupportedOperationException("Cannot get values from a UniversalPointSet");
        }

        @Override
        public void fwd() {
        }

        @Override
        public void localize(long[] position) {
            throw new UnsupportedOperationException("Cannot localize from a UniversalPointSet");
        }

        @Override
        public long getLongPosition(int d) {
            throw new UnsupportedOperationException("Cannot get positions from a UniversalPointSet");
        }

        @Override
        public AbstractCursor<long[]> copy() {
            return new UniversalPointSetIterator();
        }

        @Override
        public AbstractCursor<long[]> copyCursor() {
            return this.copy();
        }
    }
}

