/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.pointset;

import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetDifference;
import net.imglib2.ops.pointset.PointSetIterator;

public class PointSetComplement
extends AbstractPointSet {
    private final PointSet a;
    private final PointSetDifference diff;

    public PointSetComplement(PointSet a) {
        this.a = a;
        long[] min = new long[a.numDimensions()];
        long[] max = (long[])min.clone();
        a.min(min);
        a.max(max);
        HyperVolumePointSet hyper = new HyperVolumePointSet(min, max);
        this.diff = new PointSetDifference(hyper, a);
    }

    @Override
    public long[] getOrigin() {
        return this.diff.getOrigin();
    }

    @Override
    public void translate(long[] deltas) {
        this.diff.translate(deltas);
        this.invalidateBounds();
    }

    @Override
    public PointSetIterator iterator() {
        return this.diff.iterator();
    }

    @Override
    public int numDimensions() {
        return this.diff.numDimensions();
    }

    @Override
    public boolean includes(long[] point) {
        return this.diff.includes(point);
    }

    @Override
    protected long[] findBoundMin() {
        return this.diff.findBoundMin();
    }

    @Override
    protected long[] findBoundMax() {
        return this.diff.findBoundMax();
    }

    @Override
    public long size() {
        return this.diff.size();
    }

    @Override
    public PointSetComplement copy() {
        return new PointSetComplement(this.a.copy());
    }
}

