/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.pointset;

import net.imglib2.AbstractCursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.PointSetIterator;

public class HyperVolumePointSet
extends AbstractPointSet {
    private final long[] origin;
    private final long[] boundMin;
    private final long[] boundMax;
    private final long size;

    public HyperVolumePointSet(long[] origin, long[] negOffsets, long[] posOffsets) {
        int i;
        if (origin.length != negOffsets.length) {
            throw new IllegalArgumentException();
        }
        if (origin.length != posOffsets.length) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < origin.length; ++i) {
            if (negOffsets[i] < 0L) {
                throw new IllegalArgumentException("all offsets must be >= 0");
            }
            if (posOffsets[i] >= 0L) continue;
            throw new IllegalArgumentException("all offsets must be >= 0");
        }
        this.origin = (long[])origin.clone();
        this.boundMin = new long[origin.length];
        this.boundMax = new long[origin.length];
        for (i = 0; i < origin.length; ++i) {
            this.boundMin[i] = origin[i] - negOffsets[i];
            this.boundMax[i] = origin[i] + posOffsets[i];
        }
        this.size = this.calcSize();
    }

    public HyperVolumePointSet(long[] pt1, long[] pt2) {
        if (pt1.length != pt2.length) {
            throw new IllegalArgumentException();
        }
        this.boundMin = new long[pt1.length];
        this.boundMax = new long[pt1.length];
        for (int i = 0; i < pt1.length; ++i) {
            this.boundMin[i] = Math.min(pt1[i], pt2[i]);
            this.boundMax[i] = Math.max(pt1[i], pt2[i]);
        }
        this.origin = (long[])pt1.clone();
        this.size = this.calcSize();
    }

    public HyperVolumePointSet(long[] span) {
        this(new long[span.length], HyperVolumePointSet.lastPoint(span));
    }

    @Override
    public long[] getOrigin() {
        return this.origin;
    }

    @Override
    public void translate(long[] deltas) {
        int i = 0;
        while (i < this.origin.length) {
            long delta = deltas[i];
            int n = i;
            this.origin[n] = this.origin[n] + delta;
            int n2 = i;
            this.boundMin[n2] = this.boundMin[n2] + delta;
            int n3 = i++;
            this.boundMax[n3] = this.boundMax[n3] + delta;
        }
        this.invalidateBounds();
    }

    @Override
    public PointSetIterator iterator() {
        return new HyperVolumePointSetIterator();
    }

    @Override
    public int numDimensions() {
        return this.origin.length;
    }

    @Override
    protected long[] findBoundMin() {
        return this.boundMin;
    }

    @Override
    protected long[] findBoundMax() {
        return this.boundMax;
    }

    @Override
    public boolean includes(long[] point) {
        for (int i = 0; i < this.origin.length; ++i) {
            if (point[i] < this.boundMin[i]) {
                return false;
            }
            if (point[i] <= this.boundMax[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public HyperVolumePointSet copy() {
        return new HyperVolumePointSet(this.findBoundMin(), this.findBoundMax());
    }

    @Override
    public Object iterationOrder() {
        return new FlatIterationOrder(this);
    }

    private static long[] lastPoint(long[] span) {
        long[] lastPoint = new long[span.length];
        for (int i = 0; i < span.length; ++i) {
            lastPoint[i] = span[i] - 1L;
        }
        return lastPoint;
    }

    private long calcSize() {
        long numElements = 1L;
        for (int i = 0; i < this.origin.length; ++i) {
            numElements *= this.boundMax[i] - this.boundMin[i] + 1L;
        }
        return numElements;
    }

    private class HyperVolumePointSetIterator
    extends AbstractCursor<long[]>
    implements PointSetIterator {
        final long[] pos;
        boolean outOfBounds;
        final boolean emptySpace;

        public HyperVolumePointSetIterator() {
            super(HyperVolumePointSet.this.origin.length);
            this.emptySpace = this.n == 0;
            this.outOfBounds = true;
            this.pos = new long[this.n];
        }

        @Override
        public void reset() {
            this.outOfBounds = true;
        }

        @Override
        public boolean hasNext() {
            if (this.emptySpace) {
                return false;
            }
            if (this.outOfBounds) {
                return true;
            }
            for (int i = 0; i < this.n; ++i) {
                if (this.pos[i] >= HyperVolumePointSet.this.boundMax[i]) continue;
                return true;
            }
            return false;
        }

        @Override
        public long[] get() {
            return this.pos;
        }

        @Override
        public void fwd() {
            if (this.outOfBounds) {
                this.outOfBounds = false;
                for (int i = 0; i < this.n; ++i) {
                    this.pos[i] = HyperVolumePointSet.this.boundMin[i];
                }
                return;
            }
            for (int i = 0; i < this.n; ++i) {
                int n = i;
                this.pos[n] = this.pos[n] + 1L;
                if (this.pos[i] <= HyperVolumePointSet.this.boundMax[i]) {
                    return;
                }
                this.pos[i] = HyperVolumePointSet.this.boundMin[i];
            }
            throw new IllegalArgumentException("can't call fwd() beyond last position");
        }

        @Override
        public void localize(long[] position) {
            for (int i = 0; i < this.n; ++i) {
                position[i] = this.pos[i];
            }
        }

        @Override
        public long getLongPosition(int d) {
            return this.pos[d];
        }

        @Override
        public AbstractCursor<long[]> copy() {
            return new HyperVolumePointSetIterator();
        }

        @Override
        public AbstractCursor<long[]> copyCursor() {
            return this.copy();
        }
    }
}

