/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.parse;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imglib2.img.Img;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.parse.EquationParser;
import net.imglib2.ops.parse.Lexer;
import net.imglib2.ops.parse.ParseStatus;
import net.imglib2.ops.parse.ParseUtils;
import net.imglib2.ops.parse.token.CloseRange;
import net.imglib2.ops.parse.token.Comma;
import net.imglib2.ops.parse.token.OpenRange;
import net.imglib2.ops.parse.token.Token;
import net.imglib2.ops.parse.token.Variable;
import net.imglib2.ops.util.Tuple2;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;

public class RealEquationFunctionParser {
    private Map<String, Integer> varMap;
    private EquationParser eqnParser;

    public Tuple2<Function<long[], DoubleType>, String> parse(String specification, Img<? extends RealType<?>> img) {
        this.varMap = new HashMap<String, Integer>();
        this.eqnParser = new EquationParser(this.varMap, img);
        Lexer lexer = new Lexer();
        ParseStatus lexResult = lexer.tokenize(specification, this.varMap);
        if (lexResult.errMsg != null) {
            return new Tuple2<Function<long[], DoubleType>, String>(lexResult.function, lexResult.errMsg);
        }
        ParseStatus parseResult = this.constructFunction(lexResult.tokens);
        return new Tuple2<Function<long[], DoubleType>, String>(parseResult.function, parseResult.errMsg);
    }

    private ParseStatus constructFunction(List<Token> tokens) {
        return this.statement(tokens);
    }

    private ParseStatus statement(List<Token> tokens) {
        if (ParseUtils.match(OpenRange.class, tokens, 0)) {
            ParseStatus status = this.axisNames(tokens, 0);
            if (status.errMsg != null) {
                return status;
            }
            if (ParseUtils.match(Comma.class, tokens, status.tokenNumber)) {
                return this.eqnParser.equation(tokens, status.tokenNumber + 1);
            }
            return ParseUtils.syntaxError(status.tokenNumber, tokens, "Expected comma after axis designations");
        }
        return this.eqnParser.equation(tokens, 0);
    }

    private ParseStatus axisNames(List<Token> tokens, int pos) {
        if (!ParseUtils.match(OpenRange.class, tokens, pos)) {
            return ParseUtils.syntaxError(pos, tokens, "Expected a '[' before axis name definitions");
        }
        ParseStatus status = this.axes(tokens, pos + 1);
        if (status.errMsg != null) {
            return status;
        }
        if (!ParseUtils.match(CloseRange.class, tokens, status.tokenNumber)) {
            return ParseUtils.syntaxError(status.tokenNumber, tokens, "Expected a ']' after axis name definitions");
        }
        return ParseUtils.nextPosition(status.tokenNumber + 1);
    }

    private ParseStatus axes(List<Token> tokens, int pos) {
        if (!ParseUtils.match(Variable.class, tokens, pos)) {
            return ParseUtils.syntaxError(pos, tokens, "Expected a name of an axis");
        }
        Variable var = (Variable)tokens.get(pos);
        int dimIndex = this.varMap.get(var.getText());
        if (dimIndex >= 0) {
            return ParseUtils.syntaxError(pos, tokens, "Cannot declare axis name (" + var.getText() + ") more than once");
        }
        this.varMap.put(var.getText(), -dimIndex - 1);
        if (ParseUtils.match(Comma.class, tokens, pos + 1)) {
            return this.axes(tokens, pos + 2);
        }
        return ParseUtils.nextPosition(pos + 1);
    }
}

