/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.subset.views;

import java.util.ArrayList;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.CalibratedSpace;
import net.imglib2.ops.operation.subset.views.IterableSubsetView;
import net.imglib2.ops.util.metadata.CalibratedSpaceImpl;
import net.imglib2.type.Type;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.IterableRandomAccessibleInterval;
import net.imglib2.view.Views;

public class SubsetViews {
    public static final <T extends Type<T>> IterableRandomAccessibleInterval<T> iterableSubsetView(RandomAccessibleInterval<T> src, Interval interval) {
        return new IterableSubsetView<T>(src, interval);
    }

    public static final <T extends Type<T>> RandomAccessibleInterval<T> subsetView(RandomAccessibleInterval<T> src, Interval interval) {
        boolean oneSizedDims = false;
        for (int d = 0; d < interval.numDimensions(); ++d) {
            if (interval.dimension(d) != 1L) continue;
            oneSizedDims = true;
            break;
        }
        if (SubsetViews.intervalEquals(src, interval) && !oneSizedDims) {
            return src;
        }
        if (!Intervals.contains(src, interval)) {
            throw new IllegalArgumentException("Interval must fit into src in SubsetViews.subsetView(...)");
        }
        IntervalView<T> res = Views.offsetInterval(src, interval);
        for (int d = interval.numDimensions() - 1; d >= 0; --d) {
            if (interval.dimension(d) != 1L || res.numDimensions() <= 1) continue;
            res = Views.hyperSlice(res, d, 0L);
        }
        return res;
    }

    public static <T> RandomAccessibleInterval<T> synchronizeDimensionality(RandomAccessibleInterval<T> src, CalibratedSpace srcSpace, Interval target, CalibratedSpace targetSpace) {
        assert (srcSpace.numDimensions() == src.numDimensions() && target.numDimensions() == targetSpace.numDimensions());
        if (SubsetViews.intervalEquals(src, target) && SubsetViews.spaceEquals(srcSpace, targetSpace)) {
            return src;
        }
        RandomAccessibleInterval<T> res = src;
        CalibratedSpaceImpl resSpace = new CalibratedSpaceImpl(target.numDimensions());
        AxisType[] dispensable = SubsetViews.getDeltaAxisTypes(targetSpace, srcSpace);
        for (int d = dispensable.length - 1; d >= 0; --d) {
            int idx = srcSpace.getAxisIndex(dispensable[d]);
            res = Views.hyperSlice(res, idx, 0L);
        }
        int i = 0;
        block1: for (int d = 0; d < srcSpace.numDimensions(); ++d) {
            for (AxisType type : dispensable) {
                if (d == srcSpace.getAxisIndex(type)) continue block1;
            }
            resSpace.setAxis(srcSpace.axis(d), i++);
        }
        AxisType[] missing = SubsetViews.getDeltaAxisTypes(srcSpace, targetSpace);
        i = srcSpace.numDimensions() - dispensable.length;
        for (AxisType type : missing) {
            int idx = targetSpace.getAxisIndex(type);
            res = Views.addDimension(res, target.min(idx), target.max(idx));
            resSpace.setAxis(type, i++);
        }
        assert (res.numDimensions() == targetSpace.numDimensions());
        RandomAccessible<T> resRndAccessible = res;
        for (int d = 0; d < res.numDimensions(); ++d) {
            int srcIdx = resSpace.getAxisIndex(targetSpace.axis(d));
            if (srcIdx == d) continue;
            resRndAccessible = Views.permute(resRndAccessible, srcIdx, d);
            AxisType tmp = resSpace.axis(d);
            resSpace.setAxis(targetSpace.axis(d), d);
            resSpace.setAxis(tmp, srcIdx);
        }
        return Views.interval(Views.extendBorder(Views.interval(resRndAccessible, target)), target);
    }

    public static <T> RandomAccessibleInterval<T> synchronizeDimensionality(RandomAccessibleInterval<T> src, Interval target) {
        int d;
        RandomAccessibleInterval<T> res = src;
        if (SubsetViews.intervalEquals(src, target)) {
            return res;
        }
        if (res.numDimensions() < target.numDimensions()) {
            for (d = res.numDimensions(); d < target.numDimensions(); ++d) {
                res = Views.addDimension(res, target.min(d), target.max(d));
            }
        } else {
            for (d = res.numDimensions() - 1; d >= target.numDimensions(); --d) {
                res = Views.hyperSlice(res, d, 0L);
            }
        }
        long[] resDims = new long[res.numDimensions()];
        res.dimensions(resDims);
        return Views.interval(Views.extendBorder(res), target);
    }

    private static boolean spaceEquals(CalibratedSpace srcSpace, CalibratedSpace targetSpace) {
        if (srcSpace.numDimensions() != targetSpace.numDimensions()) {
            return false;
        }
        for (int d = 0; d < srcSpace.numDimensions(); ++d) {
            if (srcSpace.axis(d).equals(targetSpace.axis(d))) continue;
            return false;
        }
        return true;
    }

    private static synchronized AxisType[] getDeltaAxisTypes(CalibratedSpace sourceSpace, CalibratedSpace targetSpace) {
        ArrayList<AxisType> delta = new ArrayList<AxisType>();
        for (int d = 0; d < targetSpace.numDimensions(); ++d) {
            AxisType axisType = targetSpace.axis(d);
            if (sourceSpace.getAxisIndex(axisType) != -1) continue;
            delta.add(axisType);
        }
        return delta.toArray(new AxisType[delta.size()]);
    }

    public static synchronized boolean intervalEquals(Interval a, Interval b) {
        if (a.numDimensions() != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < a.numDimensions(); ++d) {
            if (a.min(d) == b.min(d) && a.max(d) == b.max(d)) continue;
            return false;
        }
        return true;
    }
}

