/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.subset.views;

import java.util.Collection;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.labeling.DefaultROIStrategy;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingFactory;
import net.imglib2.labeling.LabelingROIStrategy;
import net.imglib2.labeling.LabelingType;
import net.imglib2.roi.IterableRegionOfInterest;
import net.imglib2.roi.RegionOfInterest;
import net.imglib2.view.IterableRandomAccessibleInterval;
import net.imglib2.view.Views;

public class LabelingView<L extends Comparable<L>>
extends IterableRandomAccessibleInterval<LabelingType<L>>
implements Labeling<L> {
    protected LabelingROIStrategy<L, ? extends Labeling<L>> m_strategy;
    private final LabelingFactory<L> m_fac;
    private final IterableInterval<LabelingType<L>> m_ii;

    public LabelingView(RandomAccessibleInterval<LabelingType<L>> in, LabelingFactory<L> fac) {
        super(in);
        this.m_fac = fac;
        this.m_strategy = new DefaultROIStrategy<L, LabelingView>(this);
        this.m_ii = Views.iterable(in);
    }

    @Override
    public boolean getExtents(L label, long[] minExtents, long[] maxExtents) {
        return this.m_strategy.getExtents(label, minExtents, maxExtents);
    }

    @Override
    public boolean getRasterStart(L label, long[] start) {
        return this.m_strategy.getRasterStart(label, start);
    }

    @Override
    public long getArea(L label) {
        return this.m_strategy.getArea(label);
    }

    @Override
    public Collection<L> getLabels() {
        return this.m_strategy.getLabels();
    }

    @Override
    public Cursor<LabelingType<L>> cursor() {
        return this.m_ii.cursor();
    }

    @Override
    public Cursor<LabelingType<L>> localizingCursor() {
        return this.m_ii.localizingCursor();
    }

    @Override
    public RegionOfInterest getRegionOfInterest(L label) {
        return this.m_strategy.createRegionOfInterest(label);
    }

    @Override
    public IterableRegionOfInterest getIterableRegionOfInterest(L label) {
        return this.m_strategy.createIterableRegionOfInterest(label);
    }

    @Override
    public Labeling<L> copy() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public <LL extends Comparable<LL>> LabelingFactory<LL> factory() {
        return this.m_fac;
    }
}

