/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.subset.views;

import net.imglib2.Cursor;
import net.imglib2.Sampler;
import net.imglib2.type.Type;

class IterableSubsetViewCursor<T extends Type<T>>
implements Cursor<T> {
    private Cursor<T> cursor;
    private int m_typeIdx = 0;
    private int planePos;
    private int planeSize;
    private int numPlaneDims;

    protected IterableSubsetViewCursor(Cursor<T> cursor, int planeSize, int planePos, int numPlaneDims) {
        this.cursor = cursor;
        this.planeSize = planeSize;
        this.planePos = planePos;
        this.numPlaneDims = numPlaneDims;
        this.reset();
    }

    @Override
    public void localize(float[] position) {
        for (int d = 0; d < this.numPlaneDims; ++d) {
            position[d] = this.cursor.getFloatPosition(d);
        }
    }

    @Override
    public void localize(double[] position) {
        for (int d = 0; d < this.numPlaneDims; ++d) {
            position[d] = this.cursor.getDoublePosition(d);
        }
    }

    @Override
    public float getFloatPosition(int d) {
        return this.cursor.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.cursor.getDoublePosition(d);
    }

    @Override
    public int numDimensions() {
        return this.numPlaneDims;
    }

    @Override
    public T get() {
        return (T)((Type)this.cursor.get());
    }

    @Override
    public Sampler<T> copy() {
        return this.cursor.copy();
    }

    @Override
    public void jumpFwd(long steps) {
        this.cursor.jumpFwd((int)steps);
        this.m_typeIdx = (int)((long)this.m_typeIdx + steps);
    }

    @Override
    public void fwd() {
        this.cursor.fwd();
        ++this.m_typeIdx;
    }

    @Override
    public void reset() {
        this.cursor.reset();
        this.cursor.jumpFwd(this.planePos);
        this.m_typeIdx = -1;
    }

    @Override
    public boolean hasNext() {
        return this.m_typeIdx < this.planeSize - 1;
    }

    @Override
    public T next() {
        this.cursor.fwd();
        ++this.m_typeIdx;
        return (T)((Type)this.cursor.get());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported in class: SubsetViewCursor");
    }

    @Override
    public void localize(int[] position) {
        for (int d = 0; d < this.numPlaneDims; ++d) {
            position[d] = this.cursor.getIntPosition(d);
        }
    }

    @Override
    public void localize(long[] position) {
        for (int d = 0; d < this.numPlaneDims; ++d) {
            position[d] = this.cursor.getLongPosition(d);
        }
    }

    @Override
    public int getIntPosition(int d) {
        return this.cursor.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.cursor.getLongPosition(d);
    }

    @Override
    public Cursor<T> copyCursor() {
        return new IterableSubsetViewCursor<T>(this.cursor.copyCursor(), this.planeSize, this.planePos, this.numPlaneDims);
    }
}

